/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get("tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get("snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get("profile");
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, EnumPistonReaction.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, Float.TYPE);

    @Override
    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e2) {
            Debug.echoError(e2);
            return null;
        }
    }

    @Override
    public PlayerProfile getPlayerProfile(Skull skull) {
        ResolvableProfile profile = ((TileEntitySkull)BlockHelperImpl.getTE((CraftSkull)skull)).i;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
        return new PlayerProfile(profile.c().orElse(null), profile.d().orElse(null), property != null ? property.value() : null);
    }

    @Override
    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, new ResolvableProfile(gameProfile));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        skull.update();
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            NBTTagCompound compound = te.b((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    @Override
    public void setNbtData(org.bukkit.block.Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.c(((CompoundTagImpl)ctag).toNMSTag(), (HolderLookup.a)CraftRegistry.getMinecraftRegistry());
    }

    @Override
    public boolean setBlockResistance(Material material, float resistance) {
        Block block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, ReflectionMappingsInfo.BlockBehaviour_explosionResistance, block, Float.valueOf(resistance));
        return true;
    }

    @Override
    public float getBlockResistance(Material material) {
        Block block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, ReflectionMappingsInfo.BlockBehaviour_explosionResistance, block)).floatValue();
    }

    public IBlockData getMaterialBlockState(Material bukkitMaterial) {
        Block nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.m() : null;
    }

    @Override
    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), EnumPistonReaction.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).p;
    }

    @Override
    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void doRandomTick(Location location) {
        Fluid fluid;
        BlockPosition pos = CraftLocation.toBlockPosition((Location)location);
        IChunkAccess nmsChunk = ((CraftChunk)location.getChunk()).getHandle(ChunkStatus.n);
        IBlockData nmsBlock = nmsChunk.a_(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.z()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.A);
        }
        if ((fluid = nmsBlock.y()).f()) {
            fluid.a((World)nmsWorld, pos, nmsWorld.A);
        }
    }

    @Override
    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).E().ordinal()];
    }

    @Override
    public int getExpDrop(org.bukkit.block.Block block, ItemStack item) {
        Block blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    @Override
    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dS();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.c();
            MobSpawnerData toSpawn = nmsSpawner.f;
            NBTTagCompound tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.c();
            MobSpawnerData toSpawn = nmsSpawner.f;
            MobSpawnerData.a rules = skyMin == -1 ? null : new MobSpawnerData.a(new InclusiveRange((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new InclusiveRange((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new MobSpawnerData(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.e = SimpleWeightedRandomList.b();
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

