/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(PacketPlayOutEntityMetadata.class, PacketPlayOutEntityMetadata::b, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(PacketPlayOutUpdateAttributes.class, PacketPlayOutUpdateAttributes::b, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(PacketPlayOutSpawnEntity.class, PacketPlayOutSpawnEntity::b, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(PacketPlayOutEntityTeleport.class, PacketPlayOutEntityTeleport::b, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutEntityLook.class, PacketPlayOutEntity::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.class, PacketPlayOutEntity::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends Packet<PacketListenerPlayOut>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, World level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends Packet<PacketListenerPlayOut>> void registerPacketHandler(Class<T> packetType, BiFunction<T, World, Entity> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            Entity entity = (Entity)entityGetter.apply((Object)packet, (World)networkManager.player.y());
            if (entity == null) {
                return packet;
            }
            Map playerMap = DisguiseCommand.disguises.get(entity.cK());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cK());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.ar() + " to player " + networkManager.player.cM());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e2) {
                antiDuplicate = false;
                throw e2;
            }
        });
    }

    public static PacketPlayOutEntityMetadata processEntityDataPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityMetadata entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.b() == networkManager.player.ar()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (DataWatcher.c dataValue : entityDataPacket.e()) {
                if (dataValue.a() != 0) continue;
                ArrayList<DataWatcher.c<Byte>> newData = new ArrayList<DataWatcher.c<Byte>>(entityDataPacket.e());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new PacketPlayOutEntityMetadata(entityDataPacket.b(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().au().c();
            return data != null ? new PacketPlayOutEntityMetadata(entityDataPacket.b(), data) : null;
        }
        return entityDataPacket;
    }

    public static PacketPlayOutUpdateAttributes processAttributesPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutUpdateAttributes attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.b() == networkManager.player.ar() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static PacketPlayOutEntityTeleport processTeleportPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityTeleport teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            PositionMoveRotation oldChange = teleportEntityPacket.e();
            return new PacketPlayOutEntityTeleport(teleportEntityPacket.b(), new PositionMoveRotation(oldChange.a(), oldChange.b(), EntityAttachmentHelper.normalizeAngle(oldChange.c() + 180.0f), oldChange.d()), teleportEntityPacket.f(), teleportEntityPacket.g());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static PacketPlayOutEntity.PacketPlayOutEntityLook processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntity.PacketPlayOutEntityLook rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new PacketPlayOutEntity.PacketPlayOutEntityLook(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.compressAngle(rotPacket.g() + 180.0f), MathHelper.g((float)rotPacket.h()), rotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.b(), posRotPacket.e(), posRotPacket.f(), EntityAttachmentHelper.compressAngle(posRotPacket.g() + 180.0f), MathHelper.g((float)posRotPacket.h()), posRotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends Packet<PacketListenerPlayOut>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cK())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends Packet<PacketListenerPlayOut>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

