/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import io.papermc.paper.event.entity.EntityMoveEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityStepsOnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public LocationTag location;
    public LocationTag previousLocation;
    public LocationTag newLocation;

    public EntityStepsOnScriptEvent() {
        this.registerCouldMatcher("<entity> steps on <material>");
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return !path.eventLower.startsWith("player");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, (Location)this.location)) {
            return false;
        }
        if (!path.tryArgObject(0, (ObjectTag)this.entity)) {
            return false;
        }
        MaterialTag material = new MaterialTag(this.location.getBlock());
        if (!path.tryArgObject(3, (ObjectTag)material)) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "location" -> this.location;
            case "previous_location" -> this.previousLocation;
            case "new_location" -> this.newLocation;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void entityStepsOnBlockEvent(EntityMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        this.location = new LocationTag(event.getTo().clone().subtract(0.0, 0.05, 0.0));
        if (!Utilities.isLocationYSafe((Location)this.location)) {
            return;
        }
        this.entity = new EntityTag((Entity)event.getEntity());
        this.previousLocation = new LocationTag(event.getFrom());
        this.newLocation = new LocationTag(event.getTo());
        this.fire((Event)event);
    }
}

