/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PrePlayerAttackEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PrePlayerAttackEntityEvent event;
    public EntityTag entity;
    public ItemTag item;

    public PrePlayerAttackEntityScriptEvent() {
        this.registerCouldMatcher("player tries to attack <entity>");
        this.registerSwitches(new String[]{"with"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(4, (ObjectTag)this.entity)) {
            return false;
        }
        if (!path.tryObjectSwitch("with", (ObjectTag)new ItemTag(this.event.getPlayer().getEquipment().getItemInMainHand()))) {
            return false;
        }
        return super.matches(path);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "attacked" -> new ElementTag(this.event.willAttack());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPrePlayerAttackEntity(PrePlayerAttackEntityEvent event) {
        this.event = event;
        this.entity = new EntityTag(event.getAttacked());
        this.fire((Event)event);
    }
}

