/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;

public class AnvilBlockDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public AnvilDamagedEvent event;

    public AnvilBlockDamagedScriptEvent() {
        this.registerCouldMatcher("anvil block damaged|breaks");
        this.registerSwitches(new String[]{"state"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("breaks") && !this.event.isBreaking()) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getInventory().getLocation())) {
            return false;
        }
        if (!AnvilBlockDamagedScriptEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"state", (String)this.event.getDamageState().name())) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "state": {
                return new ElementTag((Enum)this.event.getDamageState());
            }
            case "inventory": {
                return InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
            }
            case "break": {
                return new ElementTag(this.event.isBreaking());
            }
        }
        return super.getContext(name);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String lower = CoreUtilities.toLowerCase((String)determinationObj.toString());
            if (lower.startsWith("state:")) {
                ElementTag stateElement = new ElementTag(lower.substring("state:".length()));
                if (stateElement.matchesEnum(AnvilDamagedEvent.DamageState.class)) {
                    this.event.setDamageState((AnvilDamagedEvent.DamageState)stateElement.asEnum(AnvilDamagedEvent.DamageState.class));
                    return true;
                }
            } else if (lower.startsWith("break:")) {
                this.event.setBreaking(new ElementTag(lower.substring("break:".length())).asBoolean());
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getView().getPlayer());
    }

    @EventHandler
    public void onAnvilDamaged(AnvilDamagedEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

