/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityKnocksbackEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public EntityTag hitBy;
    public ItemTag held;
    public EntityKnockbackByEntityEvent event;

    public EntityKnocksbackEntityScriptEvent() {
        this.registerCouldMatcher("<entity> knocks back <entity>");
        this.registerSwitches(new String[]{"with"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String attacker = path.eventArgLowerAt(0);
        String target = path.eventArgLowerAt(3);
        if (!this.hitBy.tryAdvancedMatcher(attacker, path.context) || !this.entity.tryAdvancedMatcher(target, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.entity.getLocation())) {
            return false;
        }
        if (!EntityKnocksbackEntityScriptEvent.runWithCheck((ScriptEvent.ScriptPath)path, (ItemTag)this.held)) {
            return false;
        }
        return super.matches(path);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(LocationTag.class)) {
            this.event.getAcceleration().copy(((LocationTag)determinationObj.asType(LocationTag.class, (TagContext)this.getTagContext(path))).toVector());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((PlayerTag)(this.hitBy.isPlayer() ? this.hitBy.getDenizenPlayer() : (this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null)), (NPCTag)(this.hitBy.isCitizensNPC() ? this.hitBy.getDenizenNPC() : (this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null)));
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "damager": {
                return this.hitBy.getDenizenObject();
            }
            case "acceleration": {
                return new LocationTag(this.event.getAcceleration());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityKnockbackEntity(EntityKnockbackByEntityEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.hitBy = new EntityTag(event.getHitBy());
        this.held = this.hitBy.getItemInHand();
        this.event = event;
        this.fire((Event)event);
    }
}

