/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class BlockPreDispenseScriptEvent
extends BukkitScriptEvent
implements Listener {
    public BlockPreDispenseEvent event;
    public ItemTag item;
    public LocationTag location;

    public BlockPreDispenseScriptEvent() {
        this.registerCouldMatcher("<block> tries to dispense <item>");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, (Location)this.location)) {
            return false;
        }
        if (!path.tryArgObject(0, (ObjectTag)this.location)) {
            return false;
        }
        if (!path.tryArgObject(4, (ObjectTag)this.item)) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "item" -> this.item;
            case "location" -> this.location;
            case "slot" -> new ElementTag(this.event.getSlot() + 1);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBlockPreDispense(BlockPreDispenseEvent event) {
        this.event = event;
        this.item = new ItemTag(event.getItemStack());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.fire((Event)event);
    }
}

