/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerLecternPageChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerLecternPageChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerLecternPageChangeEvent event;

    public PlayerLecternPageChangeScriptEvent() {
        this.registerCouldMatcher("player flips lectern page");
        this.registerSwitches(new String[]{"book"});
        this.registerOptionalDetermination("page", ElementTag.class, (evt, context, page) -> {
            if (page.isInt()) {
                evt.event.setNewPage(page.asInt() - 1);
                return true;
            }
            return false;
        });
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getLectern().getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("book", (ObjectTag)new ItemTag(this.event.getBook()))) {
            return false;
        }
        return super.matches(path);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "book" -> new ItemTag(this.event.getBook());
            case "lectern" -> new LocationTag(this.event.getLectern().getLocation());
            case "old_page" -> new ElementTag(this.event.getOldPage() + 1);
            case "new_page" -> new ElementTag(this.event.getNewPage() + 1);
            case "flip_direction" -> new ElementTag((Enum)this.event.getPageChangeDirection());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerFlipsLecternPage(PlayerLecternPageChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

