/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_14.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.EnumPistonReaction;
import net.minecraft.server.v1_14_R1.Material;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.TileEntity;
import net.minecraft.server.v1_14_R1.TileEntitySkull;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_14_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftMagicNumbers;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity;
    public static final Field BLOCK_MATERIAL;
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER;
    public static final MethodHandle BLOCK_STRENGTH_SETTER;

    public void applyPhysics(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().applyPhysics(pos, CraftMagicNumbers.getBlock((org.bukkit.Material)location.getBlock().getType()));
    }

    public BlockData parseBlockData(org.bukkit.Material material, String otherData) {
        return CraftBlockData.newData((org.bukkit.Material)material, (String)otherData);
    }

    public List<Location> getBlocksList(PortalCreateEvent event) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (BlockState block : event.getBlocks()) {
            blocks.add(block.getLocation());
        }
        return blocks;
    }

    public <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)this.getTE((CraftSkull)skull)).gameProfile;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        TileEntitySkull tileEntity = (TileEntitySkull)this.getTE((CraftBlockEntityState)((CraftSkull)skull));
        tileEntity.setGameProfile(gameProfile);
        skull.update();
    }

    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(org.bukkit.block.Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
        te.load(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(org.bukkit.Material material, float resistance) {
        Block block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(Block.class, (String)"durability", (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(org.bukkit.Material material) {
        Block block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(Block.class, (String)"durability", (Object)block)).floatValue();
    }

    public BlockState generateBlockState(org.bukkit.block.Block block, org.bukkit.Material mat) {
        CraftBlockState state = new CraftBlockState(block);
        state.setData(CraftMagicNumbers.getBlock((org.bukkit.Material)mat).getBlockData());
        return state;
    }

    public Block getMaterialBlock(org.bukkit.Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().getBlock();
    }

    public Material getInternalMaterial(org.bukkit.Material bukkitMaterial) {
        try {
            return (Material)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public String getPushReaction(org.bukkit.Material mat) {
        return this.getInternalMaterial(mat).getPushReaction().name();
    }

    public void setPushReaction(org.bukkit.Material mat, String reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), EnumPistonReaction.valueOf((String)reaction));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStength(org.bukkit.Material mat) {
        return this.getMaterialBlock((org.bukkit.Material)mat).strength;
    }

    public void setBlockStrength(org.bukkit.Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    static {
        Field f = null;
        try {
            f = CraftBlockEntityState.class.getDeclaredField("tileEntity");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Debug.echoError((Throwable)e);
        }
        craftBlockEntityState_tileEntity = f;
        BLOCK_MATERIAL = ReflectionHelper.getFields(Block.class).get((Object)"material");
        MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetter(Material.class, (String)"R");
        BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetter(Block.class, (String)"strength");
    }
}

