/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_18.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_18.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMob;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(axk.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final yb<Boolean> ENTITY_ENDERMAN_DATAWATCHER_SCREAMING = (yb)ReflectionHelper.getFieldValue(blt.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(axy.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(axy.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final MethodHandle FALLINGBLOCK_TYPE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(blh.class, cov.class);
    public static final Field ZOMBIE_INWATERTIME = ReflectionHelper.getFields(bmw.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
    public static final MethodHandle TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(adj.b.class, Integer.TYPE);

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().j(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().bU();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(ayk.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        ayd monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().er() : ayd.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)bys.a((buw)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (ayd)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            awu source = attacker instanceof Player ? awu.a((boj)((CraftPlayer)attacker).getHandle()) : awu.c((axy)((CraftLivingEntity)attacker).getHandle());
            axk nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.b(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof axy)) {
                return damage;
            }
            axy livingTarget = (axy)nmsTarget;
            damage = aws.a((float)((float)damage), (float)livingTarget.ej(), (float)((float)livingTarget.b(ayz.j)));
            int enchantDamageModifier = bys.a((Iterable)livingTarget.bC(), (awu)source);
            if (enchantDamageModifier > 0) {
                damage = aws.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            axy nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        gj pos = new gj(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().a((cav)((CraftWorld)location.getWorld()).getHandle(), (boj)(craftPlayer != null ? craftPlayer.getHandle() : null), awg.a, new dpk(new dpo(0.0, 0.0, 0.0), null, pos, false));
    }

    public Entity getEntity(World world, UUID uuid) {
        axk entity = ((CraftWorld)world).getHandle().a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public CompoundTag getNbtData(Entity entity) {
        ok compound = new ok();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        axk nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof aya)) {
            return;
        }
        ((aya)nmsEntity).D().n();
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        axk nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof aya)) {
            return;
        }
        final aya nmsFollower = (aya)nmsEntityFollower;
        final bgf followerNavigation = nmsFollower.D();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        djn path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    djn path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.a(ayz.d).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        djn path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        axk nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof aya)) {
            return;
        }
        final aya nmsMob = (aya)nmsEntity;
        final bgf entityNavigation = nmsMob.D();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.bQ.b(bdt.a.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.a(ayz.d).b();
            if (speed != null) {
                nmsMob.a(ayz.d).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.a(ayz.d).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        adj tracker = ((adw)((CraftEntity)entity).getHandle().s).k().a;
        adj.b entityTracker = (adj.b)tracker.J.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (aer player : entityTracker.f) {
            output.add((Player)player.e().getBukkitEntity());
        }
        return output;
    }

    public void sendAllUpdatePackets(Entity entity) {
        adj tracker = ((adw)((CraftEntity)entity).getHandle().s).k().a;
        adj.b entityTracker = (adj.b)tracker.J.get(entity.getEntityId());
        ArrayList output = new ArrayList();
        if (entityTracker == null) {
            return;
        }
        try {
            adv serverEntity = (adv)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        adx entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            adj tracker = ((adw)craftPlayer.getHandle().s).k().a;
            axk other = ((CraftEntity)entity).getHandle();
            adj.b entry = (adj.b)tracker.J.get(other.ae());
            if (entry != null) {
                entry.a(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.b.a((rc)new tm(new int[]{other.ae()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        adx entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            adj tracker = ((adw)craftPlayer.getHandle().s).k().a;
            axk other = ((CraftEntity)entity).getHandle();
            adj.b entry = (adj.b)tracker.J.get(other.ae());
            if (entry != null) {
                entry.a(entityPlayer);
                entry.b(entityPlayer);
            }
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            this.teleport(entity, location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            axk handle = ((CraftEntity)entity).getHandle();
            handle.o(yaw - 360.0f);
            handle.p(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aX;
    }

    public void look(Entity entity, float yaw, float pitch) {
        axk handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.o(yaw);
            if (handle instanceof axy) {
                axy livingHandle = (axy)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aY = yaw;
                if (!(handle instanceof boj)) {
                    livingHandle.m(yaw);
                }
                livingHandle.l(yaw);
            }
            handle.p(pitch);
        } else {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + entity.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dpm rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            dpk dpk2 = ((CraftWorld)world).getHandle().a(new cae(new dpo(start.getX(), start.getY(), start.getZ()), new dpo(end.getX(), end.getY(), end.getZ()), cae.a.b, cae.b.a, null));
            return dpk2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        dpm pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == dpm.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().o(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(aye.a, new dpo(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        tj packet = new tj(dv.a.b, at.getX(), at.getY(), at.getZ());
        PacketHelperImpl.send(player, (rc)packet);
        return true;
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = sx.a((double)vector.getX());
        long y = sx.a((double)vector.getY());
        long z = sx.a((double)vector.getZ());
        sx.a packet = new sx.a(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, (rc)packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        py packetData = new py(Unpooled.buffer());
        packetData.d(entity.getEntityId());
        packetData.writeDouble(location.getX());
        packetData.writeDouble(location.getY());
        packetData.writeDouble(location.getZ());
        packetData.writeByte((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.writeByte((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.writeBoolean(entity.isOnGround());
        va packet = new va(packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, (rc)packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        va packet = new va(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, (rc)packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        axk nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.o(loc.getYaw());
        nmsEntity.p(loc.getPitch());
        if (nmsEntity instanceof adx) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.e(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new dpj(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().S = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            ((bli)((CraftItem)entity).getHandle()).ao = ticks;
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        axy handle = ((CraftLivingEntity)entity).getHandle();
        handle.aZ = angle;
        handle.l(angle);
    }

    public void setGhastAttacking(Ghast ghast, boolean attacking) {
        ((CraftGhast)ghast).getHandle().v(attacking);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().ai().b(ENTITY_ENDERMAN_DATAWATCHER_SCREAMING, (Object)angry);
    }

    public static awu getSourceFor(axk nmsSource, EntityDamageEvent.DamageCause cause) {
        awu src = awu.n;
        if (nmsSource != null) {
            if (nmsSource instanceof boj) {
                src = awu.a((boj)((boj)nmsSource));
            } else if (nmsSource instanceof axy) {
                src = awu.c((axy)((axy)nmsSource));
            }
        }
        if (cause == null) {
            return src;
        }
        switch (cause) {
            case CONTACT: {
                return awu.j;
            }
            case ENTITY_ATTACK: {
                return awu.c((axy)(nmsSource instanceof axy ? (axy)nmsSource : null));
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src != awu.n) {
                    src.sweep();
                }
                return src;
            }
            case PROJECTILE: {
                return awu.b((axk)nmsSource, nmsSource != null && nmsSource.getBukkitEntity() instanceof Projectile && ((Projectile)nmsSource.getBukkitEntity()).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)nmsSource.getBukkitEntity()).getShooter()).getHandle() : null);
            }
            case SUFFOCATION: {
                return awu.f;
            }
            case FALL: {
                return awu.k;
            }
            case FIRE: {
                return awu.a;
            }
            case FIRE_TICK: {
                return awu.c;
            }
            case MELTING: {
                return CraftEventFactory.MELTING;
            }
            case LAVA: {
                return awu.d;
            }
            case DROWNING: {
                return awu.h;
            }
            case BLOCK_EXPLOSION: {
                return awu.d(nmsSource instanceof TNTPrimed && ((TNTPrimed)nmsSource).getSource() instanceof axy ? (axy)((TNTPrimed)nmsSource).getSource() : null);
            }
            case ENTITY_EXPLOSION: {
                return awu.d((axy)(nmsSource instanceof axy ? (axy)nmsSource : null));
            }
            case VOID: {
                return awu.m;
            }
            case LIGHTNING: {
                return awu.b;
            }
            case STARVATION: {
                return awu.i;
            }
            case POISON: {
                return CraftEventFactory.POISON;
            }
            case MAGIC: {
                return awu.o;
            }
            case WITHER: {
                return awu.p;
            }
            case FALLING_BLOCK: {
                return awu.r;
            }
            case THORNS: {
                return awu.a((axk)nmsSource);
            }
            case DRAGON_BREATH: {
                return awu.s;
            }
            case CUSTOM: {
                return awu.n;
            }
            case FLY_INTO_WALL: {
                return awu.l;
            }
            case HOT_FLOOR: {
                return awu.e;
            }
            case CRAMMING: {
                return awu.g;
            }
            case DRYOUT: {
                return awu.t;
            }
        }
        return new FakeDamageSrc(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        axk nmsSource;
        if (target == null) {
            return;
        }
        axy nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        CraftEventFactory.blockDamage = sourceLoc == null ? null : sourceLoc.getBlock();
        try {
            awu src = EntityHelperImpl.getSourceFor(nmsSource, cause);
            if (src instanceof FakeDamageSrc) {
                src = ((FakeDamageSrc)src).real;
                EntityDamageEvent ede = EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount);
                if (ede.isCancelled()) {
                    return;
                }
            }
            nmsTarget.a(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
            CraftEventFactory.blockDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        cov state = ((CraftBlockData)block).getState();
        blh nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_TYPE_SETTER.invoke(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        cnu nmsSpawner = (cnu)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        axk nmsEntity = nmsSpawner.d().a((cav)((CraftWorld)spawner.getWorld()).getHandle());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public void setFireworkLifetime(Firework firework, int ticks) {
        ((CraftFirework)firework).getHandle().f = ticks;
    }

    public int getFireworkLifetime(Firework firework) {
        return ((CraftFirework)firework).getHandle().f;
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            adj map = ((CraftWorld)entity.getWorld()).getHandle().k().a;
            adj.b entry = (adj.b)map.J.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().fu();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().u(aggressive);
    }

    public static class FakeDamageSrc
    extends awu {
        public awu real;

        public FakeDamageSrc(awu src) {
            super("fake");
            this.real = src;
        }
    }
}

