/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_18.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.block.data.type.Bell;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftSkull;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle CRAFTBLOCKSTATE_CONSTRUCTOR = ReflectionHelper.getConstructor(CraftBlockState.class, (Class[])new Class[]{Block.class});
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(cou.class).getFirstOfType(djb.class);
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(djb.class, djd.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(cou.a.class, Float.TYPE);
    public static MethodHandle BLOCKSTATEBASE_GETFLUIDSTATE = ReflectionHelper.getMethodHandle(cou.a.class, (String)ReflectionMappingsInfo.BlockBehaviour_BlockStateBase_getFluidState, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISRANDOMLYTICKING = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_isRandomlyTicking, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISEMPTY = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_isEmpty, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_CREATELEGACYBLOCK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_createLegacyBlock, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ANIMATETICK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_animateTick, (Class[])new Class[]{cav.class, gj.class, Random.class});
    public static MethodHandle HolderSet_Named_bind = ReflectionHelper.getMethodHandle(gt.c.class, (String)ReflectionMappingsInfo.HolderSet_Named_bind, (Class[])new Class[]{List.class});
    public static MethodHandle Holder_Reference_bindTags = ReflectionHelper.getMethodHandle(gs.c.class, (String)ReflectionMappingsInfo.Holder_Reference_bindTags, (Class[])new Class[]{Collection.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        gj pos = new gj(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().b(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends cmr> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((cmr)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((cns)BlockHelperImpl.getTE((CraftSkull)skull)).e;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        cmr te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new gj(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            ok compound = te.m();
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        gj blockPos = new gj(block.getX(), block.getY(), block.getZ());
        cmr te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.a(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        cdq block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(cou.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        cdq block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(cou.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public BlockState generateBlockState(Block block, Material mat) {
        try {
            CraftBlockState state = CRAFTBLOCKSTATE_CONSTRUCTOR.invoke(block);
            state.setData(CraftMagicNumbers.getBlock((Material)mat).n());
            return state;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public cdq getMaterialBlock(Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().b();
    }

    public djb getInternalMaterial(Material bukkitMaterial) {
        try {
            return (djb)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public BlockHelper.PistonPushReaction getPushReaction(Material mat) {
        return BlockHelper.PistonPushReaction.VALUES[this.getInternalMaterial(mat).g().ordinal()];
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), djd.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlock((Material)mat).n().k;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).n(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        gj pos = new gj(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        cra nmsChunk = ((CraftChunk)location.getChunk()).getHandle();
        cov nmsBlock = nmsChunk.a_(pos);
        adw nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.p()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.v);
        }
        try {
            Object fluid = BLOCKSTATEBASE_GETFLUIDSTATE.invoke(nmsBlock);
            if (FLUIDSTATE_ISRANDOMLYTICKING.invoke(fluid)) {
                FLUIDSTATE_ANIMATETICK.invoke(fluid, nmsWorld, pos, nmsWorld.v);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        cdq blockType = this.getMaterialBlock(mat);
        cpw nmsInstrument = cpw.a((cov)blockType.n());
        return Instrument.values()[nmsInstrument.ordinal()];
    }

    public void ringBell(org.bukkit.block.Bell bell) {
        Bell bellData = (Bell)bell.getBlockData();
        go face = CraftBlock.blockFaceToNotch((BlockFace)bellData.getFacing());
        go dir = go.c;
        switch (bellData.getAttachment()) {
            case DOUBLE_WALL: 
            case SINGLE_WALL: {
                switch (face) {
                    case c: 
                    case d: {
                        dir = go.f;
                    }
                }
                break;
            }
            case FLOOR: {
                dir = face;
            }
        }
        CraftBlock craftBlock = (CraftBlock)bell.getBlock();
        ((cdm)cdr.mp).a((cav)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition(), dir);
    }

    public int getExpDrop(Block block, ItemStack item) {
        cdq blockType = this.getMaterialBlock(block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            axk nmsEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            EntityTag entityTag = new EntityTag((Entity)nmsEntity.getBukkitEntity());
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dr();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            cnu nmsSnapshot = (cnu)craftBlockEntityState_snapshot.get(bukkitSpawner);
            bzx nmsSpawner = nmsSnapshot.d();
            cbl toSpawn = nmsSpawner.e;
            ok tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            cnu nmsSnapshot = (cnu)craftBlockEntityState_snapshot.get(bukkitSpawner);
            bzx nmsSpawner = nmsSnapshot.d();
            cbl toSpawn = nmsSpawner.e;
            cbl.a rules = skyMin == -1 ? null : new cbl.a(new ajf((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new ajf((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.e = new cbl(toSpawn.c(), Optional.ofNullable(rules));
            nmsSpawner.d = aus.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Color getMapColor(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((cab)craftBlock.getHandle(), (gj)craftBlock.getPosition()).ak);
    }

    public void setVanillaTags(Material material, Set<String> tags) {
        gs.c nmsHolder = this.getMaterialBlock(material).q();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((gs)nmsHolder, arg_0));
        ArrayList<aif> newNmsTags = new ArrayList<aif>();
        for (String tag : tags) {
            aif newNmsTag = aif.a((ys)hb.h, (yt)new yt(tag));
            gt.c nmsHolderSet = hb.U.b(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HolderSet_Named_bind.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag)new CraftBlockTag((hb)hb.U, newNmsTag));
        }
        try {
            Holder_Reference_bindTags.invoke((gs)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        vf tagsPacket = new vf(aii.a((hc)((CraftServer)Bukkit.getServer()).getServer().aU()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketHelperImpl.send(player, (rc)tagsPacket);
        }
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(gs nmsHolder, aif nmsTag) {
        gt.c nmsHolderSet = hb.U.c(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HolderSet_Named_bind.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag)new CraftBlockTag((hb)hb.U, nmsTag));
    }
}

