/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_19_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R1.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_19_R1.map.CraftMapView;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;

public class PacketHelperImpl
implements PacketHelper {
    public static final DataWatcherObject<Float> ENTITY_HUMAN_DATA_WATCHER_ABSORPTION = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityHuman.class, (String)ReflectionMappingsInfo.Player_DATA_PLAYER_ABSORPTION_ID, null);
    public static final DataWatcherObject<Byte> ENTITY_DATA_WATCHER_FLAGS = (DataWatcherObject)ReflectionHelper.getFieldValue(bbn.class, (String)ReflectionMappingsInfo.Entity_DATA_SHARED_FLAGS_ID, null);
    public static final MethodHandle ABILITIES_PACKET_FOV_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutAbilities.class, (String)ReflectionMappingsInfo.ClientboundPlayerAbilitiesPacket_walkingSpeed);
    public static MethodHandle ENTITY_METADATA_LIST_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(PacketPlayOutEntityMetadata.class, List.class);
    public static Field ENTITY_TRACKER_ENTRY_GETTER = ReflectionHelper.getFields(PlayerChunkMap.EntityTracker.class).getFirstOfType(EntityTrackerEntry.class);
    public static MethodHandle CANVAS_GET_BUFFER = ReflectionHelper.getMethodHandle(CraftMapCanvas.class, (String)"getBuffer", (Class[])new Class[0]);
    public static Field MAPVIEW_WORLDMAP = ReflectionHelper.getFields(CraftMapView.class).get((Object)"worldMap");
    public static MethodHandle BLOCK_ENTITY_DATA_PACKET_CONSTRUCTOR = ReflectionHelper.getConstructor(PacketPlayOutTileEntityData.class, (Class[])new Class[]{BlockPosition.class, TileEntityTypes.class, NBTTagCompound.class});
    public static DataWatcherObject<Optional<IChatBaseComponent>> ENTITY_CUSTOM_NAME_METADATA;
    public static DataWatcherObject<Boolean> ENTITY_CUSTOM_NAME_VISIBLE_METADATA;
    public static HashMap<UUID, HashMap<UUID, ScoreboardTeam>> noCollideTeamMap;

    public void setFakeAbsorption(Player player, float value) {
        DataWatcher dw = new DataWatcher(null);
        dw.a(ENTITY_HUMAN_DATA_WATCHER_ABSORPTION, (Object)Float.valueOf(value));
        PacketHelperImpl.send(player, (tc)new PacketPlayOutEntityMetadata(player.getEntityId(), dw, true));
    }

    public void resetWorldBorder(Player player) {
        cxe wb = ((CraftWorld)player.getWorld()).getHandle().p_();
        PacketHelperImpl.send(player, (tc)new ul(wb));
    }

    public void setWorldBorder(Player player, Location center, double size, double currSize, long time, int warningDistance, int warningTime) {
        cxe wb = new cxe();
        wb.world = ((CraftWorld)player.getWorld()).getHandle();
        wb.c(center.getX(), center.getZ());
        wb.c(warningDistance);
        wb.b(warningTime);
        if (time > 0L) {
            wb.a(currSize, size, time);
        } else {
            wb.a(size);
        }
        PacketHelperImpl.send(player, (tc)new ul(wb));
    }

    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        Container menu = ((CraftPlayer)player).getHandle().bU;
        int windowId = playerOnly ? 0 : menu.j;
        PacketHelperImpl.send(player, (tc)new PacketPlayOutSetSlot(windowId, menu.k(), slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void setFieldOfView(Player player, float fov) {
        PacketPlayOutAbilities packet = new PacketPlayOutAbilities(((CraftPlayer)player).getHandle().fB());
        if (!Float.isNaN(fov)) {
            try {
                ABILITIES_PACKET_FOV_SETTER.invoke(packet, fov);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().b.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.a));
    }

    public void setVision(Player player, EntityType entityType) {
        EntityCreeper entity;
        if (entityType == EntityType.CREEPER) {
            entity = new EntityCreeper(EntityTypes.q, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER) {
            entity = new EntitySpider(EntityTypes.aL, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.CAVE_SPIDER) {
            entity = new EntityCaveSpider(EntityTypes.m, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new EntityEnderman(EntityTypes.y, (World)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.send(player, (tc)new PacketPlayOutSpawnEntity((EntityLiving)entity));
        PacketHelperImpl.send(player, (tc)new PacketPlayOutCamera((bbn)entity));
        ((CraftServer)Bukkit.getServer()).getHandle().respawn(((CraftPlayer)player).getHandle(), ((CraftWorld)player.getWorld()).getHandle(), true, player.getLocation(), false);
    }

    public void showBlockAction(Player player, Location location, int action, int state) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        cjt block = ((CraftWorld)location.getWorld()).getHandle().a_(position).b();
        PacketHelperImpl.send(player, (tc)new PacketPlayOutBlockAction(position, block, action, state));
    }

    public void showBlockCrack(Player player, int id, Location location, int progress) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.send(player, (tc)new PacketPlayOutBlockBreakAnimation(id, position, progress));
    }

    public void showTileEntityData(Player player, Location location, int action, CompoundTag compoundTag) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        try {
            PacketPlayOutTileEntityData packet = BLOCK_ENTITY_DATA_PACKET_CONSTRUCTOR.invoke(position, action, ((CompoundTagImpl)compoundTag).toNMSTag());
            PacketHelperImpl.send(player, (tc)packet);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void showBannerUpdate(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        ArrayList<CompoundTag> nbtPatterns = new ArrayList<CompoundTag>();
        for (Pattern pattern : patterns) {
            nbtPatterns.add(NMSHandler.instance.createCompoundTag(new HashMap()).createBuilder().putInt("Color", (int)pattern.getColor().getDyeData()).putString("Pattern", pattern.getPattern().getIdentifier()).build());
        }
        CompoundTag compoundTag = NMSHandler.blockHelper.getNbtData(location.getBlock()).createBuilder().put("Patterns", (Tag)new JNBTListTag(CompoundTag.class, nbtPatterns)).build();
        this.showTileEntityData(player, location, 3, compoundTag);
    }

    public void showTabListHeaderFooter(Player player, String header, String footer) {
        IChatMutableComponent cHeader = Handler.componentToNMS(FormattedTextHelper.parse((String)header, (ChatColor)ChatColor.WHITE));
        IChatMutableComponent cFooter = Handler.componentToNMS(FormattedTextHelper.parse((String)footer, (ChatColor)ChatColor.WHITE));
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter((IChatBaseComponent)cHeader, (IChatBaseComponent)cFooter);
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void resetTabListHeaderFooter(Player player) {
        this.showTabListHeaderFooter(player, "", "");
    }

    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.send(player, (tc)new ww(fadeInTicks, stayTicks, fadeOutTicks));
        if (title != null) {
            PacketHelperImpl.send(player, (tc)new wv((IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE))));
        }
        if (subtitle != null) {
            PacketHelperImpl.send(player, (tc)new wt((IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse((String)subtitle, (ChatColor)ChatColor.WHITE))));
        }
    }

    public void showEquipment(Player player, LivingEntity entity, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        Pair pair = new Pair((Object)CraftEquipmentSlot.getNMS((EquipmentSlot)equipmentSlot), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack));
        ArrayList<Pair> pairList = new ArrayList<Pair>();
        pairList.add(pair);
        PacketHelperImpl.send(player, (tc)new PacketPlayOutEntityEquipment(entity.getEntityId(), pairList));
    }

    public void resetEquipment(Player player, LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        ArrayList<Pair> pairList = new ArrayList<Pair>();
        pairList.add(new Pair((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getItemInMainHand())));
        pairList.add(new Pair((Object)EnumItemSlot.b, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getItemInOffHand())));
        pairList.add(new Pair((Object)EnumItemSlot.f, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getHelmet())));
        pairList.add(new Pair((Object)EnumItemSlot.e, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getChestplate())));
        pairList.add(new Pair((Object)EnumItemSlot.d, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getLeggings())));
        pairList.add(new Pair((Object)EnumItemSlot.c, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getBoots())));
        PacketHelperImpl.send(player, (tc)new PacketPlayOutEntityEquipment(entity.getEntityId(), pairList));
    }

    public void openBook(Player player, EquipmentSlot hand) {
        PacketHelperImpl.send(player, (tc)new PacketPlayOutOpenBook(hand == EquipmentSlot.OFF_HAND ? EnumHand.b : EnumHand.a));
    }

    public void showHealth(Player player, float health, int food, float saturation) {
        PacketHelperImpl.send(player, (tc)new PacketPlayOutUpdateHealth(health, food, saturation));
    }

    public void showMobHealth(Player player, LivingEntity mob, double health, double maxHealth) {
        AttributeModifiable attr = new AttributeModifiable(GenericAttributes.a, a2 -> {});
        attr.a(maxHealth);
        PacketHelperImpl.send(player, (tc)new PacketPlayOutUpdateAttributes(mob.getEntityId(), Collections.singletonList(attr)));
        PacketDataSerializer healthData = new PacketDataSerializer(Unpooled.buffer());
        healthData.d(mob.getEntityId());
        healthData.writeByte(9);
        healthData.d(2);
        healthData.writeFloat((float)health);
        healthData.writeByte(255);
        PacketHelperImpl.send(player, (tc)new PacketPlayOutEntityMetadata(healthData));
    }

    public void resetHealth(Player player) {
        this.showHealth(player, (float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    public void showExperience(Player player, float experience, int level) {
        PacketHelperImpl.send(player, (tc)new PacketPlayOutExperience(experience, 0, level));
    }

    public void resetExperience(Player player) {
        this.showExperience(player, player.getExp(), player.getLevel());
    }

    public boolean showSignEditor(Player player, Location location) {
        if (location == null) {
            BlockPosition pos;
            LocationTag fakeSign = new LocationTag(player.getLocation());
            fakeSign.setY(0.0);
            FakeBlock.showFakeBlockTo(Collections.singletonList(new PlayerTag(player)), (LocationTag)fakeSign, (MaterialTag)new MaterialTag(Material.OAK_WALL_SIGN), (DurationTag)new DurationTag(1), (boolean)true);
            ((DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().b.b).packetListener.fakeSignExpected = pos = new BlockPosition(fakeSign.getX(), 0.0, fakeSign.getZ());
            PacketHelperImpl.send(player, (tc)new PacketPlayOutOpenSignEditor(pos));
            return true;
        }
        TileEntity tileEntity = ((CraftWorld)location.getWorld()).getHandle().getBlockEntity(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), true);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            PacketHelperImpl.send(player, (tc)sign.c());
            sign.f = true;
            sign.a(player.getUniqueId());
            PacketHelperImpl.send(player, (tc)new PacketPlayOutOpenSignEditor(sign.p()));
            return true;
        }
        return false;
    }

    public void forceSpectate(Player player, Entity entity) {
        PacketHelperImpl.send(player, (tc)new PacketPlayOutCamera(((CraftEntity)entity).getHandle()));
    }

    public static void forceRespawnPlayerEntity(Entity entity, Player viewer) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().s).k().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.K.get(entity.getEntityId());
        if (entityTracker != null) {
            try {
                EntityTrackerEntry entry = (EntityTrackerEntry)ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
                if (entry != null) {
                    entry.a(((CraftPlayer)viewer).getHandle());
                    entry.b(((CraftPlayer)viewer).getHandle());
                }
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void sendRename(Player player, Entity entity, String name, boolean listMode) {
        try {
            if (entity.getType() == EntityType.PLAYER) {
                if (listMode) {
                    PacketHelperImpl.send(player, (tc)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d, new EntityPlayer[]{((CraftPlayer)player).getHandle()}));
                } else {
                    PacketHelperImpl.forceRespawnPlayerEntity(entity, player);
                }
                return;
            }
            DataWatcher fakeData = new DataWatcher(((CraftEntity)entity).getHandle());
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(entity.getEntityId(), fakeData, false);
            ArrayList<DataWatcher.Item> list = new ArrayList<DataWatcher.Item>();
            list.add(new DataWatcher.Item(ENTITY_CUSTOM_NAME_METADATA, Optional.of(Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)))));
            list.add(new DataWatcher.Item(ENTITY_CUSTOM_NAME_VISIBLE_METADATA, (Object)true));
            ENTITY_METADATA_LIST_SETTER.invoke(packet, list);
            PacketHelperImpl.send(player, (tc)packet);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void generateNoCollideTeam(Player player, UUID noCollide) {
        this.removeNoCollideTeam(player, noCollide);
        ScoreboardTeam team = new ScoreboardTeam(SidebarImpl.dummyScoreboard, Utilities.generateRandomColors((int)8));
        team.g().add(noCollide.toString());
        team.a(ScoreboardTeamBase.EnumTeamPush.b);
        HashMap map = noCollideTeamMap.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        map.put(noCollide, team);
        PacketHelperImpl.send(player, (tc)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true));
    }

    public void removeNoCollideTeam(Player player, UUID noCollide) {
        if (noCollide == null || !player.isOnline()) {
            noCollideTeamMap.remove(player.getUniqueId());
            return;
        }
        HashMap<UUID, ScoreboardTeam> map = noCollideTeamMap.get(player.getUniqueId());
        if (map == null) {
            return;
        }
        ScoreboardTeam team = map.remove(noCollide);
        if (team != null) {
            PacketHelperImpl.send(player, (tc)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team));
        }
        if (map.isEmpty()) {
            noCollideTeamMap.remove(player.getUniqueId());
        }
    }

    public void sendEntityMetadataFlagsUpdate(Player player, Entity entity) {
        DataWatcher dw = new DataWatcher(null);
        dw.a(ENTITY_DATA_WATCHER_FLAGS, (Object)((Byte)((CraftEntity)entity).getHandle().ai().a(ENTITY_DATA_WATCHER_FLAGS)));
        PacketHelperImpl.send(player, (tc)new PacketPlayOutEntityMetadata(entity.getEntityId(), dw, true));
    }

    public void sendEntityEffect(Player player, Entity entity, byte effectId) {
        PacketHelperImpl.send(player, (tc)new PacketPlayOutEntityStatus(((CraftEntity)entity).getHandle(), effectId));
    }

    public int getPacketStats(Player player, boolean sent) {
        DenizenNetworkManagerImpl netMan = (DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().b.b;
        return sent ? netMan.packetsSent : netMan.packetsReceived;
    }

    public void setMapData(MapCanvas canvas, byte[] bytes, int x, int y, MapImage image) {
        if (x > 127 || y > 127) {
            return;
        }
        int width = Math.min(image.width, 128 - x);
        int height = Math.min(image.height, 128 - y);
        if (x + width <= 0 || y + height <= 0) {
            return;
        }
        try {
            int x2;
            boolean anyChanged = false;
            byte[] buffer = CANVAS_GET_BUFFER.invoke(canvas);
            int n = x2 = x < 0 ? -x : 0;
            while (x2 < width) {
                int y2;
                int n2 = y2 = y < 0 ? -y : 0;
                while (y2 < height) {
                    int index;
                    byte p = bytes[y2 * image.width + x2];
                    if (p != 0 && buffer[index = (y2 + y) * 128 + (x2 + x)] != p) {
                        buffer[index] = p;
                        anyChanged = true;
                    }
                    ++y2;
                }
                ++x2;
            }
            if (anyChanged) {
                WorldMap map = (WorldMap)MAPVIEW_WORLDMAP.get(canvas.getMapView());
                map.a(Math.max(x, 0), Math.max(y, 0));
                map.a(width + x - 1, height + y - 1);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setNetworkManagerFor(Player player) {
        DenizenNetworkManagerImpl.setNetworkManager(player);
    }

    public void enableNetworkManager() {
        DenizenNetworkManagerImpl.enableNetworkManager();
    }

    public void showDebugTestMarker(Player player, Location location, ColorTag color, String name, int time) {
        MinecraftKey packetKey = new MinecraftKey("minecraft", "debug/game_test_add_marker");
        PacketDataSerializer buf2 = new PacketDataSerializer(Unpooled.buffer());
        buf2.a(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        int colorInt = color.blue | color.green << 8 | color.red << 16 | color.alpha << 24;
        buf2.writeInt(colorInt);
        buf2.a(name.getBytes(StandardCharsets.UTF_8));
        buf2.writeInt(time);
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(packetKey, buf2);
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void clearDebugTestMarker(Player player) {
        MinecraftKey packetKey = new MinecraftKey("minecraft", "debug/game_test_clear");
        PacketDataSerializer buf2 = new PacketDataSerializer(Unpooled.buffer());
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(packetKey, buf2);
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void sendBrand(Player player, String brand) {
        MinecraftKey packetKey = new MinecraftKey("minecraft", "brand");
        PacketDataSerializer buf2 = new PacketDataSerializer(Unpooled.buffer());
        buf2.a(brand);
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(packetKey, buf2);
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void sendCollectItemEntity(Player player, Entity taker, Entity item, int amount) {
        PacketPlayOutCollect packet = new PacketPlayOutCollect(item.getEntityId(), taker.getEntityId(), amount);
        PacketHelperImpl.send(player, (tc)packet);
    }

    public static void send(Player player, tc packet) {
        ((CraftPlayer)player).getHandle().b.a(packet);
    }

    static {
        try {
            ENTITY_CUSTOM_NAME_METADATA = (DataWatcherObject)ReflectionHelper.getFieldValue(bbn.class, (String)ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME, null);
            ENTITY_CUSTOM_NAME_VISIBLE_METADATA = (DataWatcherObject)ReflectionHelper.getFieldValue(bbn.class, (String)ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME_VISIBLE, null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        noCollideTeamMap = new HashMap();
    }
}

