/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_19_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(bbn.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final DataWatcherObject<Boolean> ENTITY_ENDERMAN_DATAWATCHER_SCREAMING = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityEnderman.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(EntityLiving.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(EntityLiving.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final MethodHandle FALLINGBLOCK_TYPE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(EntityFallingBlock.class, IBlockData.class);
    public static final Field ZOMBIE_INWATERTIME = ReflectionHelper.getFields(EntityZombie.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
    public static final MethodHandle TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(PlayerChunkMap.EntityTracker.class, Integer.TYPE);

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().j(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().bX();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(EntityPose.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().ey() : EnumMonsterType.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((cax)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            baw source = attacker instanceof Player ? baw.a((EntityHuman)((CraftPlayer)attacker).getHandle()) : baw.c((EntityLiving)((CraftLivingEntity)attacker).getHandle());
            bbn nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.b(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.eq(), (float)((float)livingTarget.b(GenericAttributes.j)));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.bF(), (baw)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            EntityLiving nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().a((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.a, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, pos, false));
    }

    public Entity getEntity(World world, UUID uuid) {
        bbn entity = ((CraftWorld)world).getHandle().a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    public CompoundTag getNbtData(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).D().n();
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        bbn nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.D();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.a(GenericAttributes.d).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        bbn nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.D();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsEntity, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsEntity.bS.b(PathfinderGoal.Type.a);
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.a(GenericAttributes.d).b();
            if (speed != null) {
                nmsEntity.a(GenericAttributes.d).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsEntity.a(GenericAttributes.d).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().s).k().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.K.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (ahc player : entityTracker.f) {
            output.add((Player)player.f().getBukkitEntity());
        }
        return output;
    }

    public void sendAllUpdatePackets(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().s).k().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.K.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            EntityTrackerEntry serverEntity = (EntityTrackerEntry)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().s).k().a;
            bbn other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.K.get(other.ae());
            if (entry != null) {
                entry.a(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.b.a((tc)new PacketPlayOutEntityDestroy(new int[]{other.ae()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().s).k().a;
            bbn other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.K.get(other.ae());
            if (entry != null) {
                entry.a(entityPlayer);
                entry.b(entityPlayer);
            }
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            this.teleport(entity, location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            bbn handle = ((CraftEntity)entity).getHandle();
            handle.o(yaw - 360.0f);
            handle.p(pitch);
        }
    }

    public float getBaseYaw(Entity entity) {
        bbn handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aX;
    }

    public void look(Entity entity, float yaw, float pitch) {
        bbn handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.o(yaw);
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aY = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.m(yaw);
                }
                livingHandle.l(yaw);
            }
            handle.p(pitch);
        } else {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + entity.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovingObjectPosition rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            MovingObjectPositionBlock movingObjectPositionBlock = ((CraftWorld)world).getHandle().a(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, null));
            return movingObjectPositionBlock;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().o(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(EnumMoveType.a, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        PacketPlayOutLookAt packet = new PacketPlayOutLookAt(ArgumentAnchor.Anchor.b, at.getX(), at.getY(), at.getZ());
        PacketHelperImpl.send(player, (tc)packet);
        return true;
    }

    public static long entityToPacket(double x) {
        return MathHelper.c((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        PacketPlayOutEntity.PacketPlayOutRelEntityMove packet = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, (tc)packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        PacketDataSerializer packetData = new PacketDataSerializer(Unpooled.buffer());
        packetData.d(entity.getEntityId());
        packetData.writeDouble(location.getX());
        packetData.writeDouble(location.getY());
        packetData.writeDouble(location.getZ());
        packetData.writeByte((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.writeByte((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.writeBoolean(entity.isOnGround());
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport(packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, (tc)packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, (tc)packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.o(loc.getYaw());
        nmsEntity.p(loc.getPitch());
        if (nmsEntity instanceof EntityPlayer) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.e(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().S = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            ((EntityItem)((CraftItem)entity).getHandle()).ao = ticks;
        }
    }

    public void setHeadAngle(Entity entity, float angle) {
        EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
        handle.aZ = angle;
        handle.l(angle);
    }

    public void setEndermanAngry(Entity entity, boolean angry) {
        ((CraftEnderman)entity).getHandle().ai().b(ENTITY_ENDERMAN_DATAWATCHER_SCREAMING, (Object)angry);
    }

    public static baw getSourceFor(bbn nmsSource, EntityDamageEvent.DamageCause cause) {
        baw src = baw.n;
        if (nmsSource != null) {
            if (nmsSource instanceof EntityHuman) {
                src = baw.a((EntityHuman)((EntityHuman)nmsSource));
            } else if (nmsSource instanceof EntityLiving) {
                src = baw.c((EntityLiving)((EntityLiving)nmsSource));
            }
        }
        if (cause == null) {
            return src;
        }
        switch (cause) {
            case CONTACT: {
                return baw.j;
            }
            case ENTITY_ATTACK: {
                return baw.c((EntityLiving)(nmsSource instanceof EntityLiving ? (EntityLiving)nmsSource : null));
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src != baw.n) {
                    src.sweep();
                }
                return src;
            }
            case PROJECTILE: {
                return baw.b((bbn)nmsSource, nmsSource.getBukkitEntity() instanceof Projectile && ((Projectile)nmsSource.getBukkitEntity()).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)nmsSource.getBukkitEntity()).getShooter()).getHandle() : null);
            }
            case SUFFOCATION: {
                return baw.f;
            }
            case FALL: {
                return baw.k;
            }
            case FIRE: {
                return baw.a;
            }
            case FIRE_TICK: {
                return baw.c;
            }
            case MELTING: {
                return CraftEventFactory.MELTING;
            }
            case LAVA: {
                return baw.d;
            }
            case DROWNING: {
                return baw.h;
            }
            case BLOCK_EXPLOSION: {
                return baw.d(nmsSource instanceof TNTPrimed && ((TNTPrimed)nmsSource).getSource() instanceof EntityLiving ? (EntityLiving)((TNTPrimed)nmsSource).getSource() : null);
            }
            case ENTITY_EXPLOSION: {
                return baw.d((EntityLiving)(nmsSource instanceof EntityLiving ? (EntityLiving)nmsSource : null));
            }
            case VOID: {
                return baw.m;
            }
            case LIGHTNING: {
                return baw.b;
            }
            case STARVATION: {
                return baw.i;
            }
            case POISON: {
                return CraftEventFactory.POISON;
            }
            case MAGIC: {
                return baw.o;
            }
            case WITHER: {
                return baw.p;
            }
            case FALLING_BLOCK: {
                return baw.r;
            }
            case THORNS: {
                return baw.a((bbn)nmsSource);
            }
            case DRAGON_BREATH: {
                return baw.s;
            }
            case CUSTOM: {
                return baw.n;
            }
            case FLY_INTO_WALL: {
                return baw.l;
            }
            case HOT_FLOOR: {
                return baw.e;
            }
            case CRAMMING: {
                return baw.g;
            }
            case DRYOUT: {
                return baw.t;
            }
        }
        return new FakeDamageSrc(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, Entity source, EntityDamageEvent.DamageCause cause) {
        bbn nmsSource;
        if (target == null) {
            return;
        }
        EntityLiving nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source).getHandle();
        try {
            baw src = EntityHelperImpl.getSourceFor(nmsSource, cause);
            if (src instanceof FakeDamageSrc) {
                src = ((FakeDamageSrc)src).real;
                EntityDamageEvent ede = EntityHelperImpl.fireFakeDamageEvent((Entity)target, (Entity)source, (EntityDamageEvent.DamageCause)cause, (float)amount);
                if (ede.isCancelled()) {
                    return;
                }
            }
            nmsTarget.a(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock entity, BlockData block) {
        IBlockData state = ((CraftBlockData)block).getState();
        EntityFallingBlock nmsEntity = ((CraftFallingBlock)entity).getHandle();
        try {
            FALLINGBLOCK_TYPE_SETTER.invoke(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        TileEntityMobSpawner nmsSpawner = (TileEntityMobSpawner)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        bbn nmsEntity = nmsSpawner.d().a((net.minecraft.world.level.World)((CraftWorld)spawner.getWorld()).getHandle());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public void setFireworkLifetime(Firework firework, int ticks) {
        ((CraftFirework)firework).getHandle().f = ticks;
    }

    public int getFireworkLifetime(Firework firework) {
        return ((CraftFirework)firework).getHandle().f;
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            PlayerChunkMap map = ((CraftWorld)entity.getWorld()).getHandle().k().a;
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)map.K.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().fC();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().u(aggressive);
    }

    public static class FakeDamageSrc
    extends baw {
        public baw real;

        public FakeDamageSrc(baw src) {
            super("fake");
            this.real = src;
        }
    }
}

