/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ProfileEditorImpl
extends ProfileEditor {
    public static final Field ClientboundPlayerInfoUpdatePacket_entries = ReflectionHelper.getFields(ClientboundPlayerInfoUpdatePacket.class).getFirstOfType(List.class);

    protected void updatePlayer(Player player, boolean isSkinChanging) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        UUID uuid = player.getUniqueId();
        ClientboundPlayerInfoRemovePacket removePlayerInfoPacket = new ClientboundPlayerInfoRemovePacket(List.of(uuid));
        ClientboundPlayerInfoUpdatePacket addPlayerInfoPacket = ClientboundPlayerInfoUpdatePacket.a(List.of(nmsPlayer));
        for (Player otherPlayer : Bukkit.getServer().getOnlinePlayers()) {
            PacketHelperImpl.send(otherPlayer, removePlayerInfoPacket);
            PacketHelperImpl.send(otherPlayer, addPlayerInfoPacket);
        }
        for (Player otherPlayer : NMSHandler.entityHelper.getPlayersThatSee((Entity)player)) {
            if (otherPlayer.getUniqueId().equals(uuid)) continue;
            PacketHelperImpl.forceRespawnPlayerEntity((Entity)player, otherPlayer);
        }
        if (isSkinChanging) {
            ((CraftServer)Bukkit.getServer()).getHandle().respawn(nmsPlayer, (WorldServer)nmsPlayer.H, true, player.getLocation(), false, PlayerRespawnEvent.RespawnReason.PLUGIN);
        }
        player.updateInventory();
    }

    public static boolean handleAlteredProfiles(ClientboundPlayerInfoUpdatePacket packet, DenizenNetworkManagerImpl manager) {
        if (ProfileEditor.mirrorUUIDs.isEmpty() && !RenameCommand.hasAnyDynamicRenames() && fakeProfiles.isEmpty()) {
            return true;
        }
        EnumSet actions = packet.a();
        if (!actions.contains(ClientboundPlayerInfoUpdatePacket.a.a) && !actions.contains(ClientboundPlayerInfoUpdatePacket.a.f)) {
            return true;
        }
        try {
            boolean any = false;
            for (ClientboundPlayerInfoUpdatePacket.b entry : packet.c()) {
                if (!ProfileEditor.mirrorUUIDs.contains(entry.a()) && !RenameCommand.customNames.containsKey(entry.a()) && !fakeProfiles.containsKey(entry.a())) continue;
                any = true;
                break;
            }
            if (!any) {
                return true;
            }
            GameProfile ownProfile = manager.player.fI();
            for (ClientboundPlayerInfoUpdatePacket.b data : packet.c()) {
                if (!(ProfileEditor.mirrorUUIDs.contains(data.a()) || RenameCommand.customNames.containsKey(data.a()) || fakeProfiles.containsKey(data.a()))) {
                    manager.oldManager.a((Packet)ProfileEditorImpl.createInfoPacket(actions, List.of(data)));
                    continue;
                }
                String rename = RenameCommand.getCustomNameFor((UUID)data.a(), (Player)manager.player.getBukkitEntity(), (boolean)false);
                GameProfile baseProfile = fakeProfiles.containsKey(data.a()) ? ProfileEditorImpl.getGameProfile((PlayerProfile)fakeProfiles.get(data.a())) : data.b();
                GameProfile patchedProfile = new GameProfile(baseProfile.getId(), rename != null ? (rename.length() > 16 ? rename.substring(0, 16) : rename) : baseProfile.getName());
                if (ProfileEditor.mirrorUUIDs.contains(data.a())) {
                    patchedProfile.getProperties().putAll((Multimap)ownProfile.getProperties());
                } else {
                    patchedProfile.getProperties().putAll((Multimap)baseProfile.getProperties());
                }
                String listRename = RenameCommand.getCustomNameFor((UUID)data.a(), (Player)manager.player.getBukkitEntity(), (boolean)true);
                IChatBaseComponent displayName = listRename != null ? Handler.componentToNMS(FormattedTextHelper.parse((String)listRename, (ChatColor)ChatColor.WHITE)) : data.f();
                ClientboundPlayerInfoUpdatePacket.b newData = new ClientboundPlayerInfoUpdatePacket.b(data.a(), patchedProfile, data.c(), data.d(), data.e(), displayName, data.g());
                manager.oldManager.a((Packet)ProfileEditorImpl.createInfoPacket(actions, List.of(newData)));
            }
            return false;
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
            return true;
        }
    }

    public static ClientboundPlayerInfoUpdatePacket createInfoPacket(EnumSet<ClientboundPlayerInfoUpdatePacket.a> actions, List<ClientboundPlayerInfoUpdatePacket.b> entries) {
        ClientboundPlayerInfoUpdatePacket playerInfoUpdatePacket = new ClientboundPlayerInfoUpdatePacket(actions, List.of());
        try {
            ClientboundPlayerInfoUpdatePacket_entries.set(playerInfoUpdatePacket, entries);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        return playerInfoUpdatePacket;
    }

    private static GameProfile getGameProfile(PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        return gameProfile;
    }
}

