/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemHelperImpl
extends ItemHelper {
    public static Field RECIPE_MANAGER_BY_NAME = ReflectionHelper.getFields(cjd.class).get(ReflectionMappingsInfo.RecipeManager_byName, Map.class);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static cjc<?> getNMSRecipe(NamespacedKey key) {
        acq nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().aE().c.values()) {
            cjc recipe = (cjc)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(cfu.class, (String)ReflectionMappingsInfo.Item_maxStackSize).invoke((cfu)jb.i.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return (Integer)czc.f().get(CraftMagicNumbers.getItem((Material)material));
    }

    public void clearDenizenRecipes() {
        Map byName;
        cjd recipeManager = ((CraftServer)Bukkit.getServer()).getServer().aE();
        try {
            byName = (Map)RECIPE_MANAGER_BY_NAME.get(recipeManager);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return;
        }
        for (Object2ObjectLinkedOpenHashMap recipeMap : recipeManager.c.values()) {
            for (acq key : new ArrayList(recipeMap.keySet())) {
                if (!key.b().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
                byName.remove(key);
            }
        }
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static ciz itemArrayToRecipe(ItemStack[] items, boolean exact) {
        ciz.a[] stacks = new ciz.a[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new ciz.a(CraftItemStack.asNMSCopy((ItemStack)items[i]));
        }
        ciz itemRecipe = new ciz(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        cir categoryValue;
        acq key = new acq("denizen", keyName);
        ciz itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        cir cir2 = categoryValue = category == null ? cir.c : cir.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new cjs(key, group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new cio(key, group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new ciq(key, group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new cjo(key, group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe((cjc)recipe);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        acq key = new acq("denizen", keyName);
        ciz itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        cjt recipe = new cjt(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe((cjc)recipe);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact) {
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        acq key = new acq("denizen", keyName);
        ArrayList<ciz> ingredientList = new ArrayList<ciz>();
        cis categoryValue = category == null ? cis.d : cis.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        cji recipe = new cji(key, group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), hn.a(null, (Object[])ingredientList.toArray(new ciz[0])));
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe((cjc)recipe);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).J().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        qr tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).v();
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        qr tag;
        cfz itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.u() && (tag = itemStack.v()).b("SkullOwner", 10) && (profile = rd.a((qr)tag.p("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        cfz nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        qr tag = (nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack)).u() ? nmsItemStack.v() : new qr();
        tag.a("SkullOwner", (rk)rd.a((qr)new qr(), (GameProfile)gameProfile));
        nmsItemStack.c(tag);
        return CraftItemStack.asBukkitCopy((cfz)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        qr tag = nmsItemStack.u() ? nmsItemStack.v() : new qr();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.c(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((cfz)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.u()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.v());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.c(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((cfz)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().m == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(rd.a((UUID)id).g());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return rd.a((rk)new qv(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        String jsonText = ((qr)nmsItemStack.v().c("display")).l("Name");
        try {
            BaseComponent[] nameComponent = ComponentSerializer.parse((String)jsonText);
            return FormattedTextHelper.stringify((BaseComponent[])nameComponent);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        qx list = ((qr)nmsItemStack.v().c("display")).c("Lore", 8);
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                BaseComponent[] lineComponent = ComponentSerializer.parse((String)list.j(i));
                outList.add(FormattedTextHelper.stringify((BaseComponent[])lineComponent));
                continue;
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        qr tag = nmsItemStack.w();
        qr display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (rk)display);
        }
        if (name == null || name.isEmpty()) {
            display.a("Name", null);
            return;
        }
        BaseComponent[] components = FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE);
        display.a("Name", (rk)ri.a((String)FormattedTextHelper.componentToJson((BaseComponent[])components)));
        item.setItemStack(CraftItemStack.asBukkitCopy((cfz)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        cfz nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        qr tag = nmsItemStack.w();
        qr display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (rk)display);
        }
        if (lore == null || lore.isEmpty()) {
            display.a("Lore", null);
        } else {
            qx tagList = new qx();
            for (String line : lore) {
                tagList.add((Object)ri.a((String)FormattedTextHelper.componentToJson((BaseComponent[])FormattedTextHelper.parse((String)line, (ChatColor)ChatColor.WHITE))));
            }
            display.a("Lore", (rk)tagList);
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cfz)nmsItemStack));
    }

    public static dcb getCorrectStateForFluidBlock(cmm world, dcb iblockdata, gu blockposition) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            boolean isEmpty = BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
            if (!isEmpty && !iblockdata.d((cls)world, blockposition, ha.b)) {
                return BlockHelperImpl.FLUIDSTATE_CREATELEGACYBLOCK.invoke(fluid);
            }
            return iblockdata;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return iblockdata;
        }
    }

    public static boolean blockStateFluidIsEmpty(dcb iblockdata) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            return BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return false;
        }
    }

    public static void renderFullMap(dyo worldmap, int xMin, int zMin, int xMax, int zMax) {
        aif world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                dxi materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                dei chunk = world.l(new gu(k2, 0, l2));
                if (chunk.C()) continue;
                clt chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.x_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)cpo.j.n().d((cls)world, gu.b), 10);
                    } else {
                        multiset.add((Object)cpo.b.n().d((cls)world, gu.b), 100);
                    }
                    d1 = 100.0;
                } else {
                    gu.a blockposition_mutableblockposition = new gu.a();
                    gu.a blockposition_mutableblockposition1 = new gu.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            dcb iblockdata;
                            int k4 = chunk.a(dhk.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.C_() + 1) {
                                iblockdata = cpo.F.n();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((gu)blockposition_mutableblockposition)).d((cls)world, (gu)blockposition_mutableblockposition) == dxi.a && k4 > world.C_());
                                if (k4 > world.C_() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata)) {
                                    dcb iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((hz)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((gu)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.C_() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata1));
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((cmm)world, iblockdata, (gu)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((cls)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.d((cls)world, (gu)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (dxi)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)dxi.a)) == dxi.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        dyo worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(cmm.h).a("map_" + mapId);
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        cfu nmsItem = jb.i.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof cds) {
            cpn block = ((cds)nmsItem).e();
            return CraftBlockData.fromData((dcb)block.n());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        cfz nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        cfz nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return chx.a((cfz)nmsInput, (cfz)nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(chx.class, (String)"CUSTOM_MIXES", null)), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = CraftRecipe.toBukkit((ciz)((ciz)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix)));
                RecipeChoice input = CraftRecipe.toBukkit((ciz)((ciz)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix)));
                ItemStack result = CraftItemStack.asBukkitCopy((cfz)((cfz)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(ingredient, input, result);
            });
        }
        return customBrewingRecipes;
    }
}

