/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.EntityMetadataPacketHandlers;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id, Integer.TYPE);
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x, Double.TYPE);
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y, Double.TYPE);
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z, Double.TYPE);
    public static Field YAW_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot, Byte.TYPE);
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityMetadata.class, DisguisePacketHandlers::processDisguiseForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutUpdateAttributes.class, DisguisePacketHandlers::processDisguiseForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutNamedEntitySpawn.class, DisguisePacketHandlers::processDisguiseForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutSpawnEntity.class, DisguisePacketHandlers::processDisguiseForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityTeleport.class, DisguisePacketHandlers::processDisguiseForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutEntityLook.class, DisguisePacketHandlers::processDisguiseForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.class, DisguisePacketHandlers::processDisguiseForPacket);
    }

    public static Packet<PacketListenerPlayOut> processDisguiseForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
            return packet;
        }
        try {
            PacketPlayOutEntity moveEntityPacket;
            Entity e;
            int entityID = -1;
            if (packet instanceof PacketPlayOutEntityMetadata) {
                PacketPlayOutEntityMetadata entityDataPacket = (PacketPlayOutEntityMetadata)packet;
                entityID = entityDataPacket.a();
            }
            if (packet instanceof PacketPlayOutUpdateAttributes) {
                PacketPlayOutUpdateAttributes updateAttributesPacket = (PacketPlayOutUpdateAttributes)packet;
                entityID = updateAttributesPacket.a();
            }
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                PacketPlayOutNamedEntitySpawn addPlayerPacket = (PacketPlayOutNamedEntitySpawn)packet;
                entityID = addPlayerPacket.a();
            } else if (packet instanceof PacketPlayOutSpawnEntity) {
                PacketPlayOutSpawnEntity addEntityPacket = (PacketPlayOutSpawnEntity)packet;
                entityID = addEntityPacket.a();
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                PacketPlayOutEntityTeleport teleportEntityPacket = (PacketPlayOutEntityTeleport)packet;
                entityID = teleportEntityPacket.a();
            } else if (packet instanceof PacketPlayOutEntity && (e = (moveEntityPacket = (PacketPlayOutEntity)packet).a(networkManager.player.dI())) != null) {
                entityID = e.af();
            }
            if (entityID == -1) {
                return packet;
            }
            Entity entity = networkManager.player.dI().a(entityID);
            if (entity == null) {
                return packet;
            }
            HashMap playerMap = (HashMap)DisguiseCommand.disguises.get(entity.ct());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.ct());
            if (disguise == null && (disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null)) == null) {
                return packet;
            }
            if (!disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entityID + " to player " + networkManager.player.cv());
            }
            if (packet instanceof PacketPlayOutEntityMetadata) {
                PacketPlayOutEntityMetadata metadataPacket = (PacketPlayOutEntityMetadata)packet;
                if (entityID == networkManager.player.af()) {
                    if (!disguise.shouldFake) {
                        return packet;
                    }
                    data = metadataPacket.c();
                    for (DataWatcher.b dataValue : data) {
                        if (dataValue.a() != 0) continue;
                        data = new ArrayList<DataWatcher.b>(data);
                        data.remove(dataValue);
                        byte flags = (Byte)dataValue.c();
                        flags = (byte)(flags | 0x20);
                        data.add(new DataWatcher.b(dataValue.a(), dataValue.b(), (Object)flags));
                        PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata(metadataPacket.a(), data);
                        PacketPlayOutEntityMetadata updatedPacket = EntityMetadataPacketHandlers.getModifiedMetadataFor(networkManager, altPacket);
                        return updatedPacket == null ? altPacket : updatedPacket;
                    }
                } else {
                    data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().aj().c();
                    return data != null ? new PacketPlayOutEntityMetadata(entityID, (List)data) : null;
                }
                return packet;
            }
            if (packet instanceof PacketPlayOutUpdateAttributes) {
                FakeEntity fake;
                FakeEntity fakeEntity = fake = entityID == networkManager.player.af() ? disguise.fakeToSelf : disguise.toOthers;
                if (fake == null) {
                    return packet;
                }
                if (fake.entity.entity instanceof LivingEntity) {
                    return packet;
                }
                return null;
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
                    pOld = (PacketPlayOutEntityTeleport)packet;
                    PacketPlayOutEntityTeleport pNew = new PacketPlayOutEntityTeleport(entity);
                    ENTITY_ID_PACKTELENT.setInt(pNew, pOld.a());
                    POS_X_PACKTELENT.setDouble(pNew, pOld.c());
                    POS_Y_PACKTELENT.setDouble(pNew, pOld.d());
                    POS_Z_PACKTELENT.setDouble(pNew, pOld.e());
                    YAW_PACKTELENT.setByte(pNew, EntityAttachmentHelper.adaptedCompressedAngle((byte)pOld.f(), (float)180.0f));
                    PITCH_PACKTELENT.setByte(pNew, pOld.g());
                    return pNew;
                }
            } else if (packet instanceof PacketPlayOutEntity && disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
                pOld = (PacketPlayOutEntity)packet;
                PacketPlayOutEntity.PacketPlayOutEntityLook pNew = null;
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(entityID, EntityAttachmentHelper.adaptedCompressedAngle((byte)pOld.e(), (float)180.0f), pOld.f(), pOld.i());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(entityID, pOld.a(), pOld.c(), pOld.d(), EntityAttachmentHelper.adaptedCompressedAngle((byte)pOld.e(), (float)180.0f), pOld.f(), pOld.i());
                }
                if (pNew != null) {
                    return pNew;
                }
                return packet;
            }
            antiDuplicate = true;
            disguise.sendTo(List.of(new PlayerTag(networkManager.player.ct())));
            antiDuplicate = false;
            return null;
        }
        catch (Throwable ex) {
            antiDuplicate = false;
            Debug.echoError((Throwable)ex);
            return packet;
        }
    }
}

