/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bfj>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bfj>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bfj> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k2 -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bfj> entityClass, String name) {
        Class<? extends bfj> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bfj.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bfj.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bfj.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bfj.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bfj.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bfj.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bfj.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bfj.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bfu.class, 8, "width");
        EntityDataNameMapper.registerDataName(bfu.class, 9, "height");
        EntityDataNameMapper.registerDataName(bfu.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bfi.class, 8, "interpolation_delay");
        EntityDataNameMapper.registerDataName(bfi.class, 9, "interpolation_duration");
        EntityDataNameMapper.registerDataName(bfi.class, 10, "translation");
        EntityDataNameMapper.registerDataName(bfi.class, 11, "scale");
        EntityDataNameMapper.registerDataName(bfi.class, 12, "left_rotation");
        EntityDataNameMapper.registerDataName(bfi.class, 13, "right_rotation");
        EntityDataNameMapper.registerDataName(bfi.class, 14, "billboard");
        EntityDataNameMapper.registerDataName(bfi.class, 15, "brightness");
        EntityDataNameMapper.registerDataName(bfi.class, 16, "view_range");
        EntityDataNameMapper.registerDataName(bfi.class, 17, "shadow_radius");
        EntityDataNameMapper.registerDataName(bfi.class, 18, "shadow_strength");
        EntityDataNameMapper.registerDataName(bfi.class, 19, "width");
        EntityDataNameMapper.registerDataName(bfi.class, 20, "height");
        EntityDataNameMapper.registerDataName(bfi.class, 21, "glow_color");
        EntityDataNameMapper.registerDataName(bfi.b.class, 22, "material");
        EntityDataNameMapper.registerDataName(bfi.g.class, 22, "item");
        EntityDataNameMapper.registerDataName(bfi.g.class, 23, "model_transform");
        EntityDataNameMapper.registerDataName(bfi.k.class, 22, "text");
        EntityDataNameMapper.registerDataName(bfi.k.class, 23, "line_width");
        EntityDataNameMapper.registerDataName(bfi.k.class, 24, "background_color");
        EntityDataNameMapper.registerDataName(bfi.k.class, 25, "text_opacity");
        EntityDataNameMapper.registerDataName(bfi.k.class, 26, "text_display_flags");
        EntityDataNameMapper.registerDataName(bzn.class, 8, "item");
        EntityDataNameMapper.registerDataName(byz.class, 8, "item");
        EntityDataNameMapper.registerDataName(bzb.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bfg.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bfg.class, 9, "color");
        EntityDataNameMapper.registerDataName(bfg.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bfg.class, 11, "particle");
        EntityDataNameMapper.registerDataName(bzc.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(bzc.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(byu.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(byu.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(byw.class, 10, "color");
        EntityDataNameMapper.registerDataName(bzs.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(bzs.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cah.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cah.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cah.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cah.class, 11, "type");
        EntityDataNameMapper.registerDataName(cah.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cah.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cah.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(bua.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(bua.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(bzj.class, 8, "item");
        EntityDataNameMapper.registerDataName(bza.class, 8, "item");
        EntityDataNameMapper.registerDataName(bzt.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(bzb.class, 8, "item");
        EntityDataNameMapper.registerDataName(bzb.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(bzb.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(bva.class, 8, "item");
        EntityDataNameMapper.registerDataName(bva.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(bvc.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(bfz.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(bfz.class, 9, "health");
        EntityDataNameMapper.registerDataName(bfz.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(bfz.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(bfz.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(bfz.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(bfz.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(byo.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(byo.class, 16, "score");
        EntityDataNameMapper.registerDataName(byo.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(byo.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(byo.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(byo.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(bux.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(bux.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(bux.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(bux.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(bux.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(bux.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(bux.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(bgb.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(brg.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(brt.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(brt.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(brt.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(bri.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(bse.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(bsl.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bfe.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(btx.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(btx.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(btk.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(btm.class, 18, "variant");
        EntityDataNameMapper.registerDataName(bsx.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(bsx.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(btj.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(btn.class, 19, "strength");
        EntityDataNameMapper.registerDataName(btn.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(btn.class, 21, "variant");
        EntityDataNameMapper.registerDataName(bss.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bss.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(bss.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(brm.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(brm.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(brv.class, 17, "type");
        EntityDataNameMapper.registerDataName(brv.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(brv.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(brv.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(bta.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bta.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(brz.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(bsa.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(bsa.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(bsa.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(bsa.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(bsa.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(bsa.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(bsc.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(bsc.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(bsf.class, 17, "type");
        EntityDataNameMapper.registerDataName(bsm.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(bsm.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(bsm.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(bsm.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(bsm.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(bsm.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(bsd.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(bwy.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(bry.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bsh.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(bwp.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(bwp.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(bwp.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bgv.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bgv.class, 18, "owner");
        EntityDataNameMapper.registerDataName(bro.class, 19, "variant");
        EntityDataNameMapper.registerDataName(bro.class, 20, "lying");
        EntityDataNameMapper.registerDataName(bro.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(bro.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(bso.class, 19, "begging");
        EntityDataNameMapper.registerDataName(bso.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(bso.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(bsb.class, 19, "variant");
        EntityDataNameMapper.registerDataName(bxw.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(byb.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(brx.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(bsj.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(bwi.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(bwi.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(bwi.class, 18, "peek");
        EntityDataNameMapper.registerDataName(bwi.class, 19, "color");
        EntityDataNameMapper.registerDataName(bxd.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(bxe.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(bxe.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(bxe.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(bvm.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(bvo.class, 16, "state");
        EntityDataNameMapper.registerDataName(bvo.class, 17, "charged");
        EntityDataNameMapper.registerDataName(bvo.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(btg.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(btg.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(btg.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(bvy.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(bvy.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(bzw.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(bwf.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(bwm.class, 17, "spell");
        EntityDataNameMapper.registerDataName(bws.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(bwq.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(bwn.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(bxs.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(buv.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(buv.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(buv.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(buv.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(bwu.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(bwv.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(bwv.class, 17, "type");
        EntityDataNameMapper.registerDataName(bwv.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(bww.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(bww.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(bvs.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(bvs.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(bvs.class, 18, "staring");
        EntityDataNameMapper.registerDataName(bub.class, 16, "phase");
        EntityDataNameMapper.registerDataName(bvw.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(bwe.class, 16, "size");
        EntityDataNameMapper.registerDataName(bwl.class, 16, "size");
        EntityDataNameMapper.registerDataName(caf.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(caf.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(caf.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(caf.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(caf.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(caf.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cao.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(can.class, 14, "command");
        EntityDataNameMapper.registerDataName(can.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(bvi.class, 8, "fuse_ticks");
    }
}

