/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    public static final Field TELEPORT_PACKET_ENTITY_ID = ReflectionHelper.getFields(ys.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id, Integer.TYPE);
    public static final Field TELEPORT_PACKET_X = ReflectionHelper.getFields(ys.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x, Double.TYPE);
    public static final Field TELEPORT_PACKET_Y = ReflectionHelper.getFields(ys.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y, Double.TYPE);
    public static final Field TELEPORT_PACKET_Z = ReflectionHelper.getFields(ys.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z, Double.TYPE);
    public static final Field TELEPORT_PACKET_YAW = ReflectionHelper.getFields(ys.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    public static final Field TELEPORT_PACKET_PITCH = ReflectionHelper.getFields(ys.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot, Byte.TYPE);
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(xw.class, xw::a, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(yu.class, yu::a, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(uu.class, uu::a, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(us.class, us::a, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(ys.class, ys::a, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(wl.c.class, wl::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(wl.b.class, wl::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends uo<ur>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, cmm level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends uo<ur>> void registerPacketHandler(Class<T> packetType, BiFunction<T, cmm, bfj> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            bfj entity = (bfj)entityGetter.apply(packet, networkManager.player.dI());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.ct());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.ct());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.af() + " to player " + networkManager.player.cv());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e) {
                antiDuplicate = false;
                throw e;
            }
        });
    }

    public static xw processEntityDataPacket(DenizenNetworkManagerImpl networkManager, xw entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.a() == networkManager.player.af()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (acb.b dataValue : entityDataPacket.c()) {
                if (dataValue.a() != 0) continue;
                ArrayList<acb.b<Byte>> newData = new ArrayList<acb.b<Byte>>(entityDataPacket.c());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new xw(entityDataPacket.a(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().aj().c();
            return data != null ? new xw(entityDataPacket.a(), data) : null;
        }
        return entityDataPacket;
    }

    public static yu processAttributesPacket(DenizenNetworkManagerImpl networkManager, yu attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.a() == networkManager.player.af() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static ys processTeleportPacket(DenizenNetworkManagerImpl networkManager, ys teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            ys pNew = new ys(((CraftEntity)disguise.entity.getBukkitEntity()).getHandle());
            TELEPORT_PACKET_ENTITY_ID.setInt(pNew, teleportEntityPacket.a());
            TELEPORT_PACKET_X.setDouble(pNew, teleportEntityPacket.c());
            TELEPORT_PACKET_Y.setDouble(pNew, teleportEntityPacket.d());
            TELEPORT_PACKET_Z.setDouble(pNew, teleportEntityPacket.e());
            TELEPORT_PACKET_YAW.setByte(pNew, EntityAttachmentHelper.adaptedCompressedAngle((byte)teleportEntityPacket.f(), (float)180.0f));
            TELEPORT_PACKET_PITCH.setByte(pNew, teleportEntityPacket.g());
            return pNew;
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static wl.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, wl.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new wl.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.adaptedCompressedAngle((byte)rotPacket.e(), (float)180.0f), rotPacket.f(), rotPacket.i());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static wl.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, wl.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new wl.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.a(), posRotPacket.c(), posRotPacket.d(), EntityAttachmentHelper.adaptedCompressedAngle((byte)posRotPacket.e(), (float)180.0f), posRotPacket.f(), posRotPacket.i());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends uo<ur>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.ct())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends uo<ur>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

