/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.v1_20.Handler;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdvancementHelperImpl
extends AdvancementHelper {
    private static final String IMPOSSIBLE_KEY = "impossible";
    private static final Map<String, Criterion<?>> IMPOSSIBLE_CRITERIA = Collections.singletonMap("impossible", new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a()));
    private static final String[][] IMPOSSIBLE_REQUIREMENTS = new String[][]{{"impossible"}};

    public static AdvancementDataWorld getAdvancementDataWorld() {
        return ((CraftServer)Bukkit.getServer()).getServer().az();
    }

    public void register(com.denizenscript.denizen.nms.util.Advancement advancement) {
        if (advancement.temporary || advancement.registered) {
            return;
        }
    }

    public void unregister(com.denizenscript.denizen.nms.util.Advancement advancement) {
        if (advancement.temporary || !advancement.registered) {
            return;
        }
    }

    public void grantPartial(com.denizenscript.denizen.nms.util.Advancement advancement, Player player, int len) {
        if (advancement.length <= 1) {
            this.grant(advancement, player);
            return;
        }
        if (advancement.temporary) {
            int i;
            AdvancementHolder nmsAdvancement = AdvancementHelperImpl.asNMSCopy(advancement);
            AdvancementProgress progress = new AdvancementProgress();
            HashMap<CallSite, Criterion> criteria = new HashMap<CallSite, Criterion>();
            String[][] requirements = new String[advancement.length][];
            for (i = 0; i < advancement.length; ++i) {
                criteria.put((CallSite)((Object)(IMPOSSIBLE_KEY + i)), new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a()));
                requirements[i] = new String[]{IMPOSSIBLE_KEY + i};
            }
            progress.a(new AdvancementRequirements(IMPOSSIBLE_REQUIREMENTS));
            for (i = 0; i < len; ++i) {
                progress.a(IMPOSSIBLE_KEY + i);
            }
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, Collections.singleton(nmsAdvancement), Collections.emptySet(), Collections.singletonMap(nmsAdvancement.a(), progress)));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getAdvancementDataWorld().c.get(AdvancementHelperImpl.asResourceLocation(advancement.key));
            for (int i = 0; i < len; ++i) {
                ((CraftPlayer)player).getHandle().O().a(nmsAdvancement, IMPOSSIBLE_KEY + i);
            }
        }
    }

    public void grant(com.denizenscript.denizen.nms.util.Advancement advancement, Player player) {
        if (advancement.length > 1) {
            this.grantPartial(advancement, player, advancement.length);
            return;
        }
        if (advancement.temporary) {
            AdvancementHolder nmsAdvancement = AdvancementHelperImpl.asNMSCopy(advancement);
            AdvancementProgress progress = new AdvancementProgress();
            progress.a(new AdvancementRequirements(IMPOSSIBLE_REQUIREMENTS));
            progress.a(IMPOSSIBLE_KEY);
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, Collections.singleton(nmsAdvancement), Collections.emptySet(), Collections.singletonMap(nmsAdvancement.a(), progress)));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getAdvancementDataWorld().c.get(AdvancementHelperImpl.asResourceLocation(advancement.key));
            ((CraftPlayer)player).getHandle().O().a(nmsAdvancement, IMPOSSIBLE_KEY);
        }
    }

    public void revoke(com.denizenscript.denizen.nms.util.Advancement advancement, Player player) {
        if (advancement.temporary) {
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, Collections.emptySet(), Collections.singleton(AdvancementHelperImpl.asResourceLocation(advancement.key)), Collections.emptyMap()));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getAdvancementDataWorld().c.get(AdvancementHelperImpl.asResourceLocation(advancement.key));
            ((CraftPlayer)player).getHandle().O().b(nmsAdvancement, IMPOSSIBLE_KEY);
        }
    }

    public void update(Player player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.c.b((Packet)new PacketPlayOutAdvancements(true, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()));
        AdvancementDataPlayer data = nmsPlayer.O();
        data.b();
        data.a(DedicatedServer.getServer().az());
        data.b(nmsPlayer);
    }

    private static AdvancementHolder asNMSCopy(com.denizenscript.denizen.nms.util.Advancement advancement) {
        MinecraftKey key = AdvancementHelperImpl.asResourceLocation(advancement.key);
        AdvancementHolder parent = advancement.parent != null ? (AdvancementHolder)AdvancementHelperImpl.getAdvancementDataWorld().c.get(AdvancementHelperImpl.asResourceLocation(advancement.parent)) : null;
        AdvancementDisplay display = new AdvancementDisplay(CraftItemStack.asNMSCopy((ItemStack)advancement.icon), (IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse((String)advancement.title, (ChatColor)ChatColor.WHITE)), (IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse((String)advancement.description, (ChatColor)ChatColor.WHITE)), AdvancementHelperImpl.asResourceLocation(advancement.background), AdvancementFrameType.valueOf((String)advancement.frame.name()), advancement.toast, advancement.announceToChat, advancement.hidden);
        display.a(advancement.xOffset, advancement.yOffset);
        Map<String, Criterion<?>> criteria = IMPOSSIBLE_CRITERIA;
        String[][] requirements = IMPOSSIBLE_REQUIREMENTS;
        if (advancement.length > 1) {
            criteria = new HashMap();
            requirements = new String[advancement.length][];
            for (int i = 0; i < advancement.length; ++i) {
                criteria.put(IMPOSSIBLE_KEY + i, new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a()));
                requirements[i] = new String[]{IMPOSSIBLE_KEY + i};
            }
        }
        AdvancementRequirements reqs = new AdvancementRequirements(requirements);
        Advancement adv = new Advancement(Optional.of(parent.a()), Optional.of(display), AdvancementRewards.a, criteria, reqs, false);
        return new AdvancementHolder(key, adv);
    }

    private static MinecraftKey asResourceLocation(NamespacedKey key) {
        return key != null ? new MinecraftKey(key.getNamespace(), key.getKey()) : null;
    }
}

