/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.EntityDataNameMapper;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.commands.core.ReflectionSetCommand;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(bsr.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final ajw<Boolean> ENDERMAN_DATA_ACCESSOR_SCREAMING = (ajw)ReflectionHelper.getFieldValue(cjt.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(btn.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(btn.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final Field EXPERIENCE_ORB_AGE = ReflectionHelper.getFields(btc.class).get(ReflectionMappingsInfo.ExperienceOrb_age, Integer.TYPE);
    public static brl backupDamageSources;
    public static final Field FALLINGBLOCK_BLOCK_STATE;
    public static final Field ZOMBIE_INWATERTIME;
    public static final MethodHandle TRACKING_RANGE_SETTER;
    public static final MethodHandle PLAYERLIST_REMOVE;
    public static final Field SynchedEntityData_itemsById;

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().k(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().ci();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(bua.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        brk source;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target == null) {
            target = attacker;
        }
        bsr nmsTarget = ((CraftEntity)target).getHandle();
        aqu nmsWorld = ((CraftWorld)attacker.getWorld()).getHandle();
        if (attacker instanceof CraftPlayer) {
            CraftPlayer playerAttacker = (CraftPlayer)attacker;
            source = nmsTarget.dO().aj().a((cmx)playerAttacker.getHandle());
        } else {
            source = nmsTarget.dO().aj().b(((CraftLivingEntity)attacker).getHandle());
        }
        if (nmsTarget.b(source)) {
            return 0.0;
        }
        if (attacker.getEquipment() != null) {
            damage = dae.a((aqu)nmsWorld, (cuq)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (bsr)nmsTarget, (brk)source, (float)((float)damage));
        }
        if (!(nmsTarget instanceof btn)) {
            return damage;
        }
        btn livingTarget = (btn)nmsTarget;
        damage = brg.a((btn)livingTarget, (float)((float)damage), (brk)source, (float)livingTarget.eK(), (float)((float)livingTarget.g(buw.b)));
        float enchantDamageModifier = dae.b((aqu)nmsWorld, (btn)livingTarget, (brk)source);
        if (enchantDamageModifier > 0.0f) {
            damage = brg.a((float)((float)damage), (float)enchantDamageModifier);
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            btn nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ((CraftBlock)location.getBlock()).getNMS().a(craftPlayer.getHandle().eT(), (dcw)((CraftWorld)location.getWorld()).getHandle(), (cmx)craftPlayer.getHandle(), bqq.a, new ewy(new exc(0.0, 0.0, 0.0), null, CraftLocation.toBlockPosition((Location)location), false));
    }

    public CompoundTag getNbtData(Entity entity) {
        ub compound = new ub();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        bsr bsr2 = ((CraftEntity)entity).getHandle();
        if (bsr2 instanceof btp) {
            btp nmsMob = (btp)bsr2;
            nmsMob.N().n();
        }
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        bsr nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof btp)) {
            return;
        }
        final btp nmsFollower = (btp)nmsEntityFollower;
        final cda followerNavigation = nmsFollower.N();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        eps path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    eps path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.f(buw.v).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        eps path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        bsr nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof btp)) {
            return;
        }
        final btp nmsMob = (btp)nmsEntity;
        final cda entityNavigation = nmsMob.N();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.bW.b(cam.a.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.f(buw.v).b();
            if (speed != null) {
                nmsMob.f(buw.v).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.f(buw.v).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public void sendAllUpdatePackets(Entity entity) {
        aqb tracker = ((aqu)((CraftEntity)entity).getHandle().dO()).l().a;
        aqb.b entityTracker = (aqb.b)tracker.K.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            aqt serverEntity = (aqt)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.hidePlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        aqv nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals((Object)entity)) {
            aqb.b entry = (aqb.b)nmsPlayer.A().l().a.K.get(entity.getEntityId());
            if (entry != null) {
                entry.a(nmsPlayer);
            }
            if (Denizen.supportsPaper) {
                nmsPlayer.c.b((zg)new aef(new int[]{entity.getEntityId()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        aqb.b entry;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.showPlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        aqv nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals((Object)entity) && (entry = (aqb.b)nmsPlayer.A().l().a.K.get(entity.getEntityId())) != null) {
            entry.a(nmsPlayer);
            entry.b(nmsPlayer);
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isOnline()) {
            NetworkInterceptHelper.enable();
            float relYaw = (yaw - entity.getLocation().getYaw()) % 360.0f;
            if (relYaw > 180.0f) {
                relYaw -= 360.0f;
            }
            float actualRelYaw = relYaw;
            float relPitch = pitch - entity.getLocation().getPitch();
            NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            bsr handle = ((CraftEntity)entity).getHandle();
            handle.t(yaw - 360.0f);
            handle.u(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aY;
    }

    public void look(Entity entity, float yaw, float pitch) {
        bsr handle = ((CraftEntity)entity).getHandle();
        if (handle == null) {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + String.valueOf(entity.getUniqueId())));
            return;
        }
        handle.t(yaw);
        if (handle instanceof btn) {
            btn nmsLivingEntity = (btn)handle;
            while (yaw < -180.0f) {
                yaw += 360.0f;
            }
            while (yaw >= 180.0f) {
                yaw -= 360.0f;
            }
            nmsLivingEntity.aZ = yaw;
            if (!(handle instanceof cmx)) {
                nmsLivingEntity.p(yaw);
            }
            nmsLivingEntity.o(yaw);
        }
        handle.u(pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static exa rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            ewy ewy2 = ((CraftWorld)world).getHandle().a(new dcf(new exc(start.getX(), start.getY(), start.getZ()), new exc(end.getX(), end.getY(), end.getZ()), dcf.a.b, dcf.b.a, exh.a()));
            return ewy2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        exa pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == exa.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().o(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(bts.a, new exc(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        PacketHelperImpl.send(player, new aeb(ff.a.b, at.getX(), at.getY(), at.getZ()));
        return true;
    }

    public static long entityToPacket(double x) {
        return ayo.b((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        ado.a packet = new ado.a(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        vw packetData = new vw(Unpooled.buffer());
        packetData.c(entity.getEntityId());
        packetData.a(location.getX());
        packetData.a(location.getY());
        packetData.a(location.getZ());
        packetData.k((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.k((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.a(entity.isOnGround());
        afw packet = (afw)afw.a.decode((Object)packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        afw packet = new afw(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        bsr nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.t(loc.getYaw());
        nmsEntity.u(loc.getPitch());
        if (nmsEntity instanceof aqv) {
            nmsEntity.c(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.a_(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new ewx(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().ai = ticks;
        if (entity instanceof CraftFallingBlock) {
            CraftFallingBlock craftFallingBlock = (CraftFallingBlock)entity;
            craftFallingBlock.getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            CraftItem craftItem = (CraftItem)entity;
            craftItem.getHandle().i = ticks;
        } else if (entity instanceof CraftExperienceOrb) {
            CraftExperienceOrb craftExperienceOrb = (CraftExperienceOrb)entity;
            try {
                EXPERIENCE_ORB_AGE.setInt(craftExperienceOrb.getHandle(), ticks);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        ((CraftLivingEntity)entity).getHandle().o(angle);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().ar().a(ENDERMAN_DATA_ACCESSOR_SCREAMING, (Object)angry);
    }

    public static brl getReusableDamageSources() {
        if (backupDamageSources == null) {
            backupDamageSources = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().aj();
        }
        return backupDamageSources;
    }

    public static brk getSourceFor(bsr nmsSource, EntityDamageEvent.DamageCause cause, bsr nmsSourceProvider) {
        brl sources = nmsSourceProvider == null ? EntityHelperImpl.getReusableDamageSources() : nmsSourceProvider.dO().aj();
        brk src = sources.o();
        if (nmsSource != null) {
            if (nmsSource instanceof cmx) {
                cmx nmsPlayer = (cmx)nmsSource;
                src = nmsSource.dO().aj().a(nmsPlayer);
            } else if (nmsSource instanceof btn) {
                btn nmsLivingEntity = (btn)nmsSource;
                src = nmsSource.dO().aj().b(nmsLivingEntity);
            }
        }
        if (cause == null) {
            return src;
        }
        return switch (cause) {
            default -> throw new IncompatibleClassChangeError();
            case EntityDamageEvent.DamageCause.CONTACT -> sources.k();
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK -> {
                btn nmsLivingEntity;
                yield sources.b(nmsSource instanceof btn ? (nmsLivingEntity = (btn)nmsSource) : null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK -> {
                if (src != sources.o()) {
                    yield src.sweep();
                }
                yield src;
            }
            case EntityDamageEvent.DamageCause.PROJECTILE -> {
                bsr v1;
                Projectile projectile;
                CraftEntity var7_7;
                if (nmsSource != null && (var7_7 = nmsSource.getBukkitEntity()) instanceof Projectile && (var7_7 = (projectile = (Projectile)var7_7).getShooter()) instanceof CraftEntity) {
                    CraftEntity shooter = var7_7;
                    v1 = shooter.getHandle();
                } else {
                    v1 = null;
                }
                yield sources.b(nmsSource, v1);
            }
            case EntityDamageEvent.DamageCause.SUFFOCATION -> sources.g();
            case EntityDamageEvent.DamageCause.FALL -> sources.l();
            case EntityDamageEvent.DamageCause.FIRE -> sources.a();
            case EntityDamageEvent.DamageCause.FIRE_TICK -> sources.d();
            case EntityDamageEvent.DamageCause.MELTING -> sources.melting();
            case EntityDamageEvent.DamageCause.LAVA -> sources.e();
            case EntityDamageEvent.DamageCause.DROWNING -> sources.i();
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> {
                if (nmsSource instanceof cji) {
                    cji primedTnt = (cji)nmsSource;
                    yield sources.d((bsr)primedTnt, (bsr)primedTnt.p());
                }
                yield sources.a(null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> sources.d(nmsSource, null);
            case EntityDamageEvent.DamageCause.VOID -> sources.n();
            case EntityDamageEvent.DamageCause.LIGHTNING -> sources.c();
            case EntityDamageEvent.DamageCause.STARVATION -> sources.j();
            case EntityDamageEvent.DamageCause.POISON -> sources.poison();
            case EntityDamageEvent.DamageCause.MAGIC -> sources.p();
            case EntityDamageEvent.DamageCause.WITHER -> sources.q();
            case EntityDamageEvent.DamageCause.FALLING_BLOCK -> sources.a(nmsSource);
            case EntityDamageEvent.DamageCause.THORNS -> sources.d(nmsSource);
            case EntityDamageEvent.DamageCause.DRAGON_BREATH -> sources.r();
            case EntityDamageEvent.DamageCause.CUSTOM -> sources.o();
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> sources.m();
            case EntityDamageEvent.DamageCause.HOT_FLOOR -> sources.f();
            case EntityDamageEvent.DamageCause.CAMPFIRE -> sources.b();
            case EntityDamageEvent.DamageCause.CRAMMING -> sources.h();
            case EntityDamageEvent.DamageCause.DRYOUT -> sources.s();
            case EntityDamageEvent.DamageCause.FREEZE -> sources.u();
            case EntityDamageEvent.DamageCause.SONIC_BOOM -> sources.e(nmsSource);
            case EntityDamageEvent.DamageCause.WORLD_BORDER -> sources.w();
            case EntityDamageEvent.DamageCause.KILL -> sources.x();
            case EntityDamageEvent.DamageCause.SUICIDE -> new FakeDamageSrc(src);
        };
    }

    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        btn nmsTarget;
        if (target == null) {
            return;
        }
        bsr nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        brk src = EntityHelperImpl.getSourceFor(nmsSource, cause, (bsr)(nmsTarget = ((CraftLivingEntity)target).getHandle()));
        if (src instanceof FakeDamageSrc) {
            FakeDamageSrc fakeDamageSrc = (FakeDamageSrc)src;
            src = fakeDamageSrc.real;
            if (EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount).isCancelled()) {
                return;
            }
        }
        nmsTarget.a(src, amount);
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        dtc state = ((CraftBlockData)block).getState();
        cjg nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_BLOCK_STATE.set(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        drw nmsSpawner = (drw)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        aqu level = ((CraftWorld)spawner.getWorld()).getHandle();
        bsr nmsEntity = nmsSpawner.c().b((dcw)level, nmsSpawner.aD_());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            aqb map = ((CraftWorld)entity.getWorld()).getHandle().l().a;
            aqb.b entry = (aqb.b)map.K.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().gb();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().w(aggressive);
    }

    public void setUUID(Entity entity, UUID id) {
        try {
            aqv nmsPlayer;
            bsr nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.ad();
            nmsEntity.cS().forEach(bsr::ad);
            dcw level = nmsEntity.dO();
            apm playerList = ((CraftServer)Bukkit.getServer()).getHandle();
            if (nmsEntity instanceof aqv) {
                nmsPlayer = (aqv)nmsEntity;
                PLAYERLIST_REMOVE.invoke(playerList, nmsPlayer);
            } else {
                nmsEntity.a(bsr.c.b);
            }
            nmsEntity.dL();
            nmsEntity.a_(id);
            if (nmsEntity instanceof aqv) {
                nmsPlayer = (aqv)nmsEntity;
                playerList.a(DenizenNetworkManagerImpl.getConnection(nmsPlayer), nmsPlayer, new arj(nmsPlayer.fX(), nmsPlayer.c.k(), nmsPlayer.C(), nmsPlayer.c.isTransferred()));
            } else {
                level.b(nmsEntity);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static Int2ObjectMap<aka.b<Object>> getDataItems(Entity entity) {
        try {
            return (Int2ObjectMap)SynchedEntityData_itemsById.get(((CraftEntity)entity).getHandle().ar());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void convertToInternalData(Entity entity, MapTag internalData, BiConsumer<aka.b<Object>, Object> processConverted) {
        Int2ObjectMap<aka.b<Object>> dataItemsById = EntityHelperImpl.getDataItems(entity);
        for (Map.Entry entry : internalData.entrySet()) {
            int id = EntityDataNameMapper.getIdForName(((CraftEntity)entity).getHandle().getClass(), ((StringHolder)entry.getKey()).low);
            if (id == -1) {
                Debug.echoError((String)("Invalid internal data key: " + String.valueOf(entry.getKey())));
                return;
            }
            aka.b dataItem = (aka.b)dataItemsById.get(id);
            if (dataItem == null) {
                Debug.echoError((String)("Invalid internal data id '" + id + "': couldn't be matched to any internal data for entity of type '" + String.valueOf(entity.getType()) + "'."));
                return;
            }
            Object converted = ReflectionSetCommand.convertObjectTypeFor(dataItem.b().getClass(), (ObjectTag)((ObjectTag)entry.getValue()));
            if (converted == null) continue;
            processConverted.accept((aka.b<Object>)dataItem, converted);
        }
    }

    public List<Object> convertInternalEntityDataValues(Entity entity, MapTag internalData) {
        ArrayList<Object> dataValues = new ArrayList<Object>(internalData.size());
        EntityHelperImpl.convertToInternalData(entity, internalData, (dataItem, converted) -> dataValues.add(PacketHelperImpl.createEntityData(dataItem.a(), converted)));
        return dataValues;
    }

    public void modifyInternalEntityData(Entity entity, MapTag internalData) {
        aka nmsEntityData = ((CraftEntity)entity).getHandle().ar();
        EntityHelperImpl.convertToInternalData(entity, internalData, (dataItem, converted) -> nmsEntityData.a(dataItem.a(), converted));
    }

    public void startUsingItem(LivingEntity entity, EquipmentSlot hand) {
        ((CraftLivingEntity)entity).getHandle().c(hand == EquipmentSlot.HAND ? bqq.a : bqq.b);
    }

    public void stopUsingItem(LivingEntity entity) {
        ((CraftLivingEntity)entity).getHandle().fx();
    }

    public void openHorseInventory(Player player, AbstractHorse horse) {
        chi nmsHorse = ((CraftAbstractHorse)horse).getHandle();
        ((CraftPlayer)player).getHandle().a(nmsHorse, (bqk)nmsHorse.cw);
    }

    private ub getRawEntityNBT(bsr entity) {
        return entity.f(new ub());
    }

    public CompoundTag getRawNBT(Entity entity) {
        return CompoundTagImpl.fromNMSTag(this.getRawEntityNBT(((CraftEntity)entity).getHandle()));
    }

    public void modifyRawNBT(Entity entity, CompoundTag tag) {
        bsr nmsEntity = ((CraftEntity)entity).getHandle();
        ub nmsTag = ((CompoundTagImpl)tag).toNMSTag();
        ub nmsMergedTag = this.getRawEntityNBT(nmsEntity).a(nmsTag);
        UUID uuid = nmsEntity.cz();
        nmsEntity.g(nmsMergedTag);
        nmsEntity.a_(uuid);
    }

    static {
        FALLINGBLOCK_BLOCK_STATE = ReflectionHelper.getFields(cjg.class).getFirstOfType(dtc.class);
        ZOMBIE_INWATERTIME = ReflectionHelper.getFields(ckw.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
        TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(aqb.b.class, Integer.TYPE);
        PLAYERLIST_REMOVE = ReflectionHelper.getMethodHandle(aur.class, (String)"remove", (Class[])new Class[]{aqv.class});
        SynchedEntityData_itemsById = ReflectionHelper.getFields(aka.class).get((Object)ReflectionMappingsInfo.SynchedEntityData_itemsById);
    }

    public static class FakeDamageSrc
    extends brk {
        public brk real;

        public FakeDamageSrc(brk src) {
            super(null);
            this.real = src;
        }
    }
}

