/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    public static final Field TELEPORT_PACKET_YAW = ReflectionHelper.getFields(afw.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(aez.class, aez::b, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(aga.class, aga::b, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(abv.class, abv::b, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(afw.class, afw::b, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(ado.c.class, ado::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(ado.b.class, ado::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends zg<abu>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, dcw level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends zg<abu>> void registerPacketHandler(Class<T> packetType, BiFunction<T, dcw, bsr> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            bsr entity = (bsr)entityGetter.apply(packet, networkManager.player.dO());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.cz());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cz());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.an() + " to player " + networkManager.player.cB());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e) {
                antiDuplicate = false;
                throw e;
            }
        });
    }

    public static aez processEntityDataPacket(DenizenNetworkManagerImpl networkManager, aez entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.b() == networkManager.player.an()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (aka.c dataValue : entityDataPacket.e()) {
                if (dataValue.a() != 0) continue;
                ArrayList<aka.c<Byte>> newData = new ArrayList<aka.c<Byte>>(entityDataPacket.e());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new aez(entityDataPacket.b(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().ar().c();
            return data != null ? new aez(entityDataPacket.b(), data) : null;
        }
        return entityDataPacket;
    }

    public static aga processAttributesPacket(DenizenNetworkManagerImpl networkManager, aga attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.b() == networkManager.player.an() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static afw processTeleportPacket(DenizenNetworkManagerImpl networkManager, afw teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            afw pNew = (afw)afw.a.decode((Object)DenizenNetworkManagerImpl.copyPacket(teleportEntityPacket, afw.a));
            TELEPORT_PACKET_YAW.setByte(pNew, EntityAttachmentHelper.adaptedCompressedAngle((byte)teleportEntityPacket.h(), (float)180.0f));
            return pNew;
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static ado.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, ado.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new ado.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.adaptedCompressedAngle((byte)rotPacket.g(), (float)180.0f), rotPacket.h(), rotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static ado.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, ado.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new ado.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.b(), posRotPacket.e(), posRotPacket.f(), EntityAttachmentHelper.adaptedCompressedAngle((byte)posRotPacket.g(), (float)180.0f), posRotPacket.h(), posRotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends zg<abu>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cz())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends zg<abu>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

