/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(cxl.class).get(ReflectionMappingsInfo.Item_components, kq.class);
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final ux EMPTY_TAG = new ux();
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(cvl.class).get((Object)ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static dcj<?> getNMSRecipe(NamespacedKey key) {
        aly nmsKey = aly.a((aly)mb.bk, (alz)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aI().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            cxl nmsItem = (cxl)ma.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            kq currentComponents = nmsItem.g();
            Item_components.set(nmsItem, kq.a((kq)currentComponents, (kq)kq.a().a(ku.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bo().b(new cxp((dhh)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static dca itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return dca.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return dca.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static aly<dce<?>> createRecipeKey(String name) {
        return aly.a((aly)mb.bk, (alz)alz.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        dbq categoryValue;
        aly<dce<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dca itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dbq dbq2 = categoryValue = category == null ? dbq.c : dbq.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new ddd(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new dbn(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new dbp(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new dcy(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        dcj holder = new dcj(key, (dce)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        aly<dce<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dca itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dde recipe = new dde(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        dcj holder = new dcj(key, (dce)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        aly<dce<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dca templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        dca baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        dca upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        ddb recipe = new ddb(Optional.of(templateItemRecipe), Optional.of(baseItemRecipe), Optional.of(upgradeItemRecipe), CraftItemStack.asNMSCopy((ItemStack)result));
        dcj holder = new dcj(key, (dce)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        aly<dce<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<dca> ingredientList = new ArrayList<dca>();
        dbr categoryValue = category == null ? dbr.d : dbr.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        dcu recipe = new dcu(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)jz.a(null, (Object[])ingredientList.toArray(new dca[0])));
        dcj holder = new dcj(key, (dce)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).J().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        vu tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).b((js.a)CraftRegistry.getMinecraftRegistry());
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        cxp itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        dao profile = (dao)itemStack.a(ku.ag);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(ku.ag, (Object)new dao(gameProfile));
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(ku.b, (Object)czy.a, customData -> {
            CompoundTag updatedTag = CompoundTagImpl.fromNMSTag(customData.d()).createBuilder().put(key, value).build();
            return czy.a((ux)((CompoundTagImpl)updatedTag).toNMSTag());
        });
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return CompoundTagImpl.fromNMSTag((ux)nmsItemStack.a((js.a)CraftRegistry.getMinecraftRegistry()));
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        cxp nmsItemStack = cxp.a((js.a)CraftRegistry.getMinecraftRegistry(), (ux)((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }

    public CompoundTag getCustomData(ItemStack item) {
        czy customData = (czy)CraftItemStack.asNMSCopy((ItemStack)item).a(ku.b);
        return customData != null ? CompoundTagImpl.fromNMSTag(customData.d()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundTag data) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.c(ku.b);
        } else {
            nmsItemStack.b(ku.b, (Object)czy.a((ux)((CompoundTagImpl)data).toNMSTag()));
        }
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        ux nmsOldTag = new ux();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (vu)((CompoundTagImpl)oldTag).toNMSTag());
        ux nmsUpdatedTag = (ux)MinecraftServer.getServer().L.update(bix.t, new Dynamic((DynamicOps)vl.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        ux nmsCurrentTag = (ux)CraftItemStack.asNMSCopy((ItemStack)item).a((js.a)CraftRegistry.getMinecraftRegistry());
        ux nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((cxp)((cxp)cxp.a((js.a)CraftRegistry.getMinecraftRegistry(), (vu)nmsMergedTag).orElseThrow()));
    }

    public CompoundTag getEntityData(ItemStack item) {
        czy entityData = (czy)CraftItemStack.asNMSCopy((ItemStack)item).a(ku.W);
        return entityData != null ? CompoundTagImpl.fromNMSTag(entityData.d()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundTag entityNbt, EntityType entityType) {
        ux nmsEntityNbt = EMPTY_TAG;
        if (!(entityNbt == null || entityNbt.isEmpty() || entityNbt.containsKey("id") && entityNbt.size() <= 1)) {
            nmsEntityNbt = ((CompoundTagImpl)entityNbt).toNMSTag();
            nmsEntityNbt.a("id", entityType.getKey().toString());
        }
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        czy.a((kt)ku.W, (cxp)nmsItemStack, (ux)nmsEntityNbt);
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kt<cvl>)ku.m);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (kt<cvl>)ku.m, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kt<cvl>)ku.n);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (kt<cvl>)ku.n, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, kt<cvl> nmsComponent) {
        List nmsPredicates;
        cvl nmsAdventurePredicate = (cvl)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ax nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jq nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((dkm)((dkm)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, kt<cvl> nmsComponent, List<Material> materials) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        cvl nmsAdventurePredicate = (cvl)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.c(nmsComponent);
            return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
        }
        ax nmsPredicate = new ax(Optional.of(ju.a(material -> (jq)ma.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty());
        nmsItemStack.b(nmsComponent, (Object)new cvl(List.of(nmsPredicate), nmsAdventurePredicate == null || nmsAdventurePredicate.a()));
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().k == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(vm.a((UUID)id).g());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return vm.a((vu)new vb(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        xv nmsDisplayName = (xv)nmsItemStack.a(ku.g);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        dai nmsLore = (dai)nmsItemStack.a(ku.j);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (xv nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.c(ku.g);
        } else {
            nmsItemStack.b(ku.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cxp)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.c(ku.j);
        } else {
            ArrayList<xv> nmsLore = new ArrayList<xv>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(ku.j, (Object)new dai(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cxp)nmsItemStack));
    }

    public static dxv getCorrectStateForFluidBlock(dhi world, dxv blockState, jh blockPos) {
        etx fluid = blockState.y();
        return !fluid.c() && !blockState.c((dgn)world, blockPos, jm.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(evr worldmap, int xMin, int zMin, int xMax, int zMax) {
        ash world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                eub materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                eaa chunk = world.m(new jh(k2, 0, l2));
                if (chunk.E()) continue;
                dgo chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.G_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)dko.j.m().a((dgn)world, jh.c), 10);
                    } else {
                        multiset.add((Object)dko.b.m().a((dgn)world, jh.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    jh.a blockposition_mutableblockposition = new jh.a();
                    jh.a blockposition_mutableblockposition1 = new jh.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            dxv iblockdata;
                            int k4 = chunk.a(edq.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.L_() + 1) {
                                iblockdata = dko.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((jh)blockposition_mutableblockposition)).a((dgn)world, (jh)blockposition_mutableblockposition) == eub.a && k4 > world.L_());
                                if (k4 > world.L_() && !iblockdata.y().c()) {
                                    dxv iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((kl)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((jh)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.L_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((dhi)world, iblockdata, (jh)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((dgn)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((dgn)world, (jh)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (eub)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)eub.a)) == eub.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        evr worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(dhi.i).a(new evp(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        cxl nmsItem = ma.g.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof cvv) {
            dkm block = ((cvv)nmsItem).d();
            return CraftBlockData.fromData((dxv)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        cxp nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        cxp nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bn().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(czn.class, (String)"customMixes", (Object)MinecraftServer.getServer().bn())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((cxp)((cxp)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<cxp> nmsPredicate) {
        if (nmsPredicate instanceof dca) {
            dca ingredient = (dca)nmsPredicate;
            return CraftRecipe.toBukkit((dca)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((csz)CraftMagicNumbers.getItem((Material)itemType).g().a(ku.w)).a();
    }

    public DyeColor getShieldColor(ItemStack item) {
        cwm nmsColor = (cwm)CraftItemStack.asNMSCopy((ItemStack)item).a(ku.aj);
        return nmsColor != null ? DyeColor.getByWoolData((byte)((byte)nmsColor.a())) : null;
    }

    public ItemStack setShieldColor(ItemStack item, DyeColor color) {
        cxp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (color != null) {
            nmsItemStack.b(ku.aj, (Object)cwm.a((int)color.getWoolData()));
        } else {
            nmsItemStack.c(ku.aj);
        }
        return CraftItemStack.asBukkitCopy((cxp)nmsItemStack);
    }
}

