/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R5.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity;
    public static final Field craftBlockEntityState_snapshot;
    public static final Field craftSkull_profile;
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER;
    public static final MethodHandle BLOCK_STRENGTH_SETTER;

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends eaz> T getTE(CraftBlockEntityState<T> cbs2) {
        try {
            return (T)((eaz)craftBlockEntityState_tileEntity.get(cbs2));
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        dfv profile = ((ecp)BlockHelperImpl.getTE((CraftSkull)skull)).h;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.f().get((Object)"textures"), null);
        return new PlayerProfile((String)profile.d().orElse(null), (UUID)profile.e().orElse(null), property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, new dfv(gameProfile));
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
        skull.update();
    }

    public eaz getBlockEntity(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return craftBlock.getHandle().c_(craftBlock.getPosition());
    }

    public CompoundTag getNbtData(Block block) {
        eaz nmsBlockEntity = this.getBlockEntity(block);
        if (nmsBlockEntity != null) {
            ui compound = nmsBlockEntity.b((jn.a)CraftRegistry.getMinecraftRegistry());
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        Handler.useValueInput(((CompoundTagImpl)ctag).toNMSTag(), arg_0 -> ((eaz)this.getBlockEntity(block)).b(arg_0));
    }

    public boolean setBlockResistance(Material material, float resistance) {
        dpz block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(eea.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        dpz block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(eea.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public eeb getMaterialBlockState(Material bukkitMaterial) {
        dpz nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.m() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), faq.values()[reaction.ordinal()]);
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).p;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    public void doRandomTick(Location location) {
        fal fluid;
        jb pos = CraftLocation.toBlockPosition((Location)location);
        efy nmsChunk = ((CraftChunk)location.getChunk()).getHandle(egz.n);
        eeb nmsBlock = nmsChunk.a_(pos);
        aub nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.z()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.A);
        }
        if ((fluid = nmsBlock.y()).f()) {
            fluid.a((dmu)nmsWorld, pos, nmsWorld.A);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).E().ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        dpz blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            bzm nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dW();
            ecr nmsSnapshot = (ecr)craftBlockEntityState_snapshot.get(spawner);
            Handler.useValueOutput(nmsSnapshot.c().m.a(), arg_0 -> ((bzm)nmsEntity).d(arg_0));
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            ecr nmsSnapshot = (ecr)craftBlockEntityState_snapshot.get(bukkitSpawner);
            dlu nmsSpawner = nmsSnapshot.c();
            dno toSpawn = nmsSpawner.m;
            dno.a rules = skyMin == -1 ? null : new dno.a(new bbt((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new bbt((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.m = new dno(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.l = bvt.a();
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    static {
        craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get("snapshot");
        craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get("profile");
        Field blockEntityField = ReflectionHelper.getFields(CraftBlockEntityState.class).getNoCheck("blockEntity");
        if (blockEntityField == null) {
            blockEntityField = ReflectionHelper.getFields(CraftBlockEntityState.class).get("tileEntity");
        }
        craftBlockEntityState_tileEntity = blockEntityField;
        MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(eea.a.class, faq.class);
        BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(eea.a.class, Float.TYPE);
    }
}

