/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bzm>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bzm>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bzm> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k2 -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bzm> entityClass, String name) {
        Class<? extends bzm> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bzm.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bzm.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bzm.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bzm.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bzm.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bzm.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bzm.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bzm.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(cag.class, 8, "width");
        EntityDataNameMapper.registerDataName(cag.class, 9, "height");
        EntityDataNameMapper.registerDataName(cag.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bzj.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(bzj.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(bzj.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(bzj.class, 11, "translation");
        EntityDataNameMapper.registerDataName(bzj.class, 12, "scale");
        EntityDataNameMapper.registerDataName(bzj.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(bzj.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(bzj.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(bzj.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(bzj.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(bzj.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(bzj.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(bzj.class, 20, "width");
        EntityDataNameMapper.registerDataName(bzj.class, 21, "height");
        EntityDataNameMapper.registerDataName(bzj.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(bzj.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(bzj.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(bzj.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(bzj.k.class, 23, "text");
        EntityDataNameMapper.registerDataName(bzj.k.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(bzj.k.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(bzj.k.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(bzj.k.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(cvw.class, 8, "item");
        EntityDataNameMapper.registerDataName(cvh.class, 8, "item");
        EntityDataNameMapper.registerDataName(cvj.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bze.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bze.class, 9, "color");
        EntityDataNameMapper.registerDataName(bze.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bze.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cvk.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cvk.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cvb.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cvb.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cve.class, 10, "color");
        EntityDataNameMapper.registerDataName(cwc.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(cwc.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cxi.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cxi.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cxi.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cxi.class, 11, "type");
        EntityDataNameMapper.registerDataName(cxi.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cxi.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cxi.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(cpr.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(cpr.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cvs.class, 8, "item");
        EntityDataNameMapper.registerDataName(cvi.class, 8, "item");
        EntityDataNameMapper.registerDataName(cwd.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cvj.class, 8, "item");
        EntityDataNameMapper.registerDataName(cvj.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cvj.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(cqs.class, 8, "item");
        EntityDataNameMapper.registerDataName(cqs.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(cqu.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(cam.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(cam.class, 9, "health");
        EntityDataNameMapper.registerDataName(cam.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(cam.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(cam.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(cam.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(cam.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(cut.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(cut.class, 16, "score");
        EntityDataNameMapper.registerDataName(cut.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(cut.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(cut.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(cut.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(cqo.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(cqo.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(cqo.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(cqo.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(cqo.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(cqo.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(cqo.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(cao.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(clw.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(cmq.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(cmq.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(cmq.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(clz.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(cne.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(cnl.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bzc.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cpg.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(cpg.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(coq.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(cos.class, 18, "variant");
        EntityDataNameMapper.registerDataName(cnz.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(cnz.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(cop.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(cot.class, 19, "strength");
        EntityDataNameMapper.registerDataName(cot.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(cot.class, 21, "variant");
        EntityDataNameMapper.registerDataName(cnu.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cnu.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(cnu.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(cme.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(cme.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(cms.class, 17, "type");
        EntityDataNameMapper.registerDataName(cms.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(cms.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(cms.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(coc.class, 17, "variant");
        EntityDataNameMapper.registerDataName(coc.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(cmx.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(cmy.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(cmy.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(cmy.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(cmy.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(cmy.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(cmy.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(cna.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(cna.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(cnf.class, 17, "type");
        EntityDataNameMapper.registerDataName(cnm.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(cnm.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(cnm.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(cnm.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(cnm.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(cnm.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(cnd.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(ctc.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cmw.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cpd.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(csi.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(csi.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(csi.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(cbi.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(cbi.class, 18, "owner");
        EntityDataNameMapper.registerDataName(cmg.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cmg.class, 20, "lying");
        EntityDataNameMapper.registerDataName(cmg.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(cmg.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cpj.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cpj.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cpj.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(cmz.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cua.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cuf.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(cmv.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(cni.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(csb.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(csb.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(csb.class, 18, "peek");
        EntityDataNameMapper.registerDataName(csb.class, 19, "color");
        EntityDataNameMapper.registerDataName(cth.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cti.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cti.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cti.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cre.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(crh.class, 16, "state");
        EntityDataNameMapper.registerDataName(crh.class, 17, "charged");
        EntityDataNameMapper.registerDataName(crh.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(cok.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cok.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(cok.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(crr.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(crr.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(cwk.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(cry.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(csf.class, 17, "spell");
        EntityDataNameMapper.registerDataName(csl.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(csj.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(csg.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(ctw.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(cqm.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(cqm.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(cqm.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(cqm.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(csn.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cso.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cso.class, 17, "type");
        EntityDataNameMapper.registerDataName(cso.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(csp.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(csp.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(crl.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(crl.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(crl.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cps.class, 16, "phase");
        EntityDataNameMapper.registerDataName(crp.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(crx.class, 16, "size");
        EntityDataNameMapper.registerDataName(cse.class, 16, "size");
        EntityDataNameMapper.registerDataName(cxg.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cxg.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cxg.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cxg.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cxg.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cxg.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cxr.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(cxq.class, 14, "command");
        EntityDataNameMapper.registerDataName(cxq.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cra.class, 8, "fuse_ticks");
    }
}

