/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(ui.class, (Class[])new Class[]{Map.class});

    public static vi toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> ug.b;
                case 1 -> ug.c;
                default -> ug.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return vb.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return un.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return uq.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return ul.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return uj.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new uf(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new um(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new up(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return vg.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return uk.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(vi nmsTag) {
        if (nmsTag instanceof ug) {
            ug nmsByteTag = (ug)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.n());
        }
        if (nmsTag instanceof vb) {
            vb nmsShortTag = (vb)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.n());
        }
        if (nmsTag instanceof un) {
            un nmsIntTag = (un)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.n());
        }
        if (nmsTag instanceof uq) {
            uq nmsLongTag = (uq)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.n());
        }
        if (nmsTag instanceof ul) {
            ul nmsFloatTag = (ul)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.n());
        }
        if (nmsTag instanceof uj) {
            uj nmsDoubleTag = (uj)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.n());
        }
        if (nmsTag instanceof uf) {
            uf nmsByteArrayTag = (uf)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.e());
        }
        if (nmsTag instanceof um) {
            um nmsIntArrayTag = (um)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.g());
        }
        if (nmsTag instanceof up) {
            up nmsLongArrayTag = (up)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.g());
        }
        if (nmsTag instanceof vg) {
            vg nmsStringTag = (vg)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.k());
        }
        if (nmsTag instanceof uo) {
            uo nmsListTag = (uo)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof ui) {
            ui nmsCompoundTag = (ui)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof uk) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.c().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(uo nmsListTag) {
        ArrayList<BinaryTag> tags = new ArrayList<BinaryTag>(nmsListTag.size());
        for (vi nmsValue : nmsListTag) {
            tags.add(NBTAdapter.toAPI(nmsValue));
        }
        return ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.LIST_WILDCARD, tags);
    }

    public static uo toNMS(ListBinaryTag listTag) {
        ArrayList<vi> nmsTags = new ArrayList<vi>(listTag.size());
        for (BinaryTag value : listTag) {
            nmsTags.add(NBTAdapter.toNMS(value));
        }
        return new uo(nmsTags);
    }

    public static CompoundBinaryTag toAPI(ui nmsCompoundTag) {
        HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>(nmsCompoundTag.i());
        for (Map.Entry nmsEntry : nmsCompoundTag.g()) {
            tags.put((String)nmsEntry.getKey(), NBTAdapter.toAPI((vi)nmsEntry.getValue()));
        }
        return CompoundBinaryTag.from(tags);
    }

    public static ui toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, vi> nmsTags = new HashMap<String, vi>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

