/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(BiomeBase.ClimateSettings.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, BiomeBase.TemperatureModifier.class, Float.TYPE});
    public static final MethodHandle MAPPED_REGISTRY_REGISTRATION_INFOS = ReflectionHelper.getFields(RegistryMaterials.class).getGetter(ReflectionMappingsInfo.MappedRegistry_registrationInfos);
    public Holder.c<BiomeBase> biomeHolder;
    public WorldServer world;

    public BiomeNMSImpl(WorldServer world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = this.getBiomeRegistry().a(ResourceKey.a((ResourceKey)Registries.aK, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    private RegistryMaterials<BiomeBase> getBiomeRegistry() {
        return (RegistryMaterials)this.world.K_().f(Registries.aK);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        BiomeBase.Precipitation precipitation = ((BiomeBase)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location), this.world.Q());
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case BiomeBase.Precipitation.b -> BiomeNMS.DownfallType.RAIN;
            case BiomeBase.Precipitation.c -> BiomeNMS.DownfallType.SNOW;
            case BiomeBase.Precipitation.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((BiomeBase)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((BiomeBase)this.biomeHolder.a()).h();
    }

    public float getTemperatureAt(Location location) {
        return ((BiomeBase)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location), this.world.Q());
    }

    public boolean hasDownfall() {
        return ((BiomeBase)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.f);
    }

    public int getFoliageColor() {
        if (((BiomeBase)this.biomeHolder.a()).f() != 0) {
            return ((BiomeBase)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, BiomeBase.TemperatureModifier temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(BiomeBase.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
            this.setNetworkedRegistrationInfo();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(BiomeFog.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((BiomeBase)this.biomeHolder.a()).i(), Optional.of(color));
        this.setNetworkedRegistrationInfo();
    }

    public int getFogColor() {
        return ((BiomeBase)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(BiomeFog.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((BiomeBase)this.biomeHolder.a()).i(), (Object)color);
        this.setNetworkedRegistrationInfo();
    }

    public int getWaterFogColor() {
        return ((BiomeBase)this.biomeHolder.a()).k();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(BiomeFog.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((BiomeBase)this.biomeHolder.a()).i(), (Object)color);
        this.setNetworkedRegistrationInfo();
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = ((BiomeBase)this.biomeHolder.a()).b();
        WeightedList typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (Weighted meta : typeSettingList.d()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((EntityTypes)((BiomeSettingsMobs.c)meta.a()).a()));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        Chunk chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        BlockPosition pos = new BlockPosition(block.getX(), 0, block.getZ());
        if (this.world.D(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.i();
        }
    }

    public BiomeBase.TemperatureModifier getTemperatureModifier() {
        return ((BiomeBase)this.biomeHolder.a()).i.c();
    }

    private void setNetworkedRegistrationInfo() {
        try {
            Map registrationInfos = MAPPED_REGISTRY_REGISTRATION_INFOS.invokeExact(this.getBiomeRegistry());
            registrationInfos.put(this.biomeHolder.h(), RegistrationInfo.a);
        }
        catch (Throwable e) {
            Debug.echoError((String)"Failed to set biome registration info, changes may not be synced correctly.");
            Debug.echoError((Throwable)e);
        }
    }
}

