/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.util.Vector;

public class AttachPacketHandlers {
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xa, Short.TYPE);
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_ya, Short.TYPE);
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_za, Short.TYPE);
    public static Field YAW_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xRot, Byte.TYPE);
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get(ReflectionMappingsInfo.ClientboundSetEntityMotionPacket_id, Integer.TYPE);
    public static Vector VECTOR_ZERO = new Vector(0, 0, 0);

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityHeadRotation.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityVelocity.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityTeleport.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityDestroy.class, AttachPacketHandlers::processAttachToForPacket);
    }

    public static void tryProcessMovePacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntity packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cT());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                PacketPlayOutEntity.PacketPlayOutRelEntityMove pNew;
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cT());
                if (!attMap.attached.isValid() || att == null) continue;
                int newId = att.attached.getBukkitEntity().getEntityId();
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(newId, packet.b(), packet.e(), packet.f(), packet.k());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(newId, MathHelper.g((float)packet.g()), MathHelper.g((float)packet.h()), packet.k());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(newId, packet.b(), packet.e(), packet.f(), MathHelper.g((float)packet.g()), MathHelper.g((float)packet.h()), packet.k());
                } else {
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoError((String)("Impossible move-entity packet class: " + packet.getClass().getCanonicalName()));
                    }
                    return;
                }
                if (att.positionalOffset != null) {
                    float pitch;
                    float yaw;
                    boolean isRotate;
                    boolean bl = isRotate = packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook || packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook;
                    if (att.noRotate) {
                        Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = attachedEntity.dX();
                        pitch = attachedEntity.dZ();
                    } else if (isRotate) {
                        yaw = packet.g();
                        pitch = packet.h();
                    } else {
                        yaw = e.dX();
                        pitch = e.dZ();
                    }
                    if (att.noPitch) {
                        pitch = ((CraftEntity)att.attached.getBukkitEntity()).getHandle().dZ();
                    }
                    float newYaw = yaw;
                    if (isRotate) {
                        newYaw = EntityAttachmentHelper.normalizeAngle((float)(newYaw + att.positionalOffset.getYaw()));
                        pitch = EntityAttachmentHelper.normalizeAngle((float)(pitch + att.positionalOffset.getPitch()));
                    }
                    Vector goalPosition = att.fixedForOffset(new Vector(e.dK(), e.dM(), e.dQ()), e.dX(), e.dZ());
                    Vector oldPos = (Vector)att.visiblePositions.get(networkManager.player.cT());
                    boolean forceTele = false;
                    if (oldPos == null) {
                        oldPos = att.attached.getLocation().toVector();
                        forceTele = true;
                    }
                    Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                    att.visiblePositions.put(networkManager.player.cT(), goalPosition.clone());
                    int offX = (int)(moveNeeded.getX() * 4096.0);
                    int offY = (int)(moveNeeded.getY() * 4096.0);
                    int offZ = (int)(moveNeeded.getZ() * 4096.0);
                    if (isRotate && att.offsetRelative || forceTele || offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                        PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(att.attached.getBukkitEntity().getEntityId(), new PositionMoveRotation(CraftVector.toNMS((Vector)goalPosition), Vec3D.c, newYaw, pitch), Set.of(), e.aS());
                        if (NMSHandler.debugPackets) {
                            DenizenNetworkManagerImpl.doPacketOutput("Attach Move-Tele Packet: " + newTeleportPacket.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cV() + " with original yaw " + yaw + " adapted to " + newYaw);
                        }
                        networkManager.oldManager.a((Packet)newTeleportPacket);
                        continue;
                    }
                    POS_X_PACKENT.setShort(pNew, (short)MathHelper.a((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Y_PACKENT.setShort(pNew, (short)MathHelper.a((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Z_PACKENT.setShort(pNew, (short)MathHelper.a((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    if (isRotate) {
                        YAW_PACKENT.setByte(pNew, EntityAttachmentHelper.compressAngle((float)yaw));
                        PITCH_PACKENT.setByte(pNew, EntityAttachmentHelper.compressAngle((float)pitch));
                    }
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Move Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cV() + " with original yaw " + yaw + " adapted to " + newYaw);
                    }
                    networkManager.oldManager.a((Packet)pNew);
                    continue;
                }
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Replica-Move Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cV());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.aS != null && !e.aS.isEmpty()) {
            for (Entity ent : e.aS) {
                AttachPacketHandlers.tryProcessMovePacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessRotateHeadPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityHeadRotation packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cT());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cT());
                if (!attMap.attached.isValid() || att == null) continue;
                float yaw = packet.b();
                Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                if (att.positionalOffset != null) {
                    if (att.noRotate) {
                        yaw = attachedEntity.dX();
                    }
                    yaw = EntityAttachmentHelper.normalizeAngle((float)(yaw + att.positionalOffset.getYaw()));
                }
                PacketPlayOutEntityHeadRotation pNew = new PacketPlayOutEntityHeadRotation(attachedEntity, EntityAttachmentHelper.compressAngle((float)yaw));
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Head Rotation Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cV());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.aS != null && !e.aS.isEmpty()) {
            for (Entity ent : e.aS) {
                AttachPacketHandlers.tryProcessRotateHeadPacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessVelocityPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityVelocity packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cT());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cT());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityVelocity pNew = DenizenNetworkManagerImpl.copyPacket(packet, PacketPlayOutEntityVelocity.a);
                ENTITY_ID_PACKVELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Velocity Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cV());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.aS != null && !e.aS.isEmpty()) {
            for (Entity ent : e.aS) {
                AttachPacketHandlers.tryProcessVelocityPacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessTeleportPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityTeleport packet, Entity e, Vector relative) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cT());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                PacketPlayOutEntityTeleport pNew;
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cT());
                if (!attMap.attached.isValid() || att == null) continue;
                Vector resultPos = CraftVector.toBukkit((Vec3D)packet.e().a()).add(relative);
                if (att.positionalOffset != null) {
                    float pitch;
                    float yaw;
                    resultPos = att.fixedForOffset(resultPos, e.dX(), e.dZ());
                    if (att.noRotate) {
                        Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = attachedEntity.dX();
                        pitch = attachedEntity.dZ();
                    } else {
                        yaw = packet.e().c();
                        pitch = packet.e().d();
                    }
                    if (att.noPitch) {
                        pitch = ((CraftEntity)att.attached.getBukkitEntity()).getHandle().dZ();
                    }
                    float newYaw = EntityAttachmentHelper.normalizeAngle((float)(yaw + att.positionalOffset.getYaw()));
                    pitch = EntityAttachmentHelper.normalizeAngle((float)(pitch + att.positionalOffset.getPitch()));
                    pNew = new PacketPlayOutEntityTeleport(att.attached.getBukkitEntity().getEntityId(), new PositionMoveRotation(CraftVector.toNMS((Vector)resultPos), packet.e().b(), newYaw, pitch), packet.f(), packet.g());
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Teleport Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + networkManager.player.cV() + " with raw yaw " + yaw + " adapted to " + newYaw);
                    }
                } else {
                    pNew = new PacketPlayOutEntityTeleport(att.attached.getBukkitEntity().getEntityId(), packet.e(), packet.f(), packet.g());
                }
                att.visiblePositions.put(networkManager.player.cT(), resultPos.clone());
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.aS != null && !e.aS.isEmpty()) {
            for (Entity ent : e.aS) {
                AttachPacketHandlers.tryProcessTeleportPacketForAttach(networkManager, packet, ent, new Vector(ent.dK() - e.dK(), ent.dM() - e.dM(), ent.dQ() - e.dQ()));
            }
        }
    }

    public static Packet<PacketListenerPlayOut> processAttachToForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (EntityAttachmentHelper.toEntityToData.isEmpty()) {
            return packet;
        }
        try {
            if (packet instanceof PacketPlayOutEntity) {
                PacketPlayOutEntity moveEntityPacket = (PacketPlayOutEntity)packet;
                Entity e = moveEntityPacket.a((World)networkManager.player.A());
                if (e == null) {
                    return packet;
                }
                if (!e.cl()) {
                    AttachPacketHandlers.tryProcessMovePacketForAttach(networkManager, moveEntityPacket, e);
                }
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cT(), (UUID)e.cT()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityHeadRotation) {
                PacketPlayOutEntityHeadRotation rotateHeadPacket = (PacketPlayOutEntityHeadRotation)packet;
                Entity e = rotateHeadPacket.a((World)networkManager.player.A());
                if (e == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessRotateHeadPacketForAttach(networkManager, rotateHeadPacket, e);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cT(), (UUID)e.cT()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                PacketPlayOutEntityVelocity setEntityMotionPacket = (PacketPlayOutEntityVelocity)packet;
                int ider = setEntityMotionPacket.b();
                Entity e = networkManager.player.A().a(ider);
                if (e == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessVelocityPacketForAttach(networkManager, setEntityMotionPacket, e);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cT(), (UUID)e.cT()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                PacketPlayOutEntityTeleport teleportEntityPacket = (PacketPlayOutEntityTeleport)packet;
                int ider = teleportEntityPacket.b();
                Entity e = networkManager.player.A().a(ider);
                if (e == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessTeleportPacketForAttach(networkManager, teleportEntityPacket, e, VECTOR_ZERO);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cT(), (UUID)e.cT()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityDestroy) {
                PacketPlayOutEntityDestroy removeEntitiesPacket = (PacketPlayOutEntityDestroy)packet;
                IntListIterator intListIterator = removeEntitiesPacket.b().iterator();
                while (intListIterator.hasNext()) {
                    EntityAttachmentHelper.EntityAttachedToMap attList;
                    int id = (Integer)intListIterator.next();
                    Entity e = networkManager.player.A().a(id);
                    if (e == null || (attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cT())) == null) continue;
                    for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                        EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cT());
                        if (!attMap.attached.isValid() || att == null) continue;
                        att.visiblePositions.remove(networkManager.player.cT());
                    }
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
        return packet;
    }
}

