/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.commands.entity.FakeEquipCommand;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FakeEquipmentPacketHandlers {
    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityEquipment.class, FakeEquipmentPacketHandlers::processSetEquipmentPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityStatus.class, FakeEquipmentPacketHandlers::processEntityEventPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutWindowItems.class, FakeEquipmentPacketHandlers::processContainerSetContentPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutSetSlot.class, FakeEquipmentPacketHandlers::processContainerSetSlotPacket);
    }

    public static PacketPlayOutEntityEquipment processSetEquipmentPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityEquipment setEquipmentPacket) {
        if (FakeEquipCommand.overrides.isEmpty()) {
            return setEquipmentPacket;
        }
        Entity entity = networkManager.player.A().a(setEquipmentPacket.b());
        if (entity == null) {
            return setEquipmentPacket;
        }
        FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)entity.cY(), (Player)networkManager.player.getBukkitEntity());
        if (override == null) {
            return setEquipmentPacket;
        }
        ArrayList<Pair> equipment = new ArrayList<Pair>(setEquipmentPacket.e());
        for (int i = 0; i < equipment.size(); ++i) {
            Pair pair = (Pair)equipment.get(i);
            net.minecraft.world.item.ItemStack use = switch ((EnumItemSlot)pair.getFirst()) {
                default -> throw new IncompatibleClassChangeError();
                case EnumItemSlot.a -> {
                    if (override.hand == null) {
                        yield (net.minecraft.world.item.ItemStack)pair.getSecond();
                    }
                    yield CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack());
                }
                case EnumItemSlot.b -> {
                    if (override.offhand == null) {
                        yield (net.minecraft.world.item.ItemStack)pair.getSecond();
                    }
                    yield CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack());
                }
                case EnumItemSlot.e -> {
                    if (override.chest == null) {
                        yield (net.minecraft.world.item.ItemStack)pair.getSecond();
                    }
                    yield CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack());
                }
                case EnumItemSlot.f -> {
                    if (override.head == null) {
                        yield (net.minecraft.world.item.ItemStack)pair.getSecond();
                    }
                    yield CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack());
                }
                case EnumItemSlot.d -> {
                    if (override.legs == null) {
                        yield (net.minecraft.world.item.ItemStack)pair.getSecond();
                    }
                    yield CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack());
                }
                case EnumItemSlot.c -> {
                    if (override.boots == null) {
                        yield (net.minecraft.world.item.ItemStack)pair.getSecond();
                    }
                    yield CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack());
                }
                case EnumItemSlot.g -> (net.minecraft.world.item.ItemStack)pair.getSecond();
                case EnumItemSlot.h -> (net.minecraft.world.item.ItemStack)pair.getSecond();
            };
            equipment.set(i, new Pair((Object)((EnumItemSlot)pair.getFirst()), (Object)use));
        }
        return new PacketPlayOutEntityEquipment(setEquipmentPacket.b(), equipment);
    }

    public static Packet<PacketListenerPlayOut> processEntityEventPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityStatus entityEventPacket) {
        if (FakeEquipCommand.overrides.isEmpty()) {
            return entityEventPacket;
        }
        if (entityEventPacket.b() != 55) {
            return entityEventPacket;
        }
        Entity entity = entityEventPacket.a((World)networkManager.player.A());
        if (!(entity instanceof EntityLiving)) {
            return entityEventPacket;
        }
        EntityLiving livingEntity = (EntityLiving)entity;
        FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)livingEntity.cY(), (Player)networkManager.player.getBukkitEntity());
        if (override == null || override.hand == null && override.offhand == null) {
            return entityEventPacket;
        }
        net.minecraft.world.item.ItemStack hand = override.hand != null ? CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()) : livingEntity.fx();
        net.minecraft.world.item.ItemStack offhand = override.offhand != null ? CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()) : livingEntity.fy();
        return new PacketPlayOutEntityEquipment(livingEntity.aA(), List.of(new Pair((Object)EnumItemSlot.a, (Object)hand), new Pair((Object)EnumItemSlot.b, (Object)offhand)));
    }

    public static PacketPlayOutWindowItems processContainerSetContentPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutWindowItems setContentPacket) {
        if (FakeEquipCommand.overrides.isEmpty()) {
            return setContentPacket;
        }
        if (setContentPacket.b() != 0) {
            return setContentPacket;
        }
        FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)networkManager.player.cY(), (Player)networkManager.player.getBukkitEntity());
        if (override == null) {
            return setContentPacket;
        }
        List items = setContentPacket.f();
        if (override.head != null) {
            items.set(5, CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack()));
        }
        if (override.chest != null) {
            items.set(6, CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack()));
        }
        if (override.legs != null) {
            items.set(7, CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack()));
        }
        if (override.boots != null) {
            items.set(8, CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack()));
        }
        if (override.offhand != null) {
            items.set(45, CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()));
        }
        if (override.hand != null) {
            items.set(FakeEquipmentPacketHandlers.getMainHandSlot(networkManager.player), CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()));
        }
        return new PacketPlayOutWindowItems(setContentPacket.b(), setContentPacket.e(), items, setContentPacket.g());
    }

    public static PacketPlayOutSetSlot processContainerSetSlotPacket(DenizenNetworkManagerImpl networkManager, PacketPlayOutSetSlot setSlotPacket) {
        ItemTag item;
        if (FakeEquipCommand.overrides.isEmpty()) {
            return setSlotPacket;
        }
        if (setSlotPacket.b() != 0) {
            return setSlotPacket;
        }
        FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor((UUID)networkManager.player.cY(), (Player)networkManager.player.getBukkitEntity());
        if (override == null) {
            return setSlotPacket;
        }
        switch (setSlotPacket.e()) {
            case 5: {
                Object object = override.head;
                break;
            }
            case 6: {
                Object object = override.chest;
                break;
            }
            case 7: {
                Object object = override.legs;
                break;
            }
            case 8: {
                Object object = override.boots;
                break;
            }
            case 45: {
                Object object = override.offhand;
                break;
            }
            default: {
                Object object = item = setSlotPacket.e() == FakeEquipmentPacketHandlers.getMainHandSlot(networkManager.player) ? override.hand : null;
            }
        }
        if (item == null) {
            return setSlotPacket;
        }
        return new PacketPlayOutSetSlot(setSlotPacket.b(), setSlotPacket.g(), setSlotPacket.e(), CraftItemStack.asNMSCopy((ItemStack)item.getItemStack()));
    }

    public static int getMainHandSlot(EntityPlayer player) {
        return player.gK().g() + 36;
    }
}

