/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;

public class BlockIgnitesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockIgnitesScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public ElementTag cause;
    public BlockIgniteEvent event;

    public BlockIgnitesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("ignites")) {
            return false;
        }
        return this.couldMatchBlock(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!BlockIgnitesScriptEvent.runGenericSwitchCheck(path, "cause", this.cause.asString())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockIgnites";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return new MaterialTag(this.event.getBlock());
            }
            case "cause": {
                return this.cause;
            }
            case "entity": {
                if (this.event.getIgnitingEntity() == null) break;
                return new EntityTag(this.event.getIgnitingEntity()).getDenizenObject();
            }
            case "origin_location": {
                if (this.event.getIgnitingBlock() == null) break;
                return new LocationTag(this.event.getIgnitingBlock().getLocation());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockIgnites(BlockIgniteEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.cause = new ElementTag(event.getCause().name());
        this.event = event;
        this.fire((Event)event);
    }
}

