/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;

public class DeltaTimeScriptEvent
extends ScriptEvent {
    public static DeltaTimeScriptEvent instance;
    public ScriptEntryData data = null;
    public ElementTag second;
    boolean enabled = false;

    public DeltaTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("delta time");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String time = path.rawEventArgAt(2);
        long seconds = DenizenCore.serverTimeMillis / 1000L;
        String countString = path.switches.get("every");
        int count = countString == null ? 1 : Integer.parseInt(countString);
        switch (time) {
            case "secondly": {
                if (seconds % (long)count == 0L) break;
                return false;
            }
            case "minutely": {
                if (seconds % 60L != 0L) {
                    return false;
                }
                long minutes = seconds / 60L;
                if (minutes % (long)count == 0L) break;
                return false;
            }
            case "hourly": {
                if (seconds % 3600L != 0L) {
                    return false;
                }
                long hours = seconds / 3600L;
                if (hours % (long)count == 0L) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public String getName() {
        return "DeltaTime";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "second": {
                return this.second;
            }
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public void checkTime() {
        if (!this.enabled) {
            return;
        }
        this.second = new ElementTag(DenizenCore.serverTimeMillis / 1000L);
        this.data = DenizenCore.implementation.getEmptyScriptEntryData();
        this.fire();
    }
}

