/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerWalksOverScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerWalksOverScriptEvent instance;
    public String notable;
    public PlayerMoveEvent event;

    public PlayerWalksOverScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player walks over");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String loc = path.eventArgLowerAt(3);
        ScriptEvent.MatchHelper matcher = PlayerWalksOverScriptEvent.createMatcher(loc);
        if (!loc.equals("notable") && !matcher.doesMatch(this.notable)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerWalksOver";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("notable")) {
            return new ElementTag(this.notable);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerWalksOver(PlayerMoveEvent event) {
        if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.notable = NoteManager.getSavedId(new LocationTag(event.getTo()).getBlockLocation());
        if (this.notable == null) {
            return;
        }
        this.notable = CoreUtilities.toLowerCase(this.notable);
        this.event = event;
        this.fire((Event)event);
    }
}

