/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFirework
implements Property {
    public static final String[] handledTags = new String[]{"firework"};
    public static final String[] handledMechs = new String[]{"firework"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && (((ItemTag)item).getItemMeta() instanceof FireworkMeta || ((ItemTag)item).getItemMeta() instanceof FireworkEffectMeta);
    }

    public static ItemFirework getFrom(ObjectTag _item) {
        if (!ItemFirework.describes(_item)) {
            return null;
        }
        return new ItemFirework((ItemTag)_item);
    }

    private ItemFirework(ItemTag _item) {
        this.item = _item;
    }

    public ListTag getFireworkData() {
        List<FireworkEffect> effects;
        ListTag list = new ListTag();
        if (this.item.getItemMeta() instanceof FireworkMeta) {
            effects = ((FireworkMeta)this.item.getItemMeta()).getEffects();
            int power = ((FireworkMeta)this.item.getItemMeta()).getPower();
            if (power != 0) {
                list.add(String.valueOf(power));
            }
        } else {
            effects = Collections.singletonList(((FireworkEffectMeta)this.item.getItemMeta()).getEffect());
        }
        if (effects != null) {
            for (FireworkEffect effect : effects) {
                if (effect == null) continue;
                Color ColOne = effect.getColors() != null && effect.getColors().size() > 0 ? (Color)effect.getColors().get(0) : Color.BLUE;
                Color ColTwo = effect.getFadeColors() != null && effect.getFadeColors().size() > 0 ? (Color)effect.getFadeColors().get(0) : ColOne;
                list.add(effect.hasTrail() + "," + effect.hasFlicker() + "," + effect.getType().name() + "," + ColOne.getRed() + "," + ColOne.getGreen() + "," + ColOne.getBlue() + "," + ColTwo.getRed() + "," + ColTwo.getGreen() + "," + ColTwo.getBlue());
            }
        }
        return list;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("firework")) {
            return this.getFireworkData().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag data = this.getFireworkData();
        return data.size() > 0 ? data.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "firework";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("firework")) {
            ListTag fireworks = mechanism.valueAsType(ListTag.class);
            ItemMeta meta = this.item.getItemMeta();
            for (String effect : fireworks) {
                String[] data = effect.split(",");
                if (data.length == 9) {
                    FireworkEffect.Builder builder = FireworkEffect.builder();
                    builder.trail(new ElementTag(data[0]).asBoolean());
                    builder.flicker(new ElementTag(data[1]).asBoolean());
                    if (new ElementTag(data[2]).matchesEnum((Enum[])FireworkEffect.Type.values())) {
                        builder.with(FireworkEffect.Type.valueOf((String)data[2].toUpperCase()));
                    } else {
                        mechanism.echoError("Invalid firework type '" + data[2] + "'");
                    }
                    builder.withColor(Color.fromRGB((int)new ElementTag(data[3]).asInt(), (int)new ElementTag(data[4]).asInt(), (int)new ElementTag(data[5]).asInt()));
                    builder.withFade(Color.fromRGB((int)new ElementTag(data[6]).asInt(), (int)new ElementTag(data[7]).asInt(), (int)new ElementTag(data[8]).asInt()));
                    FireworkEffect built = builder.build();
                    if (meta instanceof FireworkMeta) {
                        ((FireworkMeta)meta).addEffect(built);
                        continue;
                    }
                    ((FireworkEffectMeta)meta).setEffect(built);
                    continue;
                }
                if (data.length == 1) {
                    if (meta instanceof FireworkMeta) {
                        ((FireworkMeta)meta).setPower(new ElementTag(data[0]).asInt());
                        continue;
                    }
                    mechanism.echoError("Cannot set the power of a firework effect!");
                    continue;
                }
                mechanism.echoError("Invalid firework data '" + effect + "'");
            }
            this.item.setItemMeta(meta);
        }
    }
}

