/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.interfaces.EntityAnimation;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.npc.traits.MirrorTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAge;
import com.denizenscript.denizen.objects.properties.entity.EntityColor;
import com.denizenscript.denizen.objects.properties.entity.EntityTame;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.entity.HideEntitiesHelper;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Villager;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EntityTag
implements ObjectTag,
Adjustable,
EntityFormObject,
FlaggableObject,
Cloneable {
    public static HashSet<String> earlyValidMechanisms = new HashSet<String>(Arrays.asList("max_health", "health_data", "health", "visible", "armor_pose", "arms", "base_plate", "is_small", "marker", "velocity", "age", "is_using_riptide", "size"));
    private static final Map<UUID, Entity> rememberedEntities = new HashMap<UUID, Entity>();
    public static boolean allowDespawnedNpcs = false;
    public Entity entity = null;
    public long cleanRateProtect = -60000L;
    public DenizenEntityType entity_type = null;
    private String data1 = null;
    private DespawnedEntity despawned_entity = null;
    private NPCTag npc = null;
    public UUID uuid = null;
    private String entityScript = null;
    public boolean isFake = false;
    public boolean isFakeValid = false;
    private String prefix = "Entity";
    public static ObjectTagProcessor<EntityTag> tagProcessor = new ObjectTagProcessor();
    public ArrayList<Mechanism> mechanisms = new ArrayList();

    public static void rememberEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.put(entity.getUniqueId(), entity);
    }

    public static void forgetEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.remove(entity.getUniqueId());
    }

    public static boolean isNPC(Entity entity) {
        return entity != null && entity.hasMetadata("NPC") && ((MetadataValue)entity.getMetadata("NPC").get(0)).asBoolean();
    }

    public static boolean isCitizensNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (Depends.citizens == null) {
            return false;
        }
        if (!CitizensAPI.hasImplementation()) {
            return false;
        }
        if (!(entity instanceof NPCHolder)) {
            return false;
        }
        NPC npc = ((NPCHolder)entity).getNPC();
        return npc != null;
    }

    public static NPCTag getNPCFrom(Entity entity) {
        if (EntityTag.isCitizensNPC(entity)) {
            return NPCTag.fromEntity(entity);
        }
        return null;
    }

    public static boolean isPlayer(Entity entity) {
        return entity instanceof Player && !EntityTag.isNPC(entity);
    }

    public static PlayerTag getPlayerFrom(Entity entity) {
        if (EntityTag.isPlayer(entity)) {
            return PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
        }
        return null;
    }

    public ItemTag getItemInHand() {
        if (this.isLivingEntity() && this.getLivingEntity().getEquipment() != null) {
            ItemStack its = this.getLivingEntity().getEquipment().getItemInMainHand();
            if (its == null) {
                return null;
            }
            return new ItemTag(its.clone());
        }
        return null;
    }

    @Deprecated
    public static EntityTag valueOf(String string) {
        return EntityTag.valueOf(string, null);
    }

    @Fetchable(value="e")
    public static EntityTag valueOf(String string, TagContext context) {
        EntityTag entity;
        if (string == null) {
            return null;
        }
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFromWithProperties(EntityTag.class, string, context);
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("e@")) {
            if (string.startsWith("e@fake:")) {
                try {
                    UUID entityID = UUID.fromString(string.substring("e@fake:".length()));
                    FakeEntity entity2 = FakeEntity.idsToEntities.get(entityID);
                    if (entity2 != null) {
                        return entity2.entity;
                    }
                    return null;
                }
                catch (Exception entityID) {
                    // empty catch block
                }
            }
            string = string.substring("e@".length());
        }
        if (string.equals("random")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LEASH_HITCH|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[CoreUtilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new EntityTag(randomType, "RANDOM");
        }
        if (string.startsWith("n@")) {
            NPCTag npc = NPCTag.valueOf(string, context);
            if (npc != null) {
                if (npc.isSpawned()) {
                    return new EntityTag(npc);
                }
                if (!allowDespawnedNpcs && context != null && context.showErrors()) {
                    Debug.echoDebug((Debuggable)context, "NPC '" + string + "' is not spawned, errors may follow!");
                }
                return new EntityTag(npc);
            }
            if (context == null || context.debug) {
                Debug.echoError("NPC '" + string + "' does not exist!");
            }
        } else if (string.startsWith("p@")) {
            PlayerTag returnable = PlayerTag.valueOf(string, context);
            if (returnable != null && returnable.isOnline()) {
                return new EntityTag((Entity)returnable.getPlayerEntity());
            }
            if (context == null || context.showErrors()) {
                Debug.echoError("Invalid Player! '" + string + "' could not be found. Has the player logged off?");
            }
        }
        UUID id = null;
        int slash = string.indexOf(47);
        if (slash != -1) {
            try {
                id = UUID.fromString(string.substring(0, slash));
                string = string.substring(slash + 1);
                entity = EntityTag.getEntityForID(id);
                if (entity != null) {
                    EntityTag result = new EntityTag((Entity)entity);
                    if (string.equalsIgnoreCase(result.getEntityScript()) || string.equalsIgnoreCase(result.getBukkitEntityType().name())) {
                        return result;
                    }
                    if (context == null || context.showErrors()) {
                        Debug.echoError("Invalid EntityTag! ID '" + id + "' is valid, but '" + string + "' does not match its type data.");
                    }
                }
            }
            catch (Exception entity3) {
                // empty catch block
            }
        }
        if (ScriptRegistry.containsScript(string, EntityScriptContainer.class)) {
            entity = ScriptRegistry.getScriptContainerAs(string, EntityScriptContainer.class).getEntityFrom();
            entity.uuid = id;
            return entity;
        }
        List<String> data = CoreUtilities.split(string, ',');
        DenizenEntityType type = DenizenEntityType.getByName(data.get(0));
        if (type != null && type.getBukkitEntityType() != EntityType.UNKNOWN) {
            EntityTag entity4 = new EntityTag(type, data.size() > 1 ? data.get(1) : null);
            entity4.uuid = id;
            return entity4;
        }
        try {
            UUID entityID = id != null ? id : UUID.fromString(string);
            Entity entity5 = EntityTag.getEntityForID(entityID);
            if (entity5 != null) {
                return new EntityTag(entity5);
            }
            return null;
        }
        catch (Exception exception) {
            if (context == null || context.showErrors()) {
                Debug.log("valueOf EntityTag returning null: " + string);
            }
            return null;
        }
    }

    public static Entity getEntityForID(UUID id) {
        if (rememberedEntities.containsKey(id)) {
            return rememberedEntities.get(id);
        }
        for (World world : Bukkit.getWorlds()) {
            Entity entity = NMSHandler.getEntityHelper().getEntity(world, id);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("n@") || arg.startsWith("e@") || arg.startsWith("p@")) {
            return true;
        }
        if ((arg = arg.replace("e@", "").toUpperCase()).equals("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        return DenizenEntityType.isRegistered(CoreUtilities.split(arg, ',').get(0));
    }

    public EntityTag(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entityScript = EntityScriptHelper.getEntityScript(entity);
            this.uuid = entity.getUniqueId();
            this.entity_type = DenizenEntityType.getByEntity(entity);
            if (EntityTag.isCitizensNPC(entity)) {
                this.npc = EntityTag.getNPCFrom(entity);
            }
        } else {
            Debug.echoError("Entity referenced is null!");
        }
    }

    public EntityTag(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(EntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(DenizenEntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(NPCTag npc) {
        if (Depends.citizens == null) {
            return;
        }
        if (npc != null) {
            this.npc = npc;
            if (npc.isSpawned()) {
                this.entity = npc.getEntity();
                this.entity_type = DenizenEntityType.getByName(npc.getEntityType().name());
                this.uuid = this.entity.getUniqueId();
            }
        } else {
            Debug.echoError("NPC referenced is null!");
        }
    }

    @Override
    public EntityTag duplicate() {
        if (this.isUnique()) {
            return this;
        }
        try {
            EntityTag copy = (EntityTag)this.clone();
            if (copy.mechanisms != null) {
                copy.mechanisms = new ArrayList<Mechanism>(copy.mechanisms);
            }
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getFlagTracker();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().getFlagTracker();
        }
        Entity ent = this.getBukkitEntity();
        if (ent != null) {
            return new DataPersistenceFlagTracker((PersistentDataHolder)ent);
        }
        return null;
    }

    @Override
    public String getReasonNotFlaggable() {
        if (!this.isSpawned() || this.getBukkitEntity() == null) {
            return "the entity is not spawned";
        }
        return "unknown reason - something went wrong";
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (this.cleanRateProtect + 60000L > DenizenCore.serverTimeMillis) {
            ((DataPersistenceFlagTracker)tracker).doTotalClean();
            this.cleanRateProtect = DenizenCore.serverTimeMillis;
        }
    }

    @Override
    public boolean isTruthy() {
        return this.isSpawnedOrValidForTag();
    }

    public DenizenEntityType getEntityType() {
        return this.entity_type;
    }

    public EntityType getBukkitEntityType() {
        return this.entity_type.getBukkitEntityType();
    }

    public void setEntityScript(String entityScript) {
        this.entityScript = entityScript;
    }

    public String getEntityScript() {
        return this.entityScript;
    }

    public UUID getUUID() {
        if (this.uuid == null && this.entity != null) {
            this.uuid = this.entity.getUniqueId();
        }
        return this.uuid;
    }

    @Override
    public EntityTag getDenizenEntity() {
        return this;
    }

    public EntityFormObject getDenizenObject() {
        if (this.entity == null && this.npc == null) {
            return this;
        }
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC();
        }
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return this;
    }

    public Entity getBukkitEntity() {
        Entity backup;
        if (!(this.uuid == null || this.entity != null && this.entity.isValid() || this.isFake || (backup = Bukkit.getEntity((UUID)this.uuid)) == null)) {
            this.entity = backup;
        }
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public boolean isLivingEntityType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return this.entity_type.getBukkitEntityType().isAlive();
        }
        return this.entity instanceof LivingEntity;
    }

    public boolean isMonsterType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return Monster.class.isAssignableFrom(this.entity_type.getBukkitEntityType().getEntityClass());
        }
        return this.getBukkitEntity() instanceof Monster;
    }

    public boolean isMobType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return Mob.class.isAssignableFrom(this.entity_type.getBukkitEntityType().getEntityClass());
        }
        return this.getBukkitEntity() instanceof Mob;
    }

    public boolean isAnimalType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return Animals.class.isAssignableFrom(this.entity_type.getBukkitEntityType().getEntityClass());
        }
        return this.getBukkitEntity() instanceof Animals;
    }

    public boolean hasInventory() {
        return this.getBukkitEntity() instanceof InventoryHolder || this.isCitizensNPC();
    }

    public NPCTag getDenizenNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        return EntityTag.getNPCFrom(this.entity);
    }

    public boolean isNPC() {
        return this.npc != null || EntityTag.isNPC(this.entity);
    }

    public boolean isCitizensNPC() {
        return this.npc != null || EntityTag.isCitizensNPC(this.entity);
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return (Player)this.entity;
        }
        return null;
    }

    public PlayerTag getDenizenPlayer() {
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return null;
    }

    public boolean isPlayer() {
        if (this.entity == null) {
            return this.entity_type.getBukkitEntityType() == EntityType.PLAYER && this.npc == null;
        }
        return this.entity instanceof Player && !this.isNPC();
    }

    public Projectile getProjectile() {
        return (Projectile)this.entity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public EntityTag getShooter() {
        if (this.hasShooter()) {
            return new EntityTag((Entity)((LivingEntity)this.getProjectile().getShooter()));
        }
        return null;
    }

    public void setShooter(EntityTag shooter) {
        if (this.isProjectile() && shooter.isLivingEntity()) {
            this.getProjectile().setShooter((ProjectileSource)shooter.getLivingEntity());
        }
    }

    public boolean hasShooter() {
        return this.isProjectile() && this.getProjectile().getShooter() != null && this.getProjectile().getShooter() instanceof LivingEntity;
    }

    public Inventory getBukkitInventory() {
        if (this.hasInventory() && !this.isCitizensNPC()) {
            return ((InventoryHolder)this.getBukkitEntity()).getInventory();
        }
        return null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? (this.isCitizensNPC() ? this.getDenizenNPC().getDenizenInventory() : InventoryTag.mirrorBukkitInventory(this.getBukkitInventory())) : null;
    }

    public String getName() {
        String customName;
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getCitizen().getName();
        }
        if (this.entity instanceof FakePlayer) {
            return ((FakePlayer)this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return this.entity.getName();
        }
        String string = customName = this.entity == null ? null : this.entity.getCustomName();
        if (customName != null) {
            return customName;
        }
        return this.entity_type.getName();
    }

    public ListTag getEquipment() {
        ItemStack[] equipment = this.getLivingEntity().getEquipment().getArmorContents();
        ListTag equipmentList = new ListTag();
        for (ItemStack item : equipment) {
            equipmentList.addObject(new ItemTag(item));
        }
        return equipmentList;
    }

    public boolean isGeneric() {
        return !this.isUnique();
    }

    @Override
    public LocationTag getLocation() {
        Entity entity = this.getBukkitEntity();
        if (entity != null) {
            return new LocationTag(entity.getLocation());
        }
        return null;
    }

    public LocationTag getEyeLocation() {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return null;
        }
        if (this.isPlayer()) {
            return new LocationTag(this.getPlayer().getEyeLocation());
        }
        if (!this.isGeneric() && this.isLivingEntity()) {
            return new LocationTag(this.getLivingEntity().getEyeLocation());
        }
        if (!this.isGeneric()) {
            return new LocationTag(entity.getLocation());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getTargetBlockSafe(Set<Material> mats, int range) {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            Location location = this.getLivingEntity().getTargetBlock(mats, range).getLocation();
            return location;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Vector getVelocity() {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return null;
        }
        return entity.getVelocity();
    }

    public void setVelocity(Vector vector) {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return;
        }
        entity.setVelocity(vector);
    }

    public World getWorld() {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return null;
        }
        return entity.getWorld();
    }

    public void spawnAt(Location location) {
        this.spawnAt(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void spawnAt(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (location.getWorld() == null) {
            Debug.echoError("Cannot teleport or spawn entity at location '" + new LocationTag(location) + "' because it is missing a world.");
            return;
        }
        if (this.isCitizensNPC() || this.isUnique() && this.entity != null) {
            this.teleport(location, cause);
        } else {
            if (this.entity_type != null) {
                if (this.despawned_entity != null) {
                    if (this.despawned_entity.custom_script == null) {
                        this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    }
                    this.getLivingEntity().teleport(location);
                    this.getLivingEntity().getEquipment().setArmorContents(this.despawned_entity.equipment);
                    this.getLivingEntity().setHealth(this.despawned_entity.health.doubleValue());
                    this.despawned_entity = null;
                } else if (this.entity_type.getBukkitEntityType() == EntityType.PLAYER) {
                    if (Depends.citizens == null) {
                        Debug.echoError("Cannot spawn entity of type PLAYER!");
                        return;
                    }
                    NPCTag npc = new NPCTag(CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, this.data1));
                    npc.getCitizen().spawn(location);
                    this.entity = npc.getEntity();
                    this.uuid = this.entity.getUniqueId();
                } else if (this.entity_type.getBukkitEntityType() == EntityType.FALLING_BLOCK) {
                    MaterialTag material = null;
                    if (this.data1 != null && MaterialTag.matches(this.data1)) {
                        material = MaterialTag.valueOf(this.data1, CoreUtilities.basicContext);
                        while (this.data1.equalsIgnoreCase("RANDOM") && (!material.getMaterial().isBlock() || material.getMaterial() == Material.AIR || material.getMaterial() == Material.NETHER_PORTAL || material.getMaterial() == Material.END_PORTAL)) {
                            material = MaterialTag.valueOf(this.data1, CoreUtilities.basicContext);
                        }
                    } else {
                        for (Mechanism mech : this.mechanisms) {
                            if (!mech.getName().equals("fallingblock_type")) continue;
                            material = mech.valueAsType(MaterialTag.class);
                            this.mechanisms.remove(mech);
                            break;
                        }
                    }
                    if (material == null || !material.getMaterial().isBlock() || !material.hasModernData()) {
                        material = new MaterialTag(Material.SAND);
                    }
                    this.entity = location.getWorld().spawnFallingBlock(location, material.getModernData());
                    this.uuid = this.entity.getUniqueId();
                } else if (this.entity_type.getBukkitEntityType() == EntityType.PAINTING) {
                    this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    location = location.clone();
                    Painting painting = (Painting)this.entity;
                    Art art = null;
                    BlockFace face = null;
                    try {
                        for (Mechanism mech : this.mechanisms) {
                            if (mech.getName().equals("painting")) {
                                art = Art.valueOf((String)mech.getValue().asString().toUpperCase());
                                continue;
                            }
                            if (!mech.getName().equals("rotation")) continue;
                            face = BlockFace.valueOf((String)mech.getValue().asString().toUpperCase());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (art != null && face != null) {
                        if (art.getBlockHeight() % 2 == 0) {
                            location.subtract(0.0, 1.0, 0.0);
                        }
                        if (art.getBlockWidth() % 2 == 0) {
                            if (face == BlockFace.WEST) {
                                location.subtract(0.0, 0.0, 1.0);
                            } else if (face == BlockFace.SOUTH) {
                                location.subtract(1.0, 0.0, 0.0);
                            }
                        }
                        painting.teleport(location);
                        painting.setFacingDirection(face, true);
                        painting.setArt(art, true);
                    }
                } else {
                    this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    if (this.entity == null) {
                        if (Debug.verbose) {
                            Debug.echoError("Failed to spawn entity of type " + this.entity_type.getName());
                        }
                        return;
                    }
                    this.uuid = this.entity.getUniqueId();
                    if (this.entityScript != null) {
                        EntityScriptHelper.setEntityScript(this.entity, this.entityScript);
                    }
                }
            } else {
                Debug.echoError("Cannot spawn a null EntityTag!");
            }
            if (!this.isUnique()) {
                if (new LocationTag(location).isChunkLoaded()) {
                    Debug.echoError("Error spawning entity - tried to spawn in an unloaded chunk.");
                } else {
                    Debug.echoError("Error spawning entity - bad entity type, blocked by another plugin?");
                }
                return;
            }
            for (Mechanism mechanism : this.mechanisms) {
                this.safeAdjust(new Mechanism(mechanism.getName(), mechanism.value, mechanism.context));
            }
            this.mechanisms.clear();
        }
    }

    public void despawn() {
        this.despawned_entity = new DespawnedEntity(this);
        this.getLivingEntity().remove();
    }

    public void respawn() {
        if (this.despawned_entity != null) {
            this.spawnAt(this.despawned_entity.location);
        } else if (this.entity == null) {
            Debug.echoError("Cannot respawn a null EntityTag!");
        }
    }

    public boolean isSpawnedOrValidForTag() {
        if (this.isFake) {
            return true;
        }
        if (this.entity == null) {
            if (this.uuid == null) {
                return false;
            }
            return this.isValid() || rememberedEntities.containsKey(this.uuid);
        }
        NMSHandler.getChunkHelper().changeChunkServerThread(this.entity.getWorld());
        try {
            boolean bl = this.isValid() || rememberedEntities.containsKey(this.entity.getUniqueId());
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.entity.getWorld());
        }
    }

    public boolean isSpawned() {
        return this.isValid();
    }

    public boolean isValid() {
        Entity entity = this.getBukkitEntity();
        return entity != null && (entity.isValid() || this.isFake && this.isFakeValid);
    }

    public void remove() {
        this.entity.remove();
    }

    public void teleport(Location location) {
        this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (location.getWorld() == null) {
            Debug.echoError("Cannot teleport or spawn entity at location '" + new LocationTag(location) + "' because it is missing a world.");
            return;
        }
        if (this.isCitizensNPC()) {
            if (this.getDenizenNPC().getCitizen().isSpawned()) {
                this.getDenizenNPC().getCitizen().teleport(location, cause);
            } else if (this.getDenizenNPC().getCitizen().spawn(location)) {
                this.entity = this.getDenizenNPC().getCitizen().getEntity();
                this.uuid = this.getDenizenNPC().getCitizen().getEntity().getUniqueId();
            } else if (new LocationTag(location).isChunkLoaded()) {
                Debug.echoError("Error spawning NPC - tried to spawn in an unloaded chunk.");
            } else {
                Debug.echoError("Error spawning NPC - blocked by plugin");
            }
        } else if (this.isFake) {
            NMSHandler.getEntityHelper().snapPositionTo(this.entity, location.toVector());
            NMSHandler.getEntityHelper().look(this.entity, location.getYaw(), location.getPitch());
        } else {
            this.getBukkitEntity().teleport(location, cause);
            if (this.entity.getWorld().equals(location.getWorld())) {
                NMSHandler.getEntityHelper().teleport(this.entity, location);
            }
        }
    }

    public void target(LivingEntity target) {
        if (!this.isSpawned()) {
            return;
        }
        if (this.entity instanceof Creature) {
            NMSHandler.getEntityHelper().setTarget((Creature)this.entity, target);
        } else if (this.entity instanceof ShulkerBullet) {
            ((ShulkerBullet)this.entity).setTarget((Entity)target);
        } else {
            Debug.echoError(this.identify() + " is not an entity type that can hold a target!");
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public int comparesTo(EntityTag entity) {
        if (entity == null) {
            return 0;
        }
        if (entity.isUnique() && entity.identify().equals(this.identify())) {
            return 1;
        }
        if (!entity.isUnique()) {
            if (!this.isUnique() && entity.identify().equals(this.identify())) {
                return 1;
            }
            if (this.entity_type == entity.entity_type) {
                return 1;
            }
        }
        return 0;
    }

    public boolean comparedTo(String compare) {
        if ((compare = CoreUtilities.toLowerCase(compare)).equals("entity")) {
            return true;
        }
        if (compare.equals("player")) {
            return this.isPlayer();
        }
        if (compare.equals("npc")) {
            return this.isCitizensNPC() || this.isNPC();
        }
        if (this.getEntityScript() != null && compare.equals(CoreUtilities.toLowerCase(this.getEntityScript()))) {
            return true;
        }
        return compare.equals(this.getEntityType().getLowercaseName());
    }

    @Override
    public String getObjectType() {
        return "Entity";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public EntityTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.npc != null) {
            return this.npc.debuggable();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return this.getDenizenPlayer().debuggable();
            }
            if (this.isFake) {
                return "<LG>e@<Y>FAKE: " + this.getUUID() + "<GR>(FAKE-" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
            if (this.isSpawnedOrValidForTag()) {
                return "<LG>e@<Y> " + this.getUUID() + "<GR>(" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
        }
        return this.identify(this::getWaitingMechanismsDebuggable);
    }

    @Override
    public String savable() {
        if (this.npc != null) {
            return this.npc.savable();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().savable();
        }
        if (this.isFake) {
            return "e@fake:" + this.getUUID();
        }
        return this.identify();
    }

    @Override
    public String identify() {
        return this.identify(this::getWaitingMechanismsString);
    }

    public String identify(Supplier<String> mechsHandler) {
        if (this.npc != null) {
            return this.npc.identify();
        }
        if (this.isFake) {
            return "e@fake:" + this.getUUID();
        }
        if (this.getUUID() != null) {
            if (this.isPlayer()) {
                return this.getDenizenPlayer().identify();
            }
            if (this.entityScript != null) {
                return "e@" + this.getUUID() + "/" + this.entityScript + mechsHandler.get();
            }
            if (this.entity_type != null) {
                return "e@" + this.getUUID() + "/" + this.entity_type.getLowercaseName() + mechsHandler.get();
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript + mechsHandler.get();
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName() + mechsHandler.get();
        }
        return "null";
    }

    public String getWaitingMechanismsDebuggable() {
        StringBuilder properties = new StringBuilder();
        for (Mechanism mechanism : this.mechanisms) {
            properties.append(mechanism.getName()).append(" <LG>=<Y> ").append(mechanism.getValue().asString()).append("<LG>; <Y>");
        }
        if (properties.length() > 0) {
            return "<LG>[<Y>" + properties.substring(0, properties.length() - "; <Y>".length()) + " <LG>]";
        }
        return "";
    }

    public String getWaitingMechanismsString() {
        StringBuilder properties = new StringBuilder();
        for (Mechanism mechanism : this.mechanisms) {
            properties.append(PropertyParser.escapePropertyKey(mechanism.getName())).append("=").append(PropertyParser.escapePropertyValue(mechanism.getValue().asString())).append(";");
        }
        if (properties.length() > 0) {
            return "[" + properties.substring(0, properties.length() - 1) + "]";
        }
        return "";
    }

    @Override
    public String identifySimple() {
        if (this.npc != null && this.npc.isValid()) {
            return "n@" + this.npc.getId();
        }
        if (this.isPlayer()) {
            return "p@" + this.getPlayer().getName();
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName();
        }
        return "null";
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return this.entity != null || this.uuid != null || this.isFake || this.npc != null;
    }

    public LocationTag doLocationTag(Attribute attribute) {
        if (attribute.startsWith("cursor_on", 2)) {
            Deprecations.entityLocationCursorOnTag.warn(attribute.context);
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            HashSet<Material> set = new HashSet<Material>();
            set.add(Material.AIR);
            if (attribute.startsWith("ignore", 3) && attribute.hasContext(3)) {
                List<MaterialTag> ignoreList = attribute.contextAsType(3, ListTag.class).filter(MaterialTag.class, attribute.context);
                for (MaterialTag material : ignoreList) {
                    set.add(material.getMaterial());
                }
                attribute.fulfill(1);
            }
            attribute.fulfill(1);
            return new LocationTag(this.getTargetBlockSafe(set, range));
        }
        if (attribute.startsWith("standing_on", 2)) {
            Deprecations.entityStandingOn.warn(attribute.context);
            attribute.fulfill(1);
            return new LocationTag(this.getBukkitEntity().getLocation().clone().add(0.0, -0.5, 0.0));
        }
        return new LocationTag(this.getBukkitEntity().getLocation());
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PropertyParser.registerPropertyTagHandlers(EntityTag.class, tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "entity_type", (attribute, object) -> new ElementTag(object.entity_type.getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "translated_name", (attribute, object) -> {
            String key = object.getEntityType().getBukkitEntityType().getKey().getKey();
            return new ElementTag("\u00a7[translate=entity.minecraft." + key + "]");
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_spawned", (attribute, object) -> new ElementTag(object.isSpawned()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "eid", (attribute, object) -> new ElementTag(object.getBukkitEntity().getEntityId()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "uuid", (attribute, object) -> new ElementTag(object.getUUID().toString()), new String[0]);
        tagProcessor.registerTag(ScriptTag.class, "script", (attribute, object) -> {
            if (object.entityScript == null) {
                return null;
            }
            ScriptTag tag = new ScriptTag(object.entityScript);
            if (tag.isValid()) {
                return tag;
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "scriptname", (attribute, object) -> {
            Deprecations.hasScriptTags.warn(attribute.context);
            if (object.entityScript == null) {
                return null;
            }
            return new ElementTag(object.entityScript);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ObjectTag.class, "custom_id", (attribute, object) -> {
            Deprecations.entityCustomIdTag.warn(attribute.context);
            if (CustomNBT.hasCustomNBT((Entity)object.getLivingEntity(), "denizen-script-id")) {
                return new ScriptTag(CustomNBT.getCustomNBT((Entity)object.getLivingEntity(), "denizen-script-id"));
            }
            return new ElementTag(object.getBukkitEntity().getType().name());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.getName(), true), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ItemTag.class, "saddle", (attribute, object) -> {
            if (object.getLivingEntity() instanceof AbstractHorse) {
                return new ItemTag(((AbstractHorse)object.getLivingEntity()).getInventory().getSaddle());
            }
            if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_15) && object.getLivingEntity() instanceof Pig) {
                return new ItemTag(((Pig)object.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR);
            }
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16) && object.getLivingEntity() instanceof Steerable) {
                return new ItemTag(((Steerable)object.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR);
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ItemTag.class, "horse_armor", (attribute, object) -> {
            if (object.getLivingEntity() instanceof Horse) {
                return new ItemTag(((Horse)object.getLivingEntity()).getInventory().getArmor());
            }
            return null;
        }, "horse_armour");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "has_saddle", (attribute, object) -> {
            if (object.getLivingEntity() instanceof AbstractHorse) {
                return new ElementTag(((AbstractHorse)object.getLivingEntity()).getInventory().getSaddle().getType() == Material.SADDLE);
            }
            if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_15) && object.getLivingEntity() instanceof Pig) {
                return new ElementTag(((Pig)object.getLivingEntity()).hasSaddle());
            }
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16) && object.getLivingEntity() instanceof Steerable) {
                return new ElementTag(((Steerable)object.getLivingEntity()).hasSaddle());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_trading", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Merchant) {
                return new ElementTag(((Merchant)object.getBukkitEntity()).isTrading());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "trading_with", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Merchant && ((Merchant)object.getBukkitEntity()).getTrader() != null) {
                return new EntityTag((Entity)((Merchant)object.getBukkitEntity()).getTrader()).getDenizenObject();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "map_trace", (attribute, object) -> {
            EntityHelper.MapTraceResult mtr = NMSHandler.getEntityHelper().mapTrace(object.getLivingEntity(), 200.0);
            if (mtr != null) {
                double x = 0.0;
                double basex = mtr.hitLocation.getX() - Math.floor(mtr.hitLocation.getX());
                double basey = mtr.hitLocation.getY() - Math.floor(mtr.hitLocation.getY());
                double basez = mtr.hitLocation.getZ() - Math.floor(mtr.hitLocation.getZ());
                if (mtr.angle == BlockFace.NORTH) {
                    x = 128.0 - basex * 128.0;
                } else if (mtr.angle == BlockFace.SOUTH) {
                    x = basex * 128.0;
                } else if (mtr.angle == BlockFace.WEST) {
                    x = basez * 128.0;
                } else if (mtr.angle == BlockFace.EAST) {
                    x = 128.0 - basez * 128.0;
                }
                double y = 128.0 - basey * 128.0;
                return new LocationTag(null, Math.round(x), Math.round(y));
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "can_see", (attribute, object) -> {
            EntityTag toEntity;
            if (object.isLivingEntity() && attribute.hasParam() && EntityTag.matches(attribute.getParam()) && (toEntity = attribute.paramAsType(EntityTag.class)) != null && toEntity.isSpawnedOrValidForTag()) {
                return new ElementTag(object.getLivingEntity().hasLineOfSight(toEntity.getBukkitEntity()));
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "eye_location", (attribute, object) -> new LocationTag(object.getEyeLocation()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "eye_height", (attribute, object) -> {
            if (object.isLivingEntity()) {
                return new ElementTag(object.getLivingEntity().getEyeHeight());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "cursor_on_solid", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), range, FluidCollisionMode.NEVER, true)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getLocation());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "cursor_on", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), range, FluidCollisionMode.ALWAYS, false)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getLocation());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "location", (attribute, object) -> object.doLocationTag(attribute), new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "standing_on", (attribute, object) -> {
            if (!object.getBukkitEntity().isOnGround()) {
                return null;
            }
            Location loc = object.getBukkitEntity().getLocation().clone().subtract(0.0, (double)0.05f, 0.0);
            return new LocationTag(loc.getWorld(), (double)loc.getBlockX(), (double)loc.getBlockY(), loc.getBlockZ());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "body_yaw", (attribute, object) -> new ElementTag(NMSHandler.getEntityHelper().getBaseYaw(object.getBukkitEntity())), new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "velocity", (attribute, object) -> new LocationTag(object.getBukkitEntity().getVelocity().toLocation(object.getBukkitEntity().getWorld())), new String[0]);
        EntityTag.registerSpawnedOnlyTag(WorldTag.class, "world", (attribute, object) -> new WorldTag(object.getBukkitEntity().getWorld()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "can_pickup_items", (attribute, object) -> {
            if (object.isLivingEntity()) {
                return new ElementTag(object.getLivingEntity().getCanPickupItems());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(MaterialTag.class, "fallingblock_material", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FallingBlock)) {
                return null;
            }
            return new MaterialTag(((FallingBlock)object.getBukkitEntity()).getBlockData());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fall_distance", (attribute, object) -> new ElementTag(object.getBukkitEntity().getFallDistance()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fire_time", (attribute, object) -> new DurationTag(object.getBukkitEntity().getFireTicks() / 20), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "on_fire", (attribute, object) -> new ElementTag(object.getBukkitEntity().getFireTicks() > 0), new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "leash_holder", (attribute, object) -> {
            if (object.isLivingEntity() && object.getLivingEntity().isLeashed()) {
                return new EntityTag(object.getLivingEntity().getLeashHolder()).getDenizenObject();
            }
            return null;
        }, "get_leash_holder");
        EntityTag.registerSpawnedOnlyTag(ListTag.class, "passengers", (attribute, object) -> {
            ArrayList<EntityTag> passengers = new ArrayList<EntityTag>();
            for (Entity ent : object.getBukkitEntity().getPassengers()) {
                passengers.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)passengers);
        }, "get_passengers");
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "passenger", (attribute, object) -> {
            if (!object.getBukkitEntity().isEmpty()) {
                return new EntityTag(object.getBukkitEntity().getPassenger()).getDenizenObject();
            }
            return null;
        }, "get_passenger");
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "shooter", (attribute, object) -> {
            EntityTag shooter = object.getShooter();
            if (shooter == null) {
                return null;
            }
            return shooter.getDenizenObject();
        }, "get_shooter");
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "left_shoulder", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof HumanEntity)) {
                return null;
            }
            Entity e = ((HumanEntity)object.getLivingEntity()).getShoulderEntityLeft();
            if (e == null) {
                return null;
            }
            return new EntityTag(e).getDenizenObject();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "right_shoulder", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof HumanEntity)) {
                return null;
            }
            Entity e = ((HumanEntity)object.getLivingEntity()).getShoulderEntityRight();
            if (e == null) {
                return null;
            }
            return new EntityTag(e).getDenizenObject();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "vehicle", (attribute, object) -> {
            if (object.getBukkitEntity().isInsideVehicle()) {
                return new EntityTag(object.getBukkitEntity().getVehicle()).getDenizenObject();
            }
            return null;
        }, "get_vehicle");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "can_breed", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof Breedable)) {
                return new ElementTag(false);
            }
            return new ElementTag(((Breedable)object.getLivingEntity()).canBreed());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "breeding", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof Animals)) {
                return null;
            }
            return new ElementTag(((Animals)object.getLivingEntity()).getLoveModeTicks() > 0);
        }, "is_breeding");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "has_passenger", (attribute, object) -> new ElementTag(!object.getBukkitEntity().isEmpty()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_empty", (attribute, object) -> new ElementTag(object.getBukkitEntity().isEmpty()), "empty");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_inside_vehicle", (attribute, object) -> new ElementTag(object.getBukkitEntity().isInsideVehicle()), "inside_vehicle");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_leashed", (attribute, object) -> new ElementTag(object.isLivingEntity() && object.getLivingEntity().isLeashed()), "leashed");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_sheared", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Sheep)) {
                return null;
            }
            return new ElementTag(((Sheep)object.getBukkitEntity()).isSheared());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_on_ground", (attribute, object) -> new ElementTag(object.getBukkitEntity().isOnGround()), "on_ground");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_persistent", (attribute, object) -> new ElementTag(object.isLivingEntity() && !object.getLivingEntity().getRemoveWhenFarAway()), "persistent");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_collidable", (attribute, object) -> {
            if (object.isCitizensNPC()) {
                return new ElementTag((Boolean)object.getDenizenNPC().getCitizen().data().get("collidable", (Object)true));
            }
            return new ElementTag(object.getLivingEntity().isCollidable());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_sleeping", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Player) {
                return new ElementTag(((Player)object.getBukkitEntity()).isSleeping());
            }
            if (object.getBukkitEntity() instanceof Villager) {
                return new ElementTag(((Villager)object.getBukkitEntity()).isSleeping());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(PlayerTag.class, "killer", (attribute, object) -> EntityTag.getPlayerFrom((Entity)object.getLivingEntity().getKiller()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ObjectTag.class, "last_damage", (attribute, object) -> {
            if (attribute.startsWith("amount", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getLivingEntity().getLastDamage());
            }
            if (attribute.startsWith("cause", 2)) {
                attribute.fulfill(1);
                if (object.getBukkitEntity().getLastDamageCause() == null) {
                    return null;
                }
                return new ElementTag(object.getBukkitEntity().getLastDamageCause().getCause().name());
            }
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getNoDamageTicks());
            }
            if (attribute.startsWith("max_duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getMaximumNoDamageTicks());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "absorption_health", (attribute, object) -> new ElementTag(NMSHandler.getEntityHelper().getAbsorption(object.getLivingEntity())), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "max_oxygen", (attribute, object) -> new DurationTag((long)object.getLivingEntity().getMaximumAir()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "oxygen", (attribute, object) -> {
            if (attribute.startsWith("max", 2)) {
                Deprecations.entityMaxOxygenTag.warn(attribute.context);
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getMaximumAir());
            }
            return new DurationTag((long)object.getLivingEntity().getRemainingAir());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "remove_when_far", (attribute, object) -> {
            Deprecations.entityRemoveWhenFar.warn(attribute.context);
            return new ElementTag(object.getLivingEntity().getRemoveWhenFarAway());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "target", (attribute, object) -> {
            Entity target;
            if (object.getBukkitEntity() instanceof Creature) {
                LivingEntity target2 = ((Creature)object.getLivingEntity()).getTarget();
                if (target2 != null) {
                    return new EntityTag((Entity)target2).getDenizenObject();
                }
            } else if (object.getBukkitEntity() instanceof ShulkerBullet && (target = ((ShulkerBullet)object.getLivingEntity()).getTarget()) != null) {
                return new EntityTag(target).getDenizenObject();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "precise_target", (attribute, object) -> {
            Predicate<Entity> requirement;
            int range = attribute.getIntParam();
            if (range < 1) {
                range = 200;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                String matcher = attribute.getParam();
                requirement = e -> !e.equals(object.getBukkitEntity()) && BukkitScriptEvent.tryEntity(new EntityTag((Entity)e), matcher);
            } else {
                requirement = e -> !e.equals(object.getBukkitEntity());
            }
            RayTraceResult result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, requirement);
            if (result != null && result.getHitEntity() != null) {
                return new EntityTag(result.getHitEntity()).getDenizenObject();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "precise_target_position", (attribute, object) -> {
            Predicate<Entity> requirement;
            int range = attribute.getIntParam();
            if (range < 1) {
                range = 200;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                String matcher = attribute.getParam();
                requirement = e -> !e.equals(object.getBukkitEntity()) && BukkitScriptEvent.tryEntity(new EntityTag((Entity)e), matcher);
            } else {
                requirement = e -> !e.equals(object.getBukkitEntity());
            }
            RayTraceResult result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, requirement);
            if (result != null) {
                return new LocationTag(object.getWorld(), result.getHitPosition());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "time_lived", (attribute, object) -> new DurationTag(object.getBukkitEntity().getTicksLived() / 20), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "pickup_delay", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Item)) {
                return null;
            }
            return new DurationTag(((Item)object.getBukkitEntity()).getPickupDelay() * 20);
        }, "pickupdelay");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_in_block", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Arrow) {
                return new ElementTag(((Arrow)object.getBukkitEntity()).isInBlock());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "attached_block", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Arrow) {
                Block attachedBlock = ((Arrow)object.getBukkitEntity()).getAttachedBlock();
                if (attachedBlock != null) {
                    return new LocationTag(attachedBlock.getLocation());
                }
            } else if (object.getBukkitEntity() instanceof Hanging) {
                Vector dir = ((Hanging)object.getBukkitEntity()).getAttachedFace().getDirection();
                return new LocationTag(object.getLocation().clone().add(dir.multiply(0.5))).getBlockLocation();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "gliding", (attribute, object) -> new ElementTag(object.getLivingEntity().isGliding()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "swimming", (attribute, object) -> new ElementTag(object.getLivingEntity().isSwimming()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "glowing", (attribute, object) -> new ElementTag(object.getBukkitEntity().isGlowing()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_living", (attribute, object) -> new ElementTag(object.isLivingEntityType()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_monster", (attribute, object) -> new ElementTag(object.isMonsterType()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_mob", (attribute, object) -> new ElementTag(object.isMobType()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_npc", (attribute, object) -> new ElementTag(object.isCitizensNPC()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_player", (attribute, object) -> new ElementTag(object.isPlayer()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_projectile", (attribute, object) -> {
            if (object.getBukkitEntity() == null && object.entity_type != null) {
                return new ElementTag(Projectile.class.isAssignableFrom(object.entity_type.getBukkitEntityType().getEntityClass()));
            }
            return new ElementTag(object.isProjectile());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "tameable", (attribute, object) -> new ElementTag(EntityTame.describes(object)), "is_tameable");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "ageable", (attribute, object) -> new ElementTag(EntityAge.describes(object)), "is_ageable");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "colorable", (attribute, object) -> new ElementTag(EntityColor.describes(object)), "is_colorable");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "experience", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof ExperienceOrb)) {
                return null;
            }
            return new ElementTag(((ExperienceOrb)object.getBukkitEntity()).getExperience());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fuse_ticks", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof TNTPrimed)) {
                return null;
            }
            return new ElementTag(((TNTPrimed)object.getBukkitEntity()).getFuseTicks());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "dragon_phase", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof EnderDragon)) {
                return null;
            }
            return new ElementTag(((EnderDragon)object.getLivingEntity()).getPhase().name());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "weapon_damage", (attribute, object) -> {
            Entity target = null;
            if (attribute.hasParam()) {
                target = attribute.paramAsType(EntityTag.class).getBukkitEntity();
            }
            return new ElementTag(NMSHandler.getEntityHelper().getDamageTo(object.getLivingEntity(), target));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ListTag.class, "skin_layers", (attribute, object) -> {
            byte flags = NMSHandler.getPlayerHelper().getSkinLayers((Player)object.getBukkitEntity());
            ListTag result = new ListTag();
            for (PlayerHelper.SkinLayer layer : PlayerHelper.SkinLayer.values()) {
                if ((flags & layer.flag) == 0) continue;
                result.add(layer.name());
            }
            return result;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_disguised", (attribute, object) -> {
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return new ElementTag(false);
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                return new ElementTag(map.containsKey(player.getUUID()) || map.containsKey(null));
            }
            return new ElementTag(map.containsKey(null));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "disguised_type", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            return disguise.as.duplicate();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "disguise_to_others", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            if (disguise.toOthers == null) {
                return null;
            }
            return disguise.toOthers.entity;
        }, new String[0]);
        tagProcessor.registerTag(EntityTag.class, "describe", (attribute, object) -> object.describe(attribute.context), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "advanced_matches", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(BukkitScriptEvent.tryEntity(object, attribute.getParam()));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "has_equipped", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            if (!object.isLivingEntity()) {
                return null;
            }
            String matcher = attribute.getParam();
            for (ItemStack item : object.getLivingEntity().getEquipment().getArmorContents()) {
                if (!BukkitScriptEvent.tryItem(new ItemTag(item), matcher)) continue;
                return new ElementTag(true);
            }
            return new ElementTag(false);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "loot_table_id", (attribute, object) -> {
            LootTable table;
            if (object.getBukkitEntity() instanceof Lootable && (table = ((Lootable)object.getBukkitEntity()).getLootTable()) != null) {
                return new ElementTag(table.getKey().toString());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fish_hook_state", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_state is only valid for fish hooks.");
                return null;
            }
            return new ElementTag(((FishHook)object.getBukkitEntity()).getState().name());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fish_hook_lure_time", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_lure_time is only valid for fish hooks.");
                return null;
            }
            return new DurationTag((long)NMSHandler.getFishingHelper().getLureTime((FishHook)object.getBukkitEntity()));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fish_hook_min_lure_time", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_min_lure_time is only valid for fish hooks.");
                return null;
            }
            return new DurationTag((long)((FishHook)object.getBukkitEntity()).getMinWaitTime());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fish_hook_max_lure_time", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_max_lure_time is only valid for fish hooks.");
                return null;
            }
            return new DurationTag((long)((FishHook)object.getBukkitEntity()).getMaxWaitTime());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "fish_hook_hooked_entity", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_hooked_entity is only valid for fish hooks.");
                return null;
            }
            Entity entity = ((FishHook)object.getBukkitEntity()).getHookedEntity();
            return entity != null ? new EntityTag(entity) : null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fish_hook_apply_lure", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_apply_lure is only valid for fish hooks.");
                return null;
            }
            return new ElementTag(((FishHook)object.getBukkitEntity()).getApplyLure());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fish_hook_in_open_water", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_in_open_water is only valid for fish hooks.");
                return null;
            }
            return new ElementTag(((FishHook)object.getBukkitEntity()).isInOpenWater());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ListTag.class, "attached_entities", (attribute, object) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : null;
            EntityAttachmentHelper.EntityAttachedToMap data = EntityAttachmentHelper.toEntityToData.get(object.getUUID());
            ListTag result = new ListTag();
            if (data == null) {
                return result;
            }
            for (EntityAttachmentHelper.PlayerAttachMap map : data.attachedToMap.values()) {
                if (player != null && map.getAttachment(player.getUUID()) == null) continue;
                result.addObject(map.attached);
            }
            return result;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "attached_to", (attribute, object) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : null;
            EntityAttachmentHelper.PlayerAttachMap data = EntityAttachmentHelper.attachedEntityToData.get(object.getUUID());
            if (data == null) {
                return null;
            }
            EntityAttachmentHelper.AttachmentData attached = data.getAttachment(player == null ? null : player.getUUID());
            if (attached == null) {
                return null;
            }
            return attached.to;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "attached_offset", (attribute, object) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : null;
            EntityAttachmentHelper.PlayerAttachMap data = EntityAttachmentHelper.attachedEntityToData.get(object.getUUID());
            if (data == null) {
                return null;
            }
            EntityAttachmentHelper.AttachmentData attached = data.getAttachment(player == null ? null : player.getUUID());
            if (attached == null) {
                return null;
            }
            return attached.positionalOffset == null ? null : new LocationTag(attached.positionalOffset);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "attack_cooldown_duration", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Player)) {
                attribute.echoError("Only player-type entities can have attack_cooldowns!");
                return null;
            }
            return new DurationTag((long)NMSHandler.getPlayerHelper().ticksPassedDuringCooldown((Player)object.getLivingEntity()));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "attack_cooldown_max_duration", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Player)) {
                attribute.echoError("Only player-type entities can have attack_cooldowns!");
                return null;
            }
            return new DurationTag((long)NMSHandler.getPlayerHelper().getMaxAttackCooldownTicks((Player)object.getLivingEntity()));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "attack_cooldown_percent", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Player)) {
                attribute.echoError("Only player-type entities can have attack_cooldowns!");
                return null;
            }
            return new ElementTag(NMSHandler.getPlayerHelper().getAttackCooldownPercent((Player)object.getLivingEntity()) * 100.0f);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_hand_raised", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof HumanEntity)) {
                attribute.echoError("Only player-type entities can have is_hand_raised!");
                return null;
            }
            return new ElementTag(((HumanEntity)object.getLivingEntity()).isHandRaised());
        }, new String[0]);
    }

    public EntityTag describe(TagContext context) {
        ArrayList<Mechanism> waitingMechs;
        if (this.isSpawnedOrValidForTag()) {
            waitingMechs = new ArrayList();
            for (Map.Entry<StringHolder, ObjectTag> property : PropertyParser.getPropertiesMap((ObjectTag)this).map.entrySet()) {
                waitingMechs.add(new Mechanism(property.getKey().str, property.getValue(), context));
            }
        } else {
            waitingMechs = new ArrayList<Mechanism>(this.getWaitingMechanisms());
        }
        EntityTag entity = new EntityTag(this.entity_type, waitingMechs);
        entity.entityScript = this.entityScript;
        return entity;
    }

    public static <R extends ObjectTag> void registerSpawnedOnlyTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<EntityTag, R> runnable, String ... variants) {
        tagProcessor.registerTag(returnType, name, (attribute, object) -> {
            if (!object.isSpawnedOrValidForTag()) {
                if (!attribute.hasAlternative()) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("Entity is not spawned, but tag '" + attribute.getAttributeWithoutParam(1) + "' requires the entity be spawned, for entity: " + object.debuggable());
                }
                return null;
            }
            return runnable.run(attribute, (EntityTag)object);
        }, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ArrayList<Mechanism> getWaitingMechanisms() {
        return this.mechanisms;
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
        } else {
            Debug.echoError("Cannot apply properties to an already-spawned entity!");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void adjust(Mechanism mechanism) {
        Entity bukkitEnt;
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
            return;
        }
        if (this.getBukkitEntity() == null) {
            if (this.isCitizensNPC()) {
                Debug.echoError("Cannot adjust not-spawned NPC " + this.getDenizenNPC());
            } else {
                Debug.echoError("Cannot adjust entity " + this);
            }
            return;
        }
        if (mechanism.matches("attach_to")) {
            Deprecations.attachToMech.warn(mechanism.context);
            if (mechanism.hasValue()) {
                void var3_12;
                ListTag list = mechanism.valueAsType(ListTag.class);
                Object var3_10 = null;
                boolean rotateWith = true;
                if (list.size() > 1) {
                    Vector vector = LocationTag.valueOf(list.get(1), mechanism.context).toVector();
                    if (list.size() > 2) {
                        rotateWith = new ElementTag(list.get(2)).asBoolean();
                    }
                }
                EntityAttachmentHelper.forceAttachMove(this, EntityTag.valueOf(list.get(0), mechanism.context), (Vector)var3_12, rotateWith);
            } else {
                EntityAttachmentHelper.forceAttachMove(this, null, null, false);
            }
        }
        if (mechanism.matches("shooter")) {
            this.setShooter(mechanism.valueAsType(EntityTag.class));
        }
        if (mechanism.matches("can_pickup_items") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCanPickupItems(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fall_distance") && mechanism.requireFloat()) {
            this.entity.setFallDistance(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fallingblock_drop_item") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setDropItem(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fallingblock_hurt_entities") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setHurtEntities(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fire_time") && mechanism.requireObject(DurationTag.class)) {
            this.entity.setFireTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("leash_holder") && mechanism.requireObject(EntityTag.class)) {
            this.getLivingEntity().setLeashHolder(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("can_breed") && mechanism.requireBoolean()) {
            ((Ageable)this.getLivingEntity()).setBreed(true);
        }
        if (mechanism.matches("breed") && mechanism.requireBoolean()) {
            ((Animals)this.getLivingEntity()).setLoveModeTicks(mechanism.getValue().asBoolean() ? 600 : 0);
        }
        if (mechanism.matches("passengers")) {
            this.entity.eject();
            for (EntityTag entityTag : mechanism.valueAsType(ListTag.class).filter(EntityTag.class, mechanism.context)) {
                if (this.comparesTo(entityTag) == 1) continue;
                if (!entityTag.isSpawned()) {
                    entityTag.spawnAt(this.getLocation());
                }
                if (!entityTag.isSpawned()) continue;
                this.entity.addPassenger(entityTag.getBukkitEntity());
            }
        }
        if (mechanism.matches("passenger") && mechanism.requireObject(EntityTag.class)) {
            EntityTag ent3 = mechanism.valueAsType(EntityTag.class);
            if (!ent3.isSpawned()) {
                ent3.spawnAt(this.getLocation());
            }
            this.entity.eject();
            if (ent3.isSpawned()) {
                this.entity.addPassenger(ent3.getBukkitEntity());
            }
        }
        if (mechanism.matches("time_lived") && mechanism.requireObject(DurationTag.class)) {
            NMSHandler.getEntityHelper().setTicksLived(this.entity, mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("absorption_health") && mechanism.requireFloat()) {
            NMSHandler.getEntityHelper().setAbsorption(this.getLivingEntity(), mechanism.getValue().asDouble());
        }
        if (mechanism.matches("oxygen") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setRemainingAir(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("remaining_air") && mechanism.requireInteger()) {
            Deprecations.entityRemainingAir.warn(mechanism.context);
            this.getLivingEntity().setRemainingAir(mechanism.getValue().asInt());
        }
        if (mechanism.matches("remove_effects")) {
            for (PotionEffect potionEffect : this.getLivingEntity().getActivePotionEffects()) {
                this.getLivingEntity().removePotionEffect(potionEffect.getType());
            }
        }
        if (mechanism.matches("release_left_shoulder") && this.getLivingEntity() instanceof HumanEntity && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityLeft()) != null) {
            EntityTag entityTag = new EntityTag(bukkitEnt);
            String escript = entityTag.getEntityScript();
            EntityTag entityTag2 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : entityTag.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(entityTag), mechanism.context);
            entityTag2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
        }
        if (mechanism.matches("release_right_shoulder") && this.getLivingEntity() instanceof HumanEntity && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityRight()) != null) {
            EntityTag entityTag = new EntityTag(bukkitEnt);
            String escript = entityTag.getEntityScript();
            EntityTag entityTag3 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : entityTag.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(entityTag), mechanism.context);
            entityTag3.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
        }
        if (mechanism.matches("left_shoulder") && this.getLivingEntity() instanceof HumanEntity) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
            }
        }
        if (mechanism.matches("right_shoulder") && this.getLivingEntity() instanceof HumanEntity) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
            }
        }
        if (mechanism.matches("persistent") && mechanism.requireBoolean()) {
            this.getLivingEntity().setRemoveWhenFarAway(!mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("remove_when_far_away") && mechanism.requireBoolean()) {
            Deprecations.entityRemoveWhenFar.warn(mechanism.context);
            this.getLivingEntity().setRemoveWhenFarAway(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sheared") && mechanism.requireBoolean() && this.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.getBukkitEntity()).setSheared(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("collidable") && mechanism.requireBoolean()) {
            if (this.isCitizensNPC()) {
                this.getDenizenNPC().getCitizen().data().setPersistent("collidable", (Object)mechanism.getValue().asBoolean());
            } else {
                this.getLivingEntity().setCollidable(mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("max_no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setMaximumNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("velocity") && mechanism.requireObject(LocationTag.class)) {
            this.setVelocity(mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("move") && mechanism.requireObject(LocationTag.class)) {
            NMSHandler.getEntityHelper().move(this.getBukkitEntity(), mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("interact_with") && mechanism.requireObject(LocationTag.class)) {
            LocationTag interactLocation = mechanism.valueAsType(LocationTag.class);
            NMSHandler.getEntityHelper().forceInteraction(this.getPlayer(), interactLocation);
        }
        if (mechanism.matches("play_death")) {
            Deprecations.entityPlayDeath.warn(mechanism.context);
            this.getLivingEntity().playEffect(EntityEffect.DEATH);
        }
        if ((mechanism.matches("pickup_delay") || mechanism.matches("pickupdelay")) && this.getBukkitEntity() instanceof Item && mechanism.requireObject(DurationTag.class)) {
            ((Item)this.getBukkitEntity()).setPickupDelay(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("gliding") && mechanism.requireBoolean()) {
            this.getLivingEntity().setGliding(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("glowing") && mechanism.requireBoolean()) {
            this.getBukkitEntity().setGlowing(mechanism.getValue().asBoolean());
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)this.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)this.getLivingEntity()).data().setPersistent("glowing", (Object)mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("dragon_phase")) {
            EnderDragon ed = (EnderDragon)this.getLivingEntity();
            ed.setPhase(EnderDragon.Phase.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("experience") && this.getBukkitEntity() instanceof ExperienceOrb && mechanism.requireInteger()) {
            ((ExperienceOrb)this.getBukkitEntity()).setExperience(mechanism.getValue().asInt());
        }
        if (mechanism.matches("fuse_ticks") && this.getBukkitEntity() instanceof TNTPrimed && mechanism.requireInteger()) {
            ((TNTPrimed)this.getBukkitEntity()).setFuseTicks(mechanism.getValue().asInt());
        }
        if (mechanism.matches("show_to_players")) {
            HideEntitiesHelper.unhideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("hide_from_players")) {
            HideEntitiesHelper.hideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("skin_layers")) {
            int flags = 0;
            for (String str : mechanism.valueAsType(ListTag.class)) {
                String upper = str.toUpperCase();
                if (upper.equals("ALL")) {
                    flags = 255;
                    continue;
                }
                PlayerHelper.SkinLayer layer = PlayerHelper.SkinLayer.valueOf(upper);
                flags |= layer.flag;
            }
            NMSHandler.getPlayerHelper().setSkinLayers((Player)this.getBukkitEntity(), (byte)flags);
        }
        if (mechanism.matches("mirror_player") && mechanism.requireBoolean()) {
            if (this.isNPC()) {
                NPC npc = this.getDenizenNPC().getCitizen();
                if (!npc.hasTrait(MirrorTrait.class)) {
                    npc.addTrait(MirrorTrait.class);
                }
                MirrorTrait mirrorTrait = (MirrorTrait)npc.getOrAddTrait(MirrorTrait.class);
                if (mechanism.getValue().asBoolean()) {
                    mirrorTrait.enableMirror();
                } else {
                    mirrorTrait.disableMirror();
                }
            } else if (mechanism.getValue().asBoolean()) {
                ProfileEditor.mirrorUUIDs.add(this.getUUID());
            } else {
                ProfileEditor.mirrorUUIDs.remove(this.getUUID());
            }
        }
        if (mechanism.matches("swimming") && mechanism.requireBoolean()) {
            this.getLivingEntity().setSwimming(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("detonate")) {
            if (this.getBukkitEntity() instanceof Firework) {
                ((Firework)this.getBukkitEntity()).detonate();
            } else if (this.getBukkitEntity() instanceof Creeper) {
                ((Creeper)this.getBukkitEntity()).explode();
            } else {
                Debug.echoError("Cannot detonate entity of type '" + this.getBukkitEntityType().name() + "'.");
            }
        }
        if (mechanism.matches("ignite")) {
            if (this.getBukkitEntity() instanceof Creeper) {
                ((Creeper)this.getBukkitEntity()).ignite();
            } else {
                Debug.echoError("Cannot ignite entity of type '" + this.getBukkitEntityType().name() + "'.");
            }
        }
        if (mechanism.matches("head_angle") && mechanism.requireFloat()) {
            NMSHandler.getEntityHelper().setHeadAngle(this.getBukkitEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("skeleton_arms_raised") && mechanism.requireBoolean()) {
            EntityAnimation entityAnimation = NMSHandler.getAnimationHelper().getEntityAnimation(mechanism.getValue().asBoolean() ? "SKELETON_START_SWING_ARM" : "SKELETON_STOP_SWING_ARM");
            entityAnimation.play(this.entity);
        }
        if (mechanism.matches("polar_bear_standing") && mechanism.requireBoolean()) {
            EntityAnimation entityAnimation = NMSHandler.getAnimationHelper().getEntityAnimation(mechanism.getValue().asBoolean() ? "POLAR_BEAR_START_STANDING" : "POLAR_BEAR_STOP_STANDING");
            entityAnimation.play(this.entity);
        }
        if (mechanism.matches("ghast_attacking") && mechanism.requireBoolean()) {
            NMSHandler.getEntityHelper().setGhastAttacking(this.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("enderman_angry") && mechanism.requireBoolean()) {
            NMSHandler.getEntityHelper().setEndermanAngry(this.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("melee_attack") && mechanism.requireObject(EntityTag.class)) {
            Entity target = mechanism.valueAsType(EntityTag.class).getBukkitEntity();
            if (this.getLivingEntity() instanceof Player && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
                NMSHandler.getPlayerHelper().doAttack((Player)this.getLivingEntity(), target);
            } else {
                this.getLivingEntity().attack(target);
            }
        }
        if (mechanism.matches("last_hurt_by") && mechanism.requireObject(EntityTag.class)) {
            NMSHandler.getEntityHelper().setLastHurtBy(this.getLivingEntity(), mechanism.valueAsType(EntityTag.class).getLivingEntity());
        }
        if (mechanism.matches("fish_hook_nibble_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_nibble_time is only valid for FishHook entities.");
                return;
            }
            NMSHandler.getFishingHelper().setNibble((FishHook)this.getBukkitEntity(), mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_bite_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_hook_time is only valid for FishHook entities.");
                return;
            }
            NMSHandler.getFishingHelper().setHookTime((FishHook)this.getBukkitEntity(), mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_lure_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_lure_time is only valid for FishHook entities.");
                return;
            }
            NMSHandler.getFishingHelper().setLureTime((FishHook)this.getBukkitEntity(), mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_pull")) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_pull is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).pullHookedEntity();
        }
        if (mechanism.matches("fish_hook_apply_lure") && mechanism.requireBoolean()) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_apply_lure is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setApplyLure(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fish_hook_hooked_entity") && mechanism.requireObject(EntityTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_hooked_entity is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setHookedEntity(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("fish_hook_min_lure_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_min_lure_time is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setMinWaitTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_max_lure_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_max_lure_time is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setMaxWaitTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("redo_attack_cooldown")) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            NMSHandler.getPlayerHelper().setAttackCooldown((Player)this.getLivingEntity(), 0);
        }
        if (mechanism.matches("reset_attack_cooldown")) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            PlayerHelper playerHelper = NMSHandler.getPlayerHelper();
            playerHelper.setAttackCooldown((Player)this.getLivingEntity(), Math.round(playerHelper.getMaxAttackCooldownTicks((Player)this.getLivingEntity())));
        }
        if (mechanism.matches("attack_cooldown_percent") && mechanism.requireFloat()) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            float percent = mechanism.getValue().asFloat();
            if (percent >= 0.0f && percent <= 1.0f) {
                PlayerHelper playerHelper = NMSHandler.getPlayerHelper();
                playerHelper.setAttackCooldown((Player)this.getLivingEntity(), Math.round(playerHelper.getMaxAttackCooldownTicks((Player)this.getLivingEntity()) * mechanism.getValue().asFloat()));
            } else {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("Invalid percentage! \"" + percent + "\" is not between 0 and 1!");
            }
        }
        if (mechanism.matches("attack_cooldown") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            NMSHandler.getPlayerHelper().setAttackCooldown((Player)this.getLivingEntity(), mechanism.getValue().asType(DurationTag.class, mechanism.context).getTicksAsInt());
        }
        if (mechanism.matches("fallingblock_type") && mechanism.requireObject(MaterialTag.class)) {
            if (!(this.getBukkitEntity() instanceof FallingBlock)) {
                mechanism.echoError("'fallingblock_type' is only valid for Falling Block entities.");
                return;
            }
            NMSHandler.getEntityHelper().setFallingBlockType((FallingBlock)this.getBukkitEntity(), mechanism.valueAsType(MaterialTag.class).getModernData());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    @Override
    public boolean advancedMatches(String matcher) {
        return BukkitScriptEvent.tryEntity(this, matcher);
    }

    private class DespawnedEntity {
        Double health = null;
        Location location = null;
        ItemStack[] equipment = null;
        String custom_script = null;

        public DespawnedEntity(EntityTag entity) {
            if (entity != null) {
                this.health = entity.getLivingEntity().getHealth();
                this.location = entity.getLivingEntity().getLocation();
                this.equipment = entity.getLivingEntity().getEquipment().getArmorContents();
                if (CustomNBT.hasCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id")) {
                    this.custom_script = CustomNBT.getCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id");
                }
            }
        }
    }
}

