/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFirework
implements Property {
    public static final String[] handledMechs = new String[]{"firework", "firework_power"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && (((ItemTag)item).getItemMeta() instanceof FireworkMeta || ((ItemTag)item).getItemMeta() instanceof FireworkEffectMeta);
    }

    public static ItemFirework getFrom(ObjectTag _item) {
        if (!ItemFirework.describes(_item)) {
            return null;
        }
        return new ItemFirework((ItemTag)_item);
    }

    private ItemFirework(ItemTag _item) {
        this.item = _item;
    }

    public ListTag getFireworkData() {
        List<FireworkEffect> effects;
        ListTag list = new ListTag();
        if (this.item.getItemMeta() instanceof FireworkMeta) {
            effects = ((FireworkMeta)this.item.getItemMeta()).getEffects();
            int power = ((FireworkMeta)this.item.getItemMeta()).getPower();
            if (power != 0) {
                list.add(String.valueOf(power));
            }
        } else {
            effects = Collections.singletonList(((FireworkEffectMeta)this.item.getItemMeta()).getEffect());
        }
        if (effects != null) {
            for (FireworkEffect effect : effects) {
                if (effect == null) continue;
                Color ColOne = effect.getColors() != null && effect.getColors().size() > 0 ? (Color)effect.getColors().get(0) : Color.BLUE;
                Color ColTwo = effect.getFadeColors() != null && effect.getFadeColors().size() > 0 ? (Color)effect.getFadeColors().get(0) : ColOne;
                list.add(effect.hasTrail() + "," + effect.hasFlicker() + "," + effect.getType().name() + "," + ColOne.getRed() + "," + ColOne.getGreen() + "," + ColOne.getBlue() + "," + ColTwo.getRed() + "," + ColTwo.getGreen() + "," + ColTwo.getBlue());
            }
        }
        return list;
    }

    public ListTag getFireworkDataMap() {
        ListTag list = new ListTag();
        List<FireworkEffect> effects = this.item.getItemMeta() instanceof FireworkMeta ? ((FireworkMeta)this.item.getItemMeta()).getEffects() : Collections.singletonList(((FireworkEffectMeta)this.item.getItemMeta()).getEffect());
        if (effects != null) {
            for (FireworkEffect effect : effects) {
                if (effect == null) continue;
                Color ColOne = effect.getColors() != null && effect.getColors().size() > 0 ? (Color)effect.getColors().get(0) : Color.BLUE;
                Color ColTwo = effect.getFadeColors() != null && effect.getFadeColors().size() > 0 ? (Color)effect.getFadeColors().get(0) : ColOne;
                MapTag effectMap = new MapTag();
                effectMap.putObject("trail", new ElementTag(effect.hasTrail()));
                effectMap.putObject("flicker", new ElementTag(effect.hasFlicker()));
                effectMap.putObject("type", new ElementTag(effect.getType().name()));
                effectMap.putObject("color", new ColorTag(ColOne));
                effectMap.putObject("fade_color", new ColorTag(ColTwo));
                list.addObject(effectMap);
            }
        }
        return list;
    }

    public int getPower() {
        return this.item.getItemMeta() instanceof FireworkMeta ? ((FireworkMeta)this.item.getItemMeta()).getPower() : 0;
    }

    public static void registerTags() {
        PropertyParser.registerTag(ListTag.class, "firework", (attribute, object) -> object.getFireworkData(), new String[0]);
        PropertyParser.registerTag(ListTag.class, "firework_map", (attribute, object) -> object.getFireworkDataMap(), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "firework_power", (attribute, object) -> {
            ItemMeta meta = object.item.getItemMeta();
            return meta instanceof FireworkMeta ? new ElementTag(((FireworkMeta)meta).getPower()) : null;
        }, new String[0]);
    }

    @Override
    public String getPropertyString() {
        ListTag data = this.getFireworkData();
        return data.size() > 0 ? data.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "firework";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        ItemMeta meta;
        if (mechanism.matches("firework_power") && mechanism.requireInteger()) {
            if (this.item.getItemMeta() instanceof FireworkMeta) {
                meta = this.item.getItemMeta();
                ((FireworkMeta)meta).setPower(mechanism.getValue().asInt());
                this.item.setItemMeta(meta);
            } else {
                mechanism.echoError("Cannot set the power of a firework effect!");
            }
        }
        if (mechanism.matches("firework")) {
            meta = this.item.getItemMeta();
            if (!mechanism.hasValue()) {
                if (meta instanceof FireworkMeta) {
                    ((FireworkMeta)meta).clearEffects();
                } else {
                    ((FireworkEffectMeta)meta).setEffect(null);
                }
            } else {
                Collection<ObjectTag> list = CoreUtilities.objectToList(mechanism.getValue(), mechanism.context);
                for (ObjectTag object : list) {
                    if (object instanceof MapTag) {
                        MapTag effectMap = object.asType(MapTag.class, mechanism.context);
                        FireworkEffect.Builder builder = FireworkEffect.builder();
                        ObjectTag type = effectMap.getObject("type");
                        ObjectTag color = effectMap.getObject("color");
                        ObjectTag fadeColor = effectMap.getObject("fade_color");
                        ObjectTag trail = effectMap.getObject("trail");
                        ObjectTag flicker = effectMap.getObject("flicker");
                        builder.trail(trail != null && trail.asElement().asBoolean());
                        builder.flicker(flicker != null && flicker.asElement().asBoolean());
                        if (type != null) {
                            ElementTag effectType = type.asElement();
                            if (effectType.matchesEnum((Enum[])FireworkEffect.Type.values())) {
                                builder.with(FireworkEffect.Type.valueOf((String)effectType.asString().toUpperCase()));
                            } else {
                                mechanism.echoError("Invalid firework type '" + effectType.asString() + "'");
                            }
                        }
                        ColorTag co = new ColorTag(Color.BLACK);
                        if (color != null && ColorTag.matches(color.toString())) {
                            co = ColorTag.valueOf(color.toString(), mechanism.context);
                        } else if (color != null) {
                            mechanism.echoError("Invalid color '" + color + "'");
                        }
                        builder.withColor(co.getColor());
                        if (fadeColor != null) {
                            ColorTag fadeCo = ColorTag.valueOf(fadeColor.toString(), mechanism.context);
                            if (fadeCo != null) {
                                builder.withFade(fadeCo.getColor());
                            } else {
                                mechanism.echoError("Invalid fade color '" + fadeColor + "'");
                            }
                        }
                        FireworkEffect built = builder.build();
                        if (meta instanceof FireworkMeta) {
                            ((FireworkMeta)meta).addEffect(built);
                            continue;
                        }
                        ((FireworkEffectMeta)meta).setEffect(built);
                        continue;
                    }
                    String effect = object.toString();
                    String[] data = effect.split(",");
                    if (data.length == 9) {
                        FireworkEffect.Builder builder = FireworkEffect.builder();
                        builder.trail(new ElementTag(data[0]).asBoolean());
                        builder.flicker(new ElementTag(data[1]).asBoolean());
                        if (new ElementTag(data[2]).matchesEnum((Enum[])FireworkEffect.Type.values())) {
                            builder.with(FireworkEffect.Type.valueOf((String)data[2].toUpperCase()));
                        } else {
                            mechanism.echoError("Invalid firework type '" + data[2] + "'");
                        }
                        builder.withColor(Color.fromRGB((int)new ElementTag(data[3]).asInt(), (int)new ElementTag(data[4]).asInt(), (int)new ElementTag(data[5]).asInt()));
                        builder.withFade(Color.fromRGB((int)new ElementTag(data[6]).asInt(), (int)new ElementTag(data[7]).asInt(), (int)new ElementTag(data[8]).asInt()));
                        FireworkEffect built = builder.build();
                        if (meta instanceof FireworkMeta) {
                            ((FireworkMeta)meta).addEffect(built);
                            continue;
                        }
                        ((FireworkEffectMeta)meta).setEffect(built);
                        continue;
                    }
                    if (data.length == 1) {
                        if (meta instanceof FireworkMeta) {
                            ((FireworkMeta)meta).setPower(new ElementTag(data[0]).asInt());
                            continue;
                        }
                        mechanism.echoError("Cannot set the power of a firework effect!");
                        continue;
                    }
                    mechanism.echoError("Invalid firework data '" + effect + "'");
                }
            }
            this.item.setItemMeta(meta);
        }
    }
}

