/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class KillCommand
extends AbstractCommand {
    public KillCommand() {
        this.setName("kill");
        this.setSyntax("kill ({player}/<entity>|...)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, true));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), KillCommand.db("entities", entities));
        }
        for (EntityTag entity : entities) {
            if (!entity.isLivingEntity()) {
                Debug.echoError(scriptEntry.getResidingQueue(), entity + " is not a living entity!");
                continue;
            }
            LivingEntity livingEntity = entity.getLivingEntity();
            livingEntity.damage(livingEntity.getHealth());
            if (!(livingEntity.getHealth() > 0.0)) continue;
            livingEntity.setHealth(0.0);
        }
    }
}

