/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;

public class ClickableCommand
extends AbstractCommand {
    public static HashMap<UUID, Clickable> clickables = new HashMap();

    public ClickableCommand() {
        this.setName("clickable");
        this.setSyntax("clickable [<script>/cancel:<id>] (def:<element>|.../defmap:<map>/def.<name>:<value>) (usages:<#>) (for:<player>|...) (until:<duration>)");
        this.setRequiredArguments(1, -1);
        this.isProcedural = false;
        this.allowedDynamicPrefixes = true;
        this.setPrefixesHandled("usages", "until", "for", "cancel", "def");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addScriptsOfType(TaskScriptContainer.class);
    }

    public static void runClickable(UUID id, Player player) {
        Clickable clickable = clickables.get(id);
        if (clickable == null) {
            return;
        }
        if (clickable.until != 0L && CoreUtilities.monotonicMillis() > clickable.until) {
            clickables.remove(id);
            return;
        }
        if (clickable.forPlayers != null && !clickable.forPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (clickable.remainingUsages > 0) {
            --clickable.remainingUsages;
            if (clickable.remainingUsages <= 0) {
                clickables.remove(id);
            }
        }
        Consumer<ScriptQueue> configure = queue -> {
            if (clickable.defMap != null) {
                for (Map.Entry<StringHolder, ObjectTag> val : clickable.defMap.map.entrySet()) {
                    queue.addDefinition(val.getKey().str, val.getValue());
                }
            }
        };
        ScriptUtilities.createAndStartQueue(clickable.script.getContainer(), clickable.path, new BukkitScriptEntryData(new PlayerTag(player), clickable.npc), null, configure, null, null, clickable.definitions, clickable.context);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        MapTag defMap = new MapTag();
        for (Argument arg : scriptEntry) {
            if (arg.matchesPrefix("defmap") && arg.matchesArgumentType(MapTag.class)) {
                defMap.map.putAll(arg.asType(MapTag.class).map);
                continue;
            }
            if (arg.hasPrefix() && arg.getPrefix().getRawValue().startsWith("def.")) {
                defMap.putObject(arg.getPrefix().getRawValue().substring("def.".length()), arg.object);
                continue;
            }
            if (!scriptEntry.hasObject("script")) {
                ScriptTag script;
                String scriptName = arg.getRawValue();
                int dotIndex = scriptName.indexOf(46);
                if (dotIndex > 0) {
                    scriptEntry.addObject("path", new ElementTag(scriptName.substring(dotIndex + 1)));
                    scriptName = scriptName.substring(0, dotIndex);
                }
                if (!(script = new ScriptTag(scriptName)).isValid()) {
                    arg.reportUnhandled();
                    continue;
                }
                scriptEntry.addObject("script", script);
                continue;
            }
            arg.reportUnhandled();
        }
        if (!defMap.map.isEmpty()) {
            scriptEntry.addObject("def_map", defMap);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        ElementTag path = scriptEntry.getElement("path");
        ElementTag cancel = scriptEntry.argForPrefixAsElement("cancel", null);
        List<PlayerTag> forPlayers = scriptEntry.argForPrefixList("for", PlayerTag.class, true);
        ElementTag usages = scriptEntry.argForPrefixAsElement("usages", null);
        ListTag definitions = scriptEntry.argForPrefix("def", ListTag.class, true);
        DurationTag until = scriptEntry.argForPrefix("until", DurationTag.class, true);
        MapTag defMap = (MapTag)scriptEntry.getObjectTag("def_map");
        if (script == null && cancel == null) {
            throw new InvalidArgumentsRuntimeException("Missing script argument!");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), script, cancel, path, usages, definitions, defMap, until, ClickableCommand.db("for", forPlayers));
        }
        if (cancel != null) {
            UUID id;
            try {
                id = UUID.fromString(cancel.asString());
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid cancel ID: " + ex.getMessage());
                return;
            }
            Clickable clicky = clickables.remove(id);
            if (clicky == null) {
                Debug.echoDebug((Debuggable)scriptEntry, "Cancelled ID didn't exist, nothing to cancel.");
            } else {
                Debug.echoDebug((Debuggable)scriptEntry, "Cancelled.");
            }
            return;
        }
        UUID id = UUID.randomUUID();
        Clickable newClickable = new Clickable();
        newClickable.script = script;
        newClickable.path = path == null ? null : path.asString();
        newClickable.definitions = definitions;
        newClickable.remainingUsages = usages == null ? -1 : usages.asInt();
        newClickable.until = until == null ? 0L : CoreUtilities.monotonicMillis() + until.getMillis();
        newClickable.context = scriptEntry.context;
        newClickable.npc = Utilities.getEntryNPC(scriptEntry);
        newClickable.defMap = defMap;
        if (forPlayers != null) {
            newClickable.forPlayers = new HashSet(forPlayers.size());
            for (PlayerTag player : forPlayers) {
                newClickable.forPlayers.add(player.getUUID());
            }
        }
        clickables.put(id, newClickable);
        scriptEntry.addObject("command", new ElementTag("/denizenclickable " + id));
        scriptEntry.addObject("id", new ElementTag(id.toString()));
    }

    public static class Clickable {
        public HashSet<UUID> forPlayers;
        public ListTag definitions;
        public MapTag defMap;
        public ScriptTag script;
        public String path;
        public NPCTag npc;
        public int remainingUsages;
        public TagContext context;
        public long until;
    }
}

