/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;

public abstract class BiomeNMS {
    public String name;
    public World world;

    public BiomeNMS(World world, String name) {
        this.world = world;
        this.name = CoreUtilities.toLowerCase(name);
    }

    public abstract DownfallType getDownfallType();

    public String getName() {
        return this.name;
    }

    public abstract float getHumidity();

    public abstract float getTemperature();

    public List<EntityType> getAllEntities() {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.addAll(this.getAmbientEntities());
        entityTypes.addAll(this.getCreatureEntities());
        entityTypes.addAll(this.getMonsterEntities());
        entityTypes.addAll(this.getWaterEntities());
        return entityTypes;
    }

    public abstract List<EntityType> getAmbientEntities();

    public abstract List<EntityType> getCreatureEntities();

    public abstract List<EntityType> getMonsterEntities();

    public abstract List<EntityType> getWaterEntities();

    public abstract void setHumidity(float var1);

    public abstract void setTemperature(float var1);

    public void setPrecipitation(DownfallType type) {
        throw new UnsupportedOperationException();
    }

    public abstract void setTo(Block var1);

    public static enum DownfallType {
        RAIN,
        SNOW,
        NONE;

    }
}

