/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.Bamboo;

public class MaterialLeafSize
implements Property {
    public static final String[] handledMechs = new String[]{"leaf_size"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof Bamboo;
    }

    public static MaterialLeafSize getFrom(ObjectTag _material) {
        if (!MaterialLeafSize.describes(_material)) {
            return null;
        }
        return new MaterialLeafSize((MaterialTag)_material);
    }

    private MaterialLeafSize(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "leaf_size", (attribute, material) -> new ElementTag(material.getBamboo().getLeaves().name()), new String[0]);
    }

    public Bamboo getBamboo() {
        return (Bamboo)this.material.getModernData();
    }

    public void setLeafSize(String size) {
        this.getBamboo().setLeaves(Bamboo.Leaves.valueOf((String)size));
    }

    @Override
    public String getPropertyString() {
        return this.getBamboo().getLeaves().name();
    }

    @Override
    public String getPropertyId() {
        return "leaf_size";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("leaf_size") && mechanism.requireEnum(Bamboo.Leaves.class)) {
            this.setLeafSize(mechanism.getValue().asString().toUpperCase());
        }
    }
}

