/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.Inventory;

public class PlayersPrepareSmithingTableScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayersPrepareSmithingTableScriptEvent instance;
    public PrepareSmithingEvent event;
    public ItemTag result;
    public PlayerTag player;

    public PlayersPrepareSmithingTableScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player prepares smithing")) {
            return false;
        }
        return PlayersPrepareSmithingTableScriptEvent.couldMatchItem(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.result.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerPreparesSmithingTable";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.result = determinationObj.asType(ItemTag.class, (TagContext)this.getTagContext(path));
            this.event.setResult(this.result.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("inventory")) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(PrepareSmithingEvent event) {
        if (event.getInventory().getViewers().isEmpty()) {
            return;
        }
        HumanEntity humanEntity = (HumanEntity)event.getInventory().getViewers().get(0);
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        this.event = event;
        this.result = new ItemTag(event.getResult());
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.cancelled = false;
        this.fire((Event)event);
    }
}

