/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerJumpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerJumpScriptEvent instance;
    public LocationTag location;
    public PlayerTag player;

    public PlayerJumpScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player jumps");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    public static class PlayerJumpsSpigotScriptEventImpl
    extends PlayerJumpScriptEvent {
        @EventHandler
        public void onPlayerJumps(PlayerMoveEvent event) {
            if (EntityTag.isNPC((Entity)event.getPlayer())) {
                return;
            }
            if (event.getTo().getBlockY() > event.getFrom().getBlockY() && Math.abs(event.getPlayer().getVelocity().getY()) > 0.1 && event.getPlayer().getVehicle() == null) {
                this.location = new LocationTag(event.getFrom());
                this.player = new PlayerTag(event.getPlayer());
                this.fire((Event)event);
            }
        }
    }
}

