/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;

public class ServerGeneratesExceptionScriptEvent
extends ScriptEvent {
    public static ServerGeneratesExceptionScriptEvent instance;
    public Throwable exception;
    public ScriptQueue queue;
    public String fullTrace;
    public static boolean cancelledTracker;

    public ServerGeneratesExceptionScriptEvent() {
        instance = this;
        this.registerCouldMatcher("server generates exception");
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        if (this.queue != null && this.queue.getLastEntryExecuted() != null) {
            return this.queue.getLastEntryExecuted().entryData;
        }
        return super.getScriptEntryData();
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "message": {
                return new ElementTag(this.exception.getMessage());
            }
            case "full_trace": {
                return new ElementTag(this.fullTrace);
            }
            case "type": {
                return new ElementTag(this.exception.getClass().getSimpleName());
            }
            case "queue": {
                if (this.queue == null) break;
                return new QueueTag(this.queue);
            }
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        cancelledTracker = this.cancelled;
        super.cancellationChanged();
    }

    public boolean handle(Throwable ex, String trace, ScriptQueue queue) {
        this.queue = queue;
        this.fullTrace = trace;
        this.exception = ex;
        cancelledTracker = false;
        this.fire();
        return cancelledTracker;
    }

    static {
        cancelledTracker = false;
    }
}

