/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class YamlCommand
extends AbstractCommand
implements Holdable {
    public Map<String, YamlConfiguration> yamlDocuments = new HashMap<String, YamlConfiguration>();

    public YamlCommand() {
        this.setName("yaml");
        this.setSyntax("yaml [create]/[load:<file>]/[loadtext:<text> raw_format]/[unload]/[savefile:<file>]/[copykey:<source_key> <target_key> (to_id:<name>)]/[set <key>([<#>])(:<action>):<value> (data_type:{string}/integer/double/boolean/auto)] [id:<name>]");
        this.setRequiredArguments(2, 5);
        TagManager.registerTagHandler(ObjectTag.class, "yaml", this::yamlTagProcess);
        this.isProcedural = false;
        this.allowedDynamicPrefixes = true;
    }

    private YamlConfiguration getYaml(String id) {
        if (id == null) {
            Debug.echoError("Trying to get YAML file with NULL ID!");
            return null;
        }
        return this.yamlDocuments.get(CoreUtilities.toLowerCase(id));
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("id:", this.yamlDocuments.keySet());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean isSet = false;
        boolean isCopyKey = false;
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("load")) {
                scriptEntry.addObject("action", new ElementTag("LOAD"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("loadtext")) {
                scriptEntry.addObject("action", new ElementTag("LOADTEXT"));
                scriptEntry.addObject("raw_text", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("savefile", "filesave")) {
                scriptEntry.addObject("action", new ElementTag("SAVE"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("create")) {
                scriptEntry.addObject("action", new ElementTag("CREATE"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("set")) {
                scriptEntry.addObject("action", new ElementTag("SET"));
                isSet = true;
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("copykey")) {
                scriptEntry.addObject("action", new ElementTag("COPYKEY"));
                scriptEntry.addObject("key", arg.asElement());
                isCopyKey = true;
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("unload")) {
                scriptEntry.addObject("action", new ElementTag("UNLOAD"));
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("to_id") && arg.matchesPrefix("to_id")) {
                scriptEntry.addObject("to_id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("split") && arg.matches("split_list")) {
                scriptEntry.addObject("split", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("fix_formatting") && arg.matches("fix_formatting")) {
                Deprecations.yamlFixFormatting.warn(scriptEntry);
                continue;
            }
            if (!scriptEntry.hasObject("raw_format") && arg.matches("raw_format")) {
                scriptEntry.addObject("raw_format", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("data_type") && arg.matchesPrefix("data_type") && arg.matchesEnum(DataType.class)) {
                scriptEntry.addObject("data_type", arg.asElement());
                continue;
            }
            if (isSet && !scriptEntry.hasObject("data_action")) {
                scriptEntry.addObject("yaml_action", (Object)YAML_Action.SET_VALUE);
                scriptEntry.addObject("data_action", DataActionHelper.parse((ActionableDataProvider)new YamlActionProvider(), arg, scriptEntry.context));
                continue;
            }
            if (isCopyKey && !scriptEntry.hasObject("value")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an id!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        scriptEntry.defaultObject("value", new ElementTag(""));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag filename = scriptEntry.getElement("filename");
        ElementTag rawText = scriptEntry.getElement("raw_text");
        ElementTag key = scriptEntry.getElement("key");
        ObjectTag value = (ObjectTag)scriptEntry.getObjectTag("value");
        ElementTag split = scriptEntry.getElement("split");
        YAML_Action yaml_action = (YAML_Action)((Object)scriptEntry.getObject("yaml_action"));
        ElementTag actionElement = scriptEntry.getElement("action");
        ElementTag idElement = scriptEntry.getElement("id");
        ElementTag toId = scriptEntry.getElement("to_id");
        ElementTag dataType = scriptEntry.getElement("data_type");
        ElementTag rawFormat = scriptEntry.getElement("raw_format");
        DataAction dataAction = (DataAction)scriptEntry.getObject("data_action");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), idElement, actionElement, filename, key, value, split, rawText, toId, dataType, rawFormat, yaml_action != null ? YamlCommand.db("yaml_action", yaml_action.name()) : null, dataAction);
        }
        Action action = actionElement.asEnum(Action.class);
        String id = idElement.asLowerString();
        if (action != Action.LOAD && action != Action.SAVE && scriptEntry.shouldWaitFor()) {
            scriptEntry.setFinished(true);
        }
        switch (action) {
            case LOAD: {
                File file = new File(DenizenCore.implementation.getDataFolder(), filename.asString());
                if (!DenizenCore.implementation.canReadFile(file)) {
                    Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (!file.exists()) {
                    Debug.echoError("File cannot be found!");
                    scriptEntry.setFinished(true);
                    return;
                }
                YamlConfiguration[] runnableConfigs = new YamlConfiguration[1];
                Runnable onLoadCompleted = () -> {
                    this.yamlDocuments.remove(id);
                    this.yamlDocuments.put(id, runnableConfigs[0]);
                    scriptEntry.setFinished(true);
                };
                Runnable loadRunnable = () -> {
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        String str = ScriptHelper.convertStreamToString(fis);
                        fis.close();
                        runnableConfigs[0] = YamlConfiguration.load(str, rawFormat == null || !rawFormat.asBoolean());
                        if (runnableConfigs[0] == null) {
                            runnableConfigs[0] = new YamlConfiguration();
                        }
                        if (scriptEntry.shouldWaitFor()) {
                            DenizenCore.schedule(new OneTimeSchedulable(onLoadCompleted, 0.0f));
                        } else {
                            onLoadCompleted.run();
                        }
                    }
                    catch (Exception e) {
                        Debug.echoError("Failed to load yaml file: " + e);
                    }
                };
                if (scriptEntry.shouldWaitFor()) {
                    DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(loadRunnable, 0.0f)));
                    break;
                }
                loadRunnable.run();
                break;
            }
            case LOADTEXT: {
                String str = rawText.asString();
                YamlConfiguration config = YamlConfiguration.load(str);
                this.yamlDocuments.remove(id);
                this.yamlDocuments.put(id, config);
                scriptEntry.setFinished(true);
                break;
            }
            case UNLOAD: {
                if (this.yamlDocuments.containsKey(id)) {
                    this.yamlDocuments.remove(id);
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case SAVE: {
                if (this.yamlDocuments.containsKey(id)) {
                    try {
                        File fileObj;
                        if (!CoreConfiguration.allowStrangeFileSaves) {
                            fileObj = new File(DenizenCore.implementation.getDataFolder().getAbsolutePath() + "/" + filename.asString());
                            String directory = URLDecoder.decode(System.getProperty("user.dir"));
                            if (!fileObj.getCanonicalPath().startsWith(directory)) {
                                Debug.echoError("Outside-the-main-folder YAML saves disabled by administrator.");
                                scriptEntry.setFinished(true);
                                return;
                            }
                        }
                        if (!DenizenCore.implementation.canWriteToFile(fileObj = new File(DenizenCore.implementation.getDataFolder().getAbsolutePath() + "/" + filename.asString()))) {
                            Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        fileObj.getParentFile().mkdirs();
                        YamlConfiguration yaml = this.yamlDocuments.get(id);
                        String outp = yaml.saveToString(false);
                        yaml.setDirty(false);
                        Runnable saveRunnable = () -> {
                            try {
                                Charset charset = CoreConfiguration.scriptEncoding == null ? null : CoreConfiguration.scriptEncoding.charset();
                                FileOutputStream fiout = new FileOutputStream(fileObj);
                                OutputStreamWriter writer = charset == null ? new OutputStreamWriter(fiout) : new OutputStreamWriter((OutputStream)fiout, charset);
                                writer.write(outp);
                                writer.close();
                            }
                            catch (IOException e) {
                                Debug.echoError(e);
                            }
                            scriptEntry.setFinished(true);
                        };
                        if (scriptEntry.shouldWaitFor()) {
                            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(saveRunnable, 0.0f)));
                            break;
                        }
                        saveRunnable.run();
                    }
                    catch (IOException e) {
                        Debug.echoError(e);
                    }
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                scriptEntry.setFinished(true);
                break;
            }
            case COPYKEY: {
                YamlConfiguration yaml;
                if (!this.yamlDocuments.containsKey(id)) break;
                YamlConfiguration destYaml = yaml = this.yamlDocuments.get(id);
                if (toId != null && (destYaml = this.getYaml(toId.toString())) == null) {
                    Debug.echoError("Unknown YAML TO-ID '" + id + "'");
                    break;
                }
                YamlConfiguration sourceSection = yaml.getConfigurationSection(key.asString());
                if (sourceSection == null) {
                    Debug.echoError("Invalid YAML section key name '" + key.asString() + "'.");
                    break;
                }
                YamlConfiguration newSection = this.copySection(sourceSection);
                destYaml.set(value.toString(), newSection);
                break;
            }
            case SET: {
                if (this.yamlDocuments.containsKey(id)) {
                    if (dataAction == null) {
                        Debug.echoError("Must specify a data action to associate with SET action.");
                        return;
                    }
                    YamlConfiguration yaml = this.yamlDocuments.get(id);
                    int index = dataAction.index - 1;
                    String keyStr = dataAction.key;
                    value = dataAction.inputValue;
                    String valueStr = value == null ? null : value.toString();
                    switch (dataAction.type) {
                        case INCREMENT: {
                            String originalVal = this.Get(yaml, index, keyStr, "0");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) + 1.0), dataType);
                            break;
                        }
                        case DECREMENT: {
                            String originalVal = this.Get(yaml, index, keyStr, "0");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) - 1.0), dataType);
                            break;
                        }
                        case ADD: {
                            String originalVal = this.Get(yaml, index, keyStr, "0");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) + Double.parseDouble(valueStr)), dataType);
                            break;
                        }
                        case SUBTRACT: {
                            String originalVal = this.Get(yaml, index, keyStr, "0");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) - Double.parseDouble(valueStr)), dataType);
                            break;
                        }
                        case MULTIPLY: {
                            String originalVal = this.Get(yaml, index, keyStr, "1");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) * Double.parseDouble(valueStr)), dataType);
                            break;
                        }
                        case DIVIDE: {
                            String originalVal = this.Get(yaml, index, keyStr, "1");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) / Double.parseDouble(valueStr)), dataType);
                            break;
                        }
                        case CLEAR: {
                            yaml.set(keyStr, null);
                            break;
                        }
                        case AUTO_SET: {
                            this.Set(yaml, index, keyStr, new ElementTag(true), dataType);
                            break;
                        }
                        case SET: {
                            this.Set(yaml, index, keyStr, value, dataType);
                            break;
                        }
                        case INSERT: {
                            List<Object> list = yaml.getList(keyStr);
                            if (list == null) {
                                list = new ArrayList<Object>();
                            }
                            list.add(this.autoConvertObject(value));
                            yaml.set(keyStr, list);
                            break;
                        }
                        case REMOVE: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                if (!CoreConfiguration.debugVerbose) break;
                                Debug.echoDebug((Debuggable)scriptEntry, "List null!");
                                break;
                            }
                            if (index > -1 && index < list.size()) {
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoDebug((Debuggable)scriptEntry, "Remove ind: " + index);
                                }
                                list.remove(index);
                                yaml.set(keyStr, list);
                                break;
                            }
                            if (CoreConfiguration.debugVerbose) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Remove value: " + valueStr);
                            }
                            for (int i = 0; i < list.size(); ++i) {
                                if (!list.get(i).equalsIgnoreCase(valueStr)) continue;
                                list.remove(i);
                                break;
                            }
                            yaml.set(keyStr, list);
                            break;
                        }
                        case SPLIT_NEW: {
                            this.Set(yaml, index, keyStr, value.asType(ListTag.class, scriptEntry.getContext()), dataType);
                            break;
                        }
                        case SPLIT: {
                            List<Object> list = yaml.getList(keyStr);
                            if (list == null) {
                                list = new ArrayList<Object>();
                            }
                            for (ObjectTag obj : value.asType(ListTag.class, (TagContext)scriptEntry.getContext()).objectForms) {
                                list.add(this.autoConvertObject(obj));
                            }
                            yaml.set(keyStr, list);
                            break;
                        }
                    }
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case CREATE: {
                this.yamlDocuments.remove(id);
                YamlConfiguration yamlConfiguration = new YamlConfiguration();
                this.yamlDocuments.put(id, yamlConfiguration);
            }
        }
    }

    public Object deepCopyObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof YamlConfiguration) {
            return this.copySection((YamlConfiguration)obj);
        }
        if (obj instanceof List) {
            ArrayList<Object> outList = new ArrayList<Object>(((List)obj).size());
            for (Object subValue : (List)obj) {
                outList.add(this.deepCopyObject(subValue));
            }
            return outList;
        }
        if (obj instanceof Map) {
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                newMap.put(this.deepCopyObject(entry.getKey()), this.deepCopyObject(entry.getValue()));
            }
            return newMap;
        }
        return obj;
    }

    public YamlConfiguration copySection(YamlConfiguration section) {
        YamlConfiguration newSection = new YamlConfiguration();
        for (StringHolder key : section.getKeys(false)) {
            Object obj = section.get(key.str);
            newSection.set(key.str, this.deepCopyObject(obj));
        }
        return newSection;
    }

    public String Get(YamlConfiguration yaml, int index, String key, String def) {
        if (index == -1) {
            return yaml.getString(key, def);
        }
        List<String> list = yaml.getStringList(key);
        if (index < 0) {
            index = 0;
        }
        if (index > list.size()) {
            index = list.size() - 1;
        }
        if (list.isEmpty()) {
            return "";
        }
        return list.get(index);
    }

    public Object autoConvertObject(Object value) {
        if (value instanceof ElementTag || value instanceof String) {
            String val = value.toString();
            if (val.startsWith("map@")) {
                MapTag map = MapTag.valueOf(val, CoreUtilities.noDebugContext);
                if (map != null) {
                    value = map;
                }
            } else if (val.startsWith("li@")) {
                value = ListTag.valueOf(val, CoreUtilities.noDebugContext);
            }
        }
        if (value instanceof ListTag || value instanceof MapTag) {
            return CoreUtilities.objectTagToJavaForm((ObjectTag)value, true, false);
        }
        return value.toString();
    }

    public void Set(YamlConfiguration yaml, int index, String key, Object value, ElementTag dataType) {
        value = this.autoConvertObject(value);
        if (dataType != null && value instanceof String) {
            String rawValue = value.toString();
            switch (dataType.asEnum(DataType.class)) {
                case DOUBLE: {
                    value = Double.parseDouble(rawValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(rawValue);
                    break;
                }
                case BOOLEAN: {
                    value = CoreUtilities.equalsIgnoreCase(rawValue, "true");
                    break;
                }
                case AUTO: {
                    if (CoreUtilities.equalsIgnoreCase(rawValue, "true")) {
                        value = true;
                        break;
                    }
                    if (CoreUtilities.equalsIgnoreCase(rawValue, "false")) {
                        value = false;
                        break;
                    }
                    if (!ArgumentHelper.matchesDouble(rawValue)) break;
                    value = ArgumentHelper.matchesInteger(rawValue) ? (Number)Long.parseLong(rawValue) : (Number)Double.parseDouble(rawValue);
                }
            }
        }
        if (index == -1) {
            yaml.set(key, value);
        } else {
            List<Object> list = yaml.getList(key);
            if (list == null) {
                list = new ArrayList<Object>();
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
            yaml.set(key, list);
        }
    }

    public ObjectTag yamlTagProcess(Attribute attribute) {
        String id = attribute.hasParam() ? CoreUtilities.toLowerCase(attribute.getParam()) : null;
        attribute.fulfill(1);
        if (attribute.startsWith("list")) {
            ListTag list = new ListTag();
            list.addAll((Collection<? extends String>)this.yamlDocuments.keySet());
            return list;
        }
        if (id == null) {
            attribute.echoError("yaml[...] tag must specify a YAML id.");
            return null;
        }
        YamlConfiguration yaml = this.getYaml(id);
        if (yaml == null) {
            attribute.echoError("YAML tag has specified an invalid ID, or the specified id has already been closed. Tag replacement aborted. ID given: '" + id + "'.");
            return null;
        }
        if (attribute.startsWith("contains") && attribute.hasParam()) {
            return new ElementTag(yaml.contains(attribute.getParam()));
        }
        if (attribute.startsWith("is_list") && attribute.hasParam()) {
            return new ElementTag(yaml.isList(attribute.getParam()));
        }
        if (attribute.startsWith("parsed_key") && attribute.hasParam()) {
            Object obj = yaml.get(attribute.getParam());
            if (obj == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(obj, attribute.context, false, true);
        }
        if (attribute.startsWith("read") && attribute.hasParam()) {
            Object obj = yaml.get(attribute.getParam());
            if (obj == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(obj, attribute.context);
        }
        if (attribute.startsWith("list_deep_keys") && attribute.hasParam()) {
            Set<StringHolder> keys;
            String path = attribute.getParam();
            if (path != null && path.length() > 0) {
                YamlConfiguration section = yaml.getConfigurationSection(path);
                if (section == null) {
                    return null;
                }
                keys = section.getKeys(true);
            } else {
                keys = yaml.getKeys(true);
            }
            if (keys == null) {
                return null;
            }
            return new ListTag(keys);
        }
        if (attribute.startsWith("list_keys") && attribute.hasParam()) {
            Set<StringHolder> keys;
            String path = attribute.getParam();
            if (path != null && path.length() > 0) {
                YamlConfiguration section = yaml.getConfigurationSection(path);
                if (section == null) {
                    return null;
                }
                keys = section.getKeys(false);
            } else {
                keys = yaml.getKeys(false);
            }
            if (keys == null) {
                return null;
            }
            return new ListTag(keys);
        }
        if (attribute.startsWith("has_changes")) {
            return new ElementTag(yaml.isDirty());
        }
        if (attribute.startsWith("to_json")) {
            return new ElementTag(new JSONObject(yaml.getMap()).toString());
        }
        if (attribute.startsWith("to_text")) {
            return new ElementTag(yaml.saveToString(false));
        }
        return null;
    }

    public static enum DataType {
        STRING,
        INTEGER,
        DOUBLE,
        BOOLEAN,
        AUTO;

    }

    public static enum YAML_Action {
        SET_VALUE,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        DELETE,
        SPLIT_NEW;

    }

    public static class YamlActionProvider
    extends ActionableDataProvider {
        @Override
        public ObjectTag getValueAt(String keyName) {
            throw new RuntimeException("Yaml Action Provider mis-called");
        }

        @Override
        public void setValueAt(String keyName, ObjectTag value) {
            throw new RuntimeException("Yaml Action Provider mis-called");
        }
    }

    public static enum Action {
        LOAD,
        LOADTEXT,
        UNLOAD,
        CREATE,
        SAVE,
        SET,
        COPYKEY;

    }
}

