/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RunLaterCommand
extends AbstractCommand {
    public static List<FutureRunData> nextMinuteFutureRuns = new ArrayList<FutureRunData>();
    public static List<FutureRunData> nextHourFutureRuns = new ArrayList<FutureRunData>();
    public static List<FutureRunData> farFutureRuns = new ArrayList<FutureRunData>();
    public static HashMap<String, FutureRunData> trackedById = new HashMap();
    public static long timeMinuteReorg = 0L;
    public static long timeHourReorg = 0L;
    public static long timeLastSave = 0L;
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static String persistFilePath;
    public static boolean isSaving;
    public static boolean hasChanged;

    public RunLaterCommand() {
        this.setName("runlater");
        this.setSyntax("runlater [<script>] (path:<name>) [delay:<duration>] (id:<id>) (def:<element>|.../defmap:<map>/def.<name>:<value>)");
        this.setRequiredArguments(2, -1);
        this.setPrefixesHandled("id");
        this.allowedDynamicPrefixes = true;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addScriptsOfType(TaskScriptContainer.class);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        MapTag defMap = new MapTag();
        for (Argument arg : scriptEntry) {
            if (arg.matchesPrefix("def")) {
                scriptEntry.addObject("definitions", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesPrefix("defmap") && arg.matchesArgumentType(MapTag.class)) {
                defMap.map.putAll(arg.asType(MapTag.class).map);
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.hasPrefix() && arg.getPrefix().getRawValue().startsWith("def.")) {
                defMap.putObject(arg.getPrefix().getRawValue().substring("def.".length()), arg.object);
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && arg.limitToOnlyPrefix("script")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("path") && arg.matchesPrefix("path", "p")) {
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("path") && !arg.hasPrefix() && arg.asElement().asString().contains(".")) {
                int dotIndex;
                String path = arg.asElement().asString();
                ScriptTag script = ScriptTag.valueOf(path.substring(0, dotIndex = path.indexOf(46)), CoreUtilities.noDebugContext);
                if (script == null) {
                    arg.reportUnhandled();
                    continue;
                }
                scriptEntry.addObject("script", script);
                scriptEntry.addObject("path", new ElementTag(path.substring(dotIndex + 1)));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!scriptEntry.hasObject("delay")) {
            throw new InvalidArgumentsException("Must specify a DELAY.");
        }
        if (!defMap.map.isEmpty()) {
            scriptEntry.addObject("def_map", defMap);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String path;
        ElementTag pathElement = scriptEntry.getElement("path");
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        DurationTag delay = (DurationTag)scriptEntry.getObjectTag("delay");
        MapTag defMap = (MapTag)scriptEntry.getObjectTag("def_map");
        ElementTag id = scriptEntry.argForPrefixAsElement("id", null);
        String string = path = pathElement != null ? pathElement.asString() : null;
        if (script == null) {
            Debug.echoError(scriptEntry, "Script RunLater failed (invalid script name)!");
            return;
        }
        if (path != null && !script.getContainer().containsScriptSection(path)) {
            Debug.echoError(scriptEntry, "Script RunLater failed (invalid path)!");
            return;
        }
        ListTag definitions = (ListTag)scriptEntry.getObjectTag("definitions");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), script, pathElement, delay, id, defMap, definitions);
        }
        FutureRunData runData = new FutureRunData();
        runData.definitionList = definitions;
        runData.defMap = defMap;
        runData.scriptName = script.getName();
        runData.path = path;
        runData.entryData = scriptEntry.entryData.clone();
        runData.executeAt = System.currentTimeMillis() + delay.getMillis();
        String string2 = runData.id = id == null ? null : id.asLowerString();
        if (id != null && trackedById.containsKey(runData.id)) {
            Debug.echoError("Cannot add new RunLater with the given id '" + runData.id + "': there is already a scheduled task with that ID.");
            return;
        }
        RunLaterCommand.addNewRunnable(runData);
    }

    public static void addNewRunnable(FutureRunData runData) {
        hasChanged = true;
        long timeNow = System.currentTimeMillis();
        if (runData.executeAt < timeNow + 120000L) {
            nextMinuteFutureRuns.add(runData);
        } else if (runData.executeAt < timeNow + 0x6DDD00L) {
            nextHourFutureRuns.add(runData);
        } else {
            farFutureRuns.add(runData);
        }
        if (runData.id != null) {
            trackedById.put(runData.id, runData);
        }
    }

    public static boolean hasAny() {
        return !nextMinuteFutureRuns.isEmpty() || !nextHourFutureRuns.isEmpty() || !farFutureRuns.isEmpty();
    }

    public static void init(String path) {
        nextMinuteFutureRuns.clear();
        nextHourFutureRuns.clear();
        farFutureRuns.clear();
        trackedById.clear();
        persistFilePath = path;
        String stored = CoreUtilities.journallingLoadFile(path);
        if (stored != null) {
            RunLaterCommand.load(YamlConfiguration.load(stored));
        }
        timeLastSave = System.currentTimeMillis();
    }

    public static void saveToFile(boolean async) {
        if (!hasChanged) {
            return;
        }
        hasChanged = false;
        YamlConfiguration toSave = RunLaterCommand.saveAll();
        isSaving = true;
        Runnable doSave = () -> {
            try {
                if (toSave == null) {
                    File fileObj = new File(persistFilePath);
                    if (fileObj.exists()) {
                        fileObj.delete();
                    }
                    if ((fileObj = new File(persistFilePath + "~2")).exists()) {
                        fileObj.delete();
                    }
                    return;
                }
                CoreUtilities.journallingFileSave(persistFilePath, toSave.saveToString(false));
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            finally {
                isSaving = false;
            }
        };
        if (async) {
            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(doSave, 0.0f)));
        } else {
            doSave.run();
        }
    }

    public static void tickFutureRuns() {
        FutureRunData data;
        int i;
        if (!RunLaterCommand.hasAny()) {
            if (hasChanged) {
                RunLaterCommand.saveToFile(true);
            }
            return;
        }
        long timeNow = System.currentTimeMillis();
        for (i = 0; i < nextMinuteFutureRuns.size(); ++i) {
            data = nextMinuteFutureRuns.get(i);
            if (data.executeAt >= timeNow) continue;
            nextMinuteFutureRuns.remove(i--);
            hasChanged = true;
            data.run();
        }
        if (timeNow > timeMinuteReorg + 60000L) {
            timeMinuteReorg = timeNow;
            if (timeNow > timeHourReorg + 3600000L) {
                timeHourReorg = timeNow;
                for (i = 0; i < farFutureRuns.size(); ++i) {
                    data = farFutureRuns.get(i);
                    if (data.executeAt >= timeNow + 0x6DDD00L) continue;
                    nextHourFutureRuns.add(data);
                    farFutureRuns.remove(i--);
                }
            }
            for (i = 0; i < nextHourFutureRuns.size(); ++i) {
                data = nextHourFutureRuns.get(i);
                if (data.executeAt >= timeNow + 120000L) continue;
                nextMinuteFutureRuns.add(data);
                nextHourFutureRuns.remove(i--);
            }
            if (timeNow > timeLastSave + 1800000L) {
                timeLastSave = timeNow;
                RunLaterCommand.saveToFile(true);
            }
        }
    }

    public static YamlConfiguration saveAll() {
        if (!RunLaterCommand.hasAny()) {
            return null;
        }
        YamlConfiguration out = new YamlConfiguration();
        int id = 0;
        for (FutureRunData runData : nextMinuteFutureRuns) {
            if (runData.cancelled) continue;
            out.set("minute_" + id++, runData.save());
        }
        for (FutureRunData runData : nextHourFutureRuns) {
            if (runData.cancelled) continue;
            out.set("hour_" + id++, runData.save());
        }
        for (FutureRunData runData : farFutureRuns) {
            if (runData.cancelled) continue;
            out.set("future_" + id++, runData.save());
        }
        return out;
    }

    public static void load(YamlConfiguration config) {
        if (config == null) {
            Debug.echoError("RunLater load failed due to an invalid YAML file!");
            return;
        }
        for (StringHolder key : config.getKeys(false)) {
            YamlConfiguration subConfig = config.getConfigurationSection(key.str);
            FutureRunData runData = new FutureRunData();
            runData.savedData = subConfig;
            runData.executeAt = Long.parseLong(subConfig.getString("execute_at"));
            runData.id = subConfig.getString("id");
            RunLaterCommand.addNewRunnable(runData);
        }
    }

    static {
        isSaving = false;
        hasChanged = false;
    }

    public static class FutureRunData {
        public ScriptEntryData entryData;
        public String scriptName;
        public String path;
        public ListTag definitionList;
        public MapTag defMap;
        public long executeAt;
        public YamlConfiguration savedData;
        public String id;
        public boolean cancelled = false;

        public void load(YamlConfiguration config) {
            this.scriptName = config.getString("script_name");
            this.path = config.getString("path", null);
            this.definitionList = config.contains("definition_list") ? ListTag.valueOf(config.getString("definition_list"), CoreUtilities.errorButNoDebugContext) : null;
            this.defMap = config.contains("definitions") ? MapTag.valueOf(config.getString("definitions"), CoreUtilities.errorButNoDebugContext) : null;
            this.entryData = DenizenCore.implementation.getEmptyScriptEntryData().clone();
            this.entryData.load(config.getConfigurationSection("entry_data"));
        }

        public YamlConfiguration save() {
            if (this.savedData != null) {
                return this.savedData;
            }
            YamlConfiguration out = new YamlConfiguration();
            out.set("execute_at", String.valueOf(this.executeAt));
            out.set("script_name", this.scriptName);
            if (this.path != null) {
                out.set("path", this.path);
            }
            if (this.definitionList != null) {
                out.set("definition_list", this.definitionList.savable());
            }
            if (this.defMap != null) {
                out.set("definitions", this.defMap.savable());
            }
            out.set("entry_data", this.entryData.save());
            if (this.id != null) {
                out.set("id", this.id);
            }
            return out;
        }

        public void run() {
            try {
                ScriptTag script;
                if (this.cancelled) {
                    return;
                }
                if (this.savedData != null) {
                    this.load(this.savedData);
                    this.savedData = null;
                }
                if (this.id != null) {
                    trackedById.remove(this.id);
                }
                if ((script = ScriptTag.valueOf(this.scriptName, this.entryData.getTagContext())) == null) {
                    Debug.echoError("Script RunLater failed (invalid script name)!");
                    return;
                }
                if (this.path != null && !script.getContainer().containsScriptSection(this.path)) {
                    Debug.echoError("Script RunLater failed (invalid path)!");
                    return;
                }
                Consumer<ScriptQueue> configure = queue -> {
                    if (this.defMap != null) {
                        for (Map.Entry<StringHolder, ObjectTag> val : this.defMap.map.entrySet()) {
                            queue.addDefinition(val.getKey().str, val.getValue());
                        }
                    }
                };
                ScriptQueue result = ScriptUtilities.createAndStartQueue(script.getContainer(), this.path, this.entryData, null, configure, null, null, this.definitionList, script.getContainer());
                if (result == null) {
                    Debug.echoError("RunLater: script run failed!");
                    return;
                }
            }
            catch (Throwable ex) {
                Debug.echoError("Error in RunLater...");
                Debug.echoError(ex);
            }
        }
    }
}

