/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import com.denizenscript.denizencore.events.core.ScriptGeneratesErrorScriptEvent;
import com.denizenscript.denizencore.events.core.ServerGeneratesExceptionScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.CommandExecutor;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DebugInternals {
    public static boolean errorDuplicatePrevention = false;
    public static String lastErrorHeader = "";
    public static String ENABLE_DEBUG_MESSAGE = "<LG> ... <LR>Enable debug on the script for more information.";
    public static String ERROR_HEADER_START = "<LR> ERROR";
    public static String ERROR_HEADER_END = "!\n<LG><FORCE_ALIGN>Error Message: <W>";
    public static String ADDITIONAL_ERROR_HEADER = "<LG>Additional Error Info: <W>";
    public static long depthCorrectError = 0L;
    public static boolean throwErrorEvent = true;
    public static int outputThisTick = 0;
    public static boolean skipFooter = false;
    public static SimpleDateFormat debugRecordDateFormat = new SimpleDateFormat("HH:mm:ss");
    public static final Map<Class<?>, String> classNameCache = new WeakHashMap();
    public static boolean canGetClass = true;

    public static void onTick() {
        outputThisTick = 0;
        errorDuplicatePrevention = false;
        lastErrorHeader = "";
        Debug.errorContextStack.clear();
    }

    public static String trimMessage(String message) {
        if (!CoreConfiguration.debugShouldTrim) {
            return message;
        }
        int trimSize = CoreConfiguration.debugTrimLength;
        if (message.length() > trimSize) {
            message = message.substring(0, trimSize / 2 - 10) + "... *snip!*..." + message.substring(message.length() - (trimSize / 2 - 10));
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    public static void echoErrorInternal(ScriptEntry source, String addedContext, String message, boolean reformat) {
        boolean bl;
        message = DenizenCore.implementation.applyDebugColors(message);
        if (errorDuplicatePrevention) {
            if (!CoreConfiguration.debugVerbose) {
                DebugInternals.finalOutputDebugText("Error within error (??!!!! SOMETHING WENT SUPER WRONG!): " + message, source, reformat);
            }
            return;
        }
        errorDuplicatePrevention = true;
        ScriptQueue sourceQueue = CommandExecutor.currentQueue;
        if (source == null && sourceQueue != null) {
            source = sourceQueue.getLastEntryExecuted();
        }
        if (source != null && source.queue != null) {
            sourceQueue = source.queue;
        }
        ScriptTag sourceScript = null;
        if (source != null) {
            sourceScript = source.getScript();
        }
        if (throwErrorEvent) {
            throwErrorEvent = false;
            boolean cancel = ScriptGeneratesErrorScriptEvent.instance.handle(message, sourceQueue, sourceScript, source == null ? -1 : source.internal.lineNumber);
            throwErrorEvent = true;
            if (cancel) {
                errorDuplicatePrevention = false;
                return;
            }
        }
        if (!CoreConfiguration.shouldShowDebug) {
            errorDuplicatePrevention = false;
            return;
        }
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append(ERROR_HEADER_START);
        if (sourceScript != null) {
            headerBuilder.append(" in script '<A>").append(sourceScript.getName()).append("<LR>'");
        }
        if (sourceQueue != null) {
            headerBuilder.append(" in queue '").append(sourceQueue.debugId).append("<LR>'");
        }
        if (source != null) {
            headerBuilder.append(" while executing command '<A>").append(source.getCommandName()).append("<LR>'");
            if (sourceScript != null) {
                headerBuilder.append(" in file '<A>").append(sourceScript.getContainer().getRelativeFileName()).append("<LR>' on line '<A>").append(source.internal.lineNumber).append("<LR>'");
            }
            DenizenCore.implementation.addExtraErrorHeaders(headerBuilder, source);
        }
        HashSet<void> duplicatePrevention = new HashSet<void>();
        for (Object e : Debug.errorContextStack) {
            void var9_10;
            if (e instanceof ScriptTag) {
                ScriptContainer scriptContainer = ((ScriptTag)e).getContainer();
            } else if (e instanceof QueueTag) {
                ScriptQueue scriptQueue = ((QueueTag)e).getQueue();
            } else if (e instanceof Supplier) {
                Object t = ((Supplier)e).get();
            }
            if (!duplicatePrevention.add(var9_10)) continue;
            if (var9_10 instanceof ScriptContainer) {
                if (sourceScript != null && var9_10 == sourceScript.getContainer()) continue;
                headerBuilder.append(" in script '<A>").append(((ScriptContainer)var9_10).getName()).append("<LR>'");
                continue;
            }
            if (var9_10 instanceof ScriptQueue) {
                if (var9_10 == sourceQueue) continue;
                headerBuilder.append(" in queue '").append(((ScriptQueue)var9_10).debugId).append("<LR>'");
                continue;
            }
            if (var9_10 instanceof String) {
                headerBuilder.append(" ").append((String)var9_10);
                continue;
            }
            if (var9_10 instanceof ObjectTag) {
                headerBuilder.append(((ObjectTag)var9_10).getErrorHeaderContext());
                continue;
            }
            if (var9_10 == null) continue;
            headerBuilder.append("\n<FORCE_ALIGN>With non-context-valid object '<A>").append(var9_10).append("<LR>'");
        }
        if (addedContext != null) {
            headerBuilder.append("\n<FORCE_ALIGN>").append(addedContext);
        }
        headerBuilder.append(ERROR_HEADER_END);
        String header = headerBuilder.toString();
        boolean bl2 = sourceScript != null && !sourceScript.getContainer().shouldDebug();
        String headerRef = header;
        if (header.equals(lastErrorHeader)) {
            header = ADDITIONAL_ERROR_HEADER;
            bl = false;
        }
        DebugInternals.finalOutputDebugText(header + message + (bl ? ENABLE_DEBUG_MESSAGE : ""), sourceQueue, reformat);
        errorDuplicatePrevention = false;
        if (CoreConfiguration.debugVerbose && CoreConfiguration.debugUltraVerbose && depthCorrectError == 0L) {
            ++depthCorrectError;
            try {
                throw new RuntimeException("Verbose info for above error");
            }
            catch (Throwable e) {
                Debug.echoError(source, e);
                --depthCorrectError;
            }
        }
        lastErrorHeader = headerRef;
    }

    public static String getFullExceptionMessage(Throwable ex, boolean includeBounding) {
        StringBuilder errorMessage = new StringBuilder();
        if (includeBounding) {
            errorMessage.append("Internal exception was thrown!\n");
        }
        String prefix = includeBounding ? "<LG>[Error Continued] <W>" : "";
        boolean first = true;
        while (ex != null) {
            errorMessage.append(prefix);
            if (!first) {
                errorMessage.append("Caused by: ");
            }
            errorMessage.append(ex).append("\n");
            for (StackTraceElement ste : ex.getStackTrace()) {
                errorMessage.append(prefix).append("  ").append(ste.toString()).append("\n");
            }
            if (ex.getCause() == ex) break;
            ex = ex.getCause();
            first = false;
        }
        return errorMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void echoExceptionInternal(ScriptEntry source, Throwable ex) {
        boolean wasThrowAllowed = throwErrorEvent;
        throwErrorEvent = false;
        try {
            String errorMessage = DebugInternals.getFullExceptionMessage(ex, true);
            if (wasThrowAllowed) {
                boolean cancel;
                Throwable thrown = ex;
                while (thrown.getCause() != null) {
                    thrown = thrown.getCause();
                }
                ScriptQueue sourceQueue = CommandExecutor.currentQueue;
                if (source == null && sourceQueue != null) {
                    source = sourceQueue.getLastEntryExecuted();
                }
                if (source != null && source.queue != null) {
                    sourceQueue = source.queue;
                }
                ScriptTag sourceScript = null;
                if (source != null) {
                    sourceScript = source.getScript();
                }
                if (cancel = ServerGeneratesExceptionScriptEvent.instance.handle(thrown, errorMessage, sourceQueue, sourceScript, source == null ? -1 : source.internal.lineNumber)) {
                    return;
                }
            }
            if (!CoreConfiguration.shouldShowDebug) {
                return;
            }
            if (!CoreConfiguration.debugStackTraces) {
                Debug.echoError(source, "Exception! Enable '/denizen debug -s' for the nitty-gritty.");
            } else {
                ++depthCorrectError;
                DebugInternals.echoErrorInternal(source, null, errorMessage, false);
                --depthCorrectError;
            }
        }
        finally {
            throwErrorEvent = wasThrowAllowed;
        }
    }

    public static Consumer<String> getDebugSender(Debuggable caller) {
        if (caller == null) {
            caller = CommandExecutor.currentQueue;
        }
        if (caller instanceof TagContext && ((TagContext)caller).entry != null) {
            caller = ((TagContext)caller).entry;
        }
        if (caller instanceof ScriptEntry && ((ScriptEntry)caller).getResidingQueue() != null) {
            caller = ((ScriptEntry)caller).getResidingQueue();
        }
        if (caller instanceof ScriptQueue) {
            return ((ScriptQueue)caller).debugOutput;
        }
        return null;
    }

    public static void echo(String string, Debuggable caller) {
        ScriptEntry sent;
        if (!Debug.shouldDebug(caller)) {
            return;
        }
        if (!CoreConfiguration.debugShowSources || caller == null) {
            DebugInternals.finalOutputDebugText(string, caller, true);
            return;
        }
        String callerId = caller instanceof ScriptContainer ? "Script:" + ((ScriptContainer)caller).getName() : (caller instanceof ScriptEntry ? (((ScriptEntry)caller).getScript() != null ? "Command:" + ((ScriptEntry)caller).getCommandName() + " in Script:" + ((ScriptEntry)caller).getScript().getName() : "Command:" + ((ScriptEntry)caller).getCommandName()) : (caller instanceof ScriptQueue ? (((ScriptQueue)caller).script != null ? "Queue:" + ((ScriptQueue)caller).id + " running Script:" + ((ScriptQueue)caller).script.getName() : "Queue:" + ((ScriptQueue)caller).id) : (caller instanceof TagContext ? (((TagContext)caller).entry != null ? ((sent = ((TagContext)caller).entry).getScript() != null ? "Tag in Command:" + sent.getCommandName() + " in Script:" + sent.getScript().getName() : "Tag in Command:" + sent.getCommandName()) : (((TagContext)caller).script != null ? "Tag in Script:" + ((TagContext)caller).script.getName() : "Tag:" + caller)) : caller.toString())));
        DebugInternals.finalOutputDebugText("<G>[Src:<LG>" + callerId + "<G>] <W>" + string, caller, true);
    }

    public static void finalOutputDebugText(String message, Debuggable caller, boolean reformat) {
        lastErrorHeader = "";
        if (++outputThisTick >= CoreConfiguration.debugLimitPerTick) {
            if (outputThisTick == CoreConfiguration.debugLimitPerTick) {
                DebugInternals.internalFinalOutputPath("... Debug rate limit per-tick hit, edit config.yml to adjust this limit...", caller, true);
            }
            return;
        }
        if (message.equals("<LP>+---------------------+")) {
            if (skipFooter) {
                return;
            }
            skipFooter = true;
        } else {
            skipFooter = false;
        }
        message = DenizenCore.implementation.applyDebugColors(message);
        DebugInternals.internalFinalOutputPath(message, caller, reformat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void internalFinalOutputPath(String message, Debuggable caller, boolean reformat) {
        String formatted = message = message.replace('\u0000', ' ');
        if (reformat) {
            StringBuilder buffer = new StringBuilder();
            int length = 0;
            for (String word : CoreUtilities.split(formatted, ' ')) {
                int strippedLength = DenizenCore.implementation.stripColor(word).length() + 1;
                if (length + strippedLength < CoreConfiguration.debugLineLength) {
                    buffer.append(word).append(" ");
                    length += strippedLength;
                } else {
                    length = strippedLength;
                    buffer.append("\n<FORCE_ALIGN>").append(word).append(" ");
                }
                if (!word.contains("\n")) continue;
                length = 0;
            }
            formatted = buffer.toString();
        }
        if (CoreConfiguration.shouldRecordDebug) {
            try {
                String toRecord = " " + formatted.replace("<FORCE_ALIGN>", "        ") + "\n";
                Debug.debugRecording.append(URLEncoder.encode(debugRecordDateFormat.format(new Date()) + toRecord, "UTF-8"));
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        if (DenizenCore.logInterceptor.redirected && !DenizenCore.logInterceptor.antiLoop) {
            DenizenCore.logInterceptor.antiLoop = true;
            try {
                ConsoleOutputScriptEvent event = ConsoleOutputScriptEvent.instance;
                event.message = message;
                event = (ConsoleOutputScriptEvent)event.fire();
                if (event.cancelled) {
                    return;
                }
            }
            finally {
                DenizenCore.logInterceptor.antiLoop = false;
            }
        }
        DenizenCore.implementation.doFinalDebugOutput(formatted);
        Consumer<String> additional = DebugInternals.getDebugSender(caller);
        if (additional != null) {
            additional.accept(message);
        }
    }

    public static String getClassNameOpti(Class<?> clazz) {
        String className = classNameCache.get(clazz);
        if (className == null) {
            className = clazz.getSimpleName();
            classNameCache.put(clazz, className);
        }
        return className;
    }

    public static Class<?> getCallerClass() {
        if (!canGetClass) {
            return null;
        }
        try {
            if (canGetClass) {
                Class[] classes = new SecurityManagerTrick().getClassContext();
                for (int i = 2; i < classes.length; ++i) {
                    if (classes[i] == DebugInternals.class || classes[i] == Debug.class) continue;
                    return classes[i];
                }
            }
        }
        catch (Throwable ex) {
            canGetClass = false;
        }
        return null;
    }

    public static String getCaller() {
        Class<?> caller = DebugInternals.getCallerClass();
        if (caller == null) {
            return "<JVM-Block>";
        }
        String callerName = DebugInternals.getClassNameOpti(caller);
        return callerName.length() > 16 ? callerName.substring(0, 12) + "..." : callerName;
    }

    public static void logInternal(String caller, String message) {
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        DebugInternals.finalOutputDebugText("<Y>+> [" + caller + "] <W>" + DebugInternals.trimMessage(message), null, true);
    }

    public static class SecurityManagerTrick
    extends SecurityManager {
        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

