/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.MultiVersionHelper1_17;
import com.denizenscript.denizen.utilities.MultiVersionHelper1_19;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.DyeColor;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieVillager;

public class EntityColor
implements Property {
    public static final String[] handledMechs = new String[]{"color"};
    EntityTag colored;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        EntityType type = ((EntityTag)entity).getBukkitEntityType();
        return type == EntityType.SHEEP || type == EntityType.HORSE || type == EntityType.WOLF || type == EntityType.OCELOT || type == EntityType.RABBIT || type == EntityType.LLAMA || type == EntityType.PARROT || type == EntityType.SHULKER || type == EntityType.MUSHROOM_COW || type == EntityType.CAT || type == EntityType.FOX || type == EntityType.PANDA || type == EntityType.ARROW || type == EntityType.VILLAGER || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.TRADER_LLAMA || type == EntityType.TROPICAL_FISH || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && MultiVersionHelper1_17.colorIsApplicable(type) || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type);
    }

    public static EntityColor getFrom(ObjectTag entity) {
        if (!EntityColor.describes(entity)) {
            return null;
        }
        return new EntityColor((EntityTag)entity);
    }

    private EntityColor(EntityTag entity) {
        this.colored = entity;
    }

    public String getColor(boolean includeDeprecated) {
        EntityType type = this.colored.getBukkitEntityType();
        switch (type) {
            case HORSE: {
                Horse horse = (Horse)this.colored.getBukkitEntity();
                return horse.getColor().name() + "|" + horse.getStyle().name();
            }
            case SHEEP: {
                return ((Sheep)this.colored.getBukkitEntity()).getColor().name();
            }
            case WOLF: {
                return ((Wolf)this.colored.getBukkitEntity()).getCollarColor().name();
            }
            case OCELOT: {
                if (!includeDeprecated) break;
                return ((Ocelot)this.colored.getBukkitEntity()).getCatType().name();
            }
            case RABBIT: {
                return ((Rabbit)this.colored.getBukkitEntity()).getRabbitType().name();
            }
            case LLAMA: 
            case TRADER_LLAMA: {
                return ((Llama)this.colored.getBukkitEntity()).getColor().name();
            }
            case PARROT: {
                return ((Parrot)this.colored.getBukkitEntity()).getVariant().name();
            }
            case SHULKER: {
                DyeColor color = ((Shulker)this.colored.getBukkitEntity()).getColor();
                return color == null ? null : color.name();
            }
            case MUSHROOM_COW: {
                return ((MushroomCow)this.colored.getBukkitEntity()).getVariant().name();
            }
            case TROPICAL_FISH: {
                TropicalFish fish = (TropicalFish)this.colored.getBukkitEntity();
                return new ListTag(Arrays.asList(fish.getPattern().name(), fish.getBodyColor().name(), fish.getPatternColor().name())).identify();
            }
            case FOX: {
                return ((Fox)this.colored.getBukkitEntity()).getFoxType().name();
            }
            case CAT: {
                Cat cat = (Cat)this.colored.getBukkitEntity();
                return cat.getCatType().name() + "|" + cat.getCollarColor().name();
            }
            case PANDA: {
                Panda panda = (Panda)this.colored.getBukkitEntity();
                return panda.getMainGene().name() + "|" + panda.getHiddenGene().name();
            }
            case VILLAGER: {
                return ((Villager)this.colored.getBukkitEntity()).getVillagerType().name();
            }
            case ZOMBIE_VILLAGER: {
                return ((ZombieVillager)this.colored.getBukkitEntity()).getVillagerType().name();
            }
            case ARROW: {
                try {
                    return new ColorTag(((Arrow)this.colored.getBukkitEntity()).getColor()).identify();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && MultiVersionHelper1_17.colorIsApplicable(type)) {
            return MultiVersionHelper1_17.getColor(this.colored.getBukkitEntity());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type)) {
            return MultiVersionHelper1_19.getColor(this.colored.getBukkitEntity());
        }
        return null;
    }

    public static ListTag listForEnum(Enum<?>[] values) {
        ListTag list = new ListTag(values.length);
        for (Enum<?> obj : values) {
            list.addObject(new ElementTag(obj));
        }
        return list;
    }

    public ListTag getAllowedColors() {
        EntityType type = this.colored.getBukkitEntityType();
        switch (type) {
            case HORSE: {
                ListTag horseColors = EntityColor.listForEnum(Horse.Color.values());
                horseColors.addAll(EntityColor.listForEnum(Horse.Style.values()));
                return horseColors;
            }
            case SHEEP: 
            case WOLF: 
            case SHULKER: {
                return EntityColor.listForEnum(DyeColor.values());
            }
            case RABBIT: {
                return EntityColor.listForEnum(Rabbit.Type.values());
            }
            case LLAMA: 
            case TRADER_LLAMA: {
                return EntityColor.listForEnum(Llama.Color.values());
            }
            case PARROT: {
                return EntityColor.listForEnum(Parrot.Variant.values());
            }
            case MUSHROOM_COW: {
                return EntityColor.listForEnum(MushroomCow.Variant.values());
            }
            case TROPICAL_FISH: {
                ListTag patterns = EntityColor.listForEnum(TropicalFish.Pattern.values());
                patterns.addAll(EntityColor.listForEnum(DyeColor.values()));
                return patterns;
            }
            case FOX: {
                return EntityColor.listForEnum(Fox.Type.values());
            }
            case CAT: {
                return EntityColor.listForEnum(Cat.Type.values());
            }
            case PANDA: {
                return EntityColor.listForEnum(Panda.Gene.values());
            }
            case VILLAGER: 
            case ZOMBIE_VILLAGER: {
                return EntityColor.listForEnum(Villager.Type.values());
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && MultiVersionHelper1_17.colorIsApplicable(type)) {
            return MultiVersionHelper1_17.getAllowedColors(type);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type)) {
            return MultiVersionHelper1_19.getAllowedColors(type);
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        String color = this.getColor(false);
        return color == null ? null : CoreUtilities.toLowerCase(color);
    }

    @Override
    public String getPropertyId() {
        return "color";
    }

    public static void register() {
        PropertyParser.registerTag(EntityColor.class, ListTag.class, "allowed_colors", (attribute, object) -> object.getAllowedColors(), new String[0]);
        PropertyParser.registerTag(EntityColor.class, ElementTag.class, "color", (attribute, object) -> {
            String color = object.getColor(true);
            if (color == null) {
                return null;
            }
            return new ElementTag(CoreUtilities.toLowerCase(color));
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("color")) {
            EntityType type = this.colored.getBukkitEntityType();
            if (type == EntityType.HORSE && mechanism.requireObject(ListTag.class)) {
                ListTag list = mechanism.valueAsType(ListTag.class);
                Horse horse = (Horse)this.colored.getBukkitEntity();
                String color = list.get(0);
                if (new ElementTag(color).matchesEnum(Horse.Color.class)) {
                    horse.setColor(Horse.Color.valueOf((String)color.toUpperCase()));
                } else {
                    mechanism.echoError("Invalid horse color specified: " + color);
                }
                if (list.size() > 1) {
                    String style = list.get(1);
                    if (new ElementTag(style).matchesEnum(Horse.Style.class)) {
                        horse.setStyle(Horse.Style.valueOf((String)style.toUpperCase()));
                    } else {
                        mechanism.echoError("Invalid horse style specified: " + style);
                    }
                }
            } else if (type == EntityType.SHEEP && mechanism.requireEnum(DyeColor.class)) {
                ((Sheep)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.WOLF && mechanism.requireEnum(DyeColor.class)) {
                ((Wolf)this.colored.getBukkitEntity()).setCollarColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.OCELOT && mechanism.requireEnum(Ocelot.Type.class)) {
                ((Ocelot)this.colored.getBukkitEntity()).setCatType(Ocelot.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.RABBIT && mechanism.requireEnum(Rabbit.Type.class)) {
                ((Rabbit)this.colored.getBukkitEntity()).setRabbitType(Rabbit.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if ((type == EntityType.LLAMA || type == EntityType.TRADER_LLAMA) && mechanism.requireEnum(Llama.Color.class)) {
                ((Llama)this.colored.getBukkitEntity()).setColor(Llama.Color.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.PARROT && mechanism.requireEnum(Parrot.Variant.class)) {
                ((Parrot)this.colored.getBukkitEntity()).setVariant(Parrot.Variant.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.SHULKER && mechanism.requireEnum(DyeColor.class)) {
                ((Shulker)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.MUSHROOM_COW && mechanism.requireEnum(MushroomCow.Variant.class)) {
                ((MushroomCow)this.colored.getBukkitEntity()).setVariant(MushroomCow.Variant.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.TROPICAL_FISH && mechanism.requireObject(ListTag.class)) {
                ListTag list = mechanism.valueAsType(ListTag.class);
                TropicalFish fish = (TropicalFish)this.colored.getBukkitEntity();
                String pattern = list.get(0);
                if (new ElementTag(pattern).matchesEnum(TropicalFish.Pattern.class)) {
                    fish.setPattern(TropicalFish.Pattern.valueOf((String)pattern.toUpperCase()));
                } else {
                    mechanism.echoError("Invalid tropical fish pattern specified: " + pattern);
                }
                if (list.size() > 1) {
                    String color = list.get(1);
                    if (new ElementTag(color).matchesEnum(DyeColor.class)) {
                        fish.setBodyColor(DyeColor.valueOf((String)color.toUpperCase()));
                    } else {
                        mechanism.echoError("Invalid color specified: " + color);
                    }
                }
                if (list.size() > 2) {
                    String patternColor = list.get(2);
                    if (new ElementTag(patternColor).matchesEnum(DyeColor.class)) {
                        fish.setPatternColor(DyeColor.valueOf((String)patternColor.toUpperCase()));
                    } else {
                        mechanism.echoError("Invalid pattern color specified: " + patternColor);
                    }
                }
            } else if (type == EntityType.FOX && mechanism.requireEnum(Fox.Type.class)) {
                ((Fox)this.colored.getBukkitEntity()).setFoxType(Fox.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.CAT && mechanism.requireObject(ListTag.class)) {
                Cat cat = (Cat)this.colored.getBukkitEntity();
                ListTag list = mechanism.valueAsType(ListTag.class);
                String catType = list.get(0);
                if (new ElementTag(catType).matchesEnum(Cat.Type.class)) {
                    cat.setCatType(Cat.Type.valueOf((String)catType.toUpperCase()));
                } else {
                    mechanism.echoError("Invalid cat type specified: " + catType);
                }
                if (list.size() > 1) {
                    String color = list.get(1);
                    if (new ElementTag(color).matchesEnum(DyeColor.class)) {
                        cat.setCollarColor(DyeColor.valueOf((String)list.get(1).toUpperCase()));
                    } else {
                        mechanism.echoError("Invalid color specified: " + color);
                    }
                }
            } else if (type == EntityType.PANDA && mechanism.requireObject(ListTag.class)) {
                Panda panda = (Panda)this.colored.getBukkitEntity();
                ListTag list = mechanism.valueAsType(ListTag.class);
                String mainGene = list.get(0);
                if (new ElementTag(mainGene).matchesEnum(Panda.Gene.class)) {
                    panda.setMainGene(Panda.Gene.valueOf((String)mainGene.toUpperCase()));
                } else {
                    mechanism.echoError("Invalid panda gene specified: " + mainGene);
                }
                if (list.size() > 1) {
                    String hiddenGene = list.get(1);
                    if (new ElementTag(hiddenGene).matchesEnum(Panda.Gene.class)) {
                        panda.setHiddenGene(Panda.Gene.valueOf((String)hiddenGene.toUpperCase()));
                    } else {
                        mechanism.echoError("Invalid panda hidden gene specified: " + hiddenGene);
                    }
                }
            } else if (type == EntityType.VILLAGER && mechanism.requireEnum(Villager.Type.class)) {
                ((Villager)this.colored.getBukkitEntity()).setVillagerType(Villager.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.ZOMBIE_VILLAGER && mechanism.requireEnum(Villager.Type.class)) {
                ((ZombieVillager)this.colored.getBukkitEntity()).setVillagerType(Villager.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.ARROW && mechanism.requireObject(ColorTag.class)) {
                ((Arrow)this.colored.getBukkitEntity()).setColor(mechanism.valueAsType(ColorTag.class).getColor());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && MultiVersionHelper1_17.colorIsApplicable(type)) {
                MultiVersionHelper1_17.setColor(this.colored.getBukkitEntity(), mechanism);
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type)) {
                MultiVersionHelper1_19.setColor(this.colored.getBukkitEntity(), mechanism);
            }
        }
    }
}

