/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ArgumentHelper {
    public static String DIGITS = "0123456789";
    public static String PREFIXES = "+-";
    public static String DOUBLE_CHARS = "eE";
    public static AsciiMatcher DIGIT_MATCHER = new AsciiMatcher(DIGITS);
    public static AsciiMatcher INTEGER_MATCHER = new AsciiMatcher(DIGITS + PREFIXES);
    public static AsciiMatcher DOUBLE_SPECIAL_MATCHER = new AsciiMatcher(DOUBLE_CHARS);
    public static AsciiMatcher PREFIX_MATCHER = new AsciiMatcher(PREFIXES);
    public static AsciiMatcher HEX_MATCHER = new AsciiMatcher("abcdefABCDEF0123456789");
    private static final int MIN_LONG_LENGTH = Long.toString(Long.MIN_VALUE).length();
    private static final int MAX_LONG_LENGTH = Long.toString(Long.MAX_VALUE).length();

    public static List<Argument> interpret(ScriptEntry entry, List<String> args) {
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (String string : args) {
            Argument newArg = new Argument(string);
            newArg.scriptEntry = entry;
            arg_list.add(newArg);
        }
        return arg_list;
    }

    public static String[] buildArgs(String stringArgs, boolean tagsContainSpaces) {
        if (stringArgs == null) {
            return null;
        }
        stringArgs = stringArgs.trim();
        stringArgs = stringArgs.replace('\r', ' ').replace('\n', ' ');
        ArrayList<String> matchList = new ArrayList<String>(stringArgs.length() / 6);
        int start = 0;
        int len = stringArgs.length();
        char currentQuote = '\u0000';
        int inTags = 0;
        int inTagParams = 0;
        for (int i = 0; i < len; ++i) {
            char c = stringArgs.charAt(i);
            if (c == ' ' && currentQuote == '\u0000' && inTagParams == 0) {
                if (i > start) {
                    matchList.add(stringArgs.substring(start, i));
                }
                start = i + 1;
                continue;
            }
            if (c == '<' && tagsContainSpaces) {
                if (i + 1 >= len || !TagManager.validTagFirstCharacter.isMatch(stringArgs.charAt(i + 1))) continue;
                ++inTags;
                continue;
            }
            if (c == '>' && inTags > 0) {
                --inTags;
                continue;
            }
            if (c == '[' && inTags > 0) {
                ++inTagParams;
                continue;
            }
            if (c == ']' && inTagParams > 0) {
                --inTagParams;
                continue;
            }
            if (c != '\"' && c != '\'') continue;
            if (currentQuote == '\u0000' && inTagParams == 0) {
                if (i != 0 && stringArgs.charAt(i - 1) != ' ') continue;
                currentQuote = c;
                start = i + 1;
                continue;
            }
            if (currentQuote != c || i + 1 < len && stringArgs.charAt(i + 1) != ' ') continue;
            currentQuote = '\u0000';
            if (i >= start) {
                matchList.add(stringArgs.substring(start, i));
            }
            start = ++i + 1;
        }
        if (start < len) {
            matchList.add(stringArgs.substring(start));
        }
        if (CoreConfiguration.debugScriptBuilder) {
            Debug.log("Constructed args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[0]);
    }

    public static String debuggable(Object value) {
        if (value instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            for (Object obj : (Collection)value) {
                sb.append(obj == null ? "null" : ArgumentHelper.debuggable(obj)).append("<G>,<Y> ");
            }
            if (sb.length() == 0) {
                return ArgumentHelper.debuggable(sb);
            }
            return ArgumentHelper.debuggable("[" + sb.substring(0, sb.length() - "<G>, ".length()) + "<Y>]");
        }
        return value != null ? (value instanceof ObjectTag ? ((ObjectTag)value).debuggable() : value.toString()) : "null";
    }

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + ArgumentHelper.debuggable(value) + "<G>'  ";
    }

    public static boolean matchesDouble(String arg) {
        if (arg.length() == 0) {
            return false;
        }
        if (!INTEGER_MATCHER.isMatch(arg.charAt(0))) {
            return false;
        }
        if (!DIGIT_MATCHER.containsAnyMatch(arg)) {
            return false;
        }
        boolean hadDoubleSyntax = false;
        boolean hadDecimal = false;
        for (int i = 1; i < arg.length(); ++i) {
            if (DIGIT_MATCHER.isMatch(arg.charAt(i))) continue;
            if (hadDoubleSyntax) {
                return false;
            }
            if (arg.charAt(i) == '.' && !hadDecimal) {
                hadDecimal = true;
                continue;
            }
            if (i + 1 < arg.length() && DOUBLE_SPECIAL_MATCHER.isMatch(arg.charAt(i)) && PREFIX_MATCHER.isMatch(arg.charAt(i + 1))) {
                hadDoubleSyntax = true;
                ++i;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesInteger(String arg) {
        if (!INTEGER_MATCHER.isOnlyMatches(arg)) {
            return false;
        }
        if (!ArgumentHelper.matchesDouble(arg)) {
            return false;
        }
        char firstChar = arg.charAt(0);
        return arg.length() <= (firstChar == '-' || firstChar == '+' ? MIN_LONG_LENGTH : MAX_LONG_LENGTH);
    }
}

