/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.commands.server.BossBarCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.tags.core.CustomColorTagBase;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.NotedAreaTracker;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.UtilTagBase;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Art;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.GameRule;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapCursor;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.permissions.DefaultPermissions;

public class ServerTagBase {
    public static HashSet<String> deprecatedServerUtilTags = new HashSet<String>(Arrays.asList("current_time_millis", "real_time_since_start", "delta_time_since_start", "current_tick", "available_processors", "ram_usage", "ram_free", "ram_max", "ram_allocated", "disk_usage", "disk_total", "disk_free", "started_time", "has_file", "list_files", "notes", "last_reload", "scripts", "sql_connections", "java_version", "stack_trace"));

    public ServerTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTagBase.this.serverTag(event);
            }
        }, "server");
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "global", attribute -> {
            BukkitImplDeprecations.globalTagName.warn(attribute.context);
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void serverTag(ReplaceableTagEvent event) {
        block312: {
            BanEntry ban;
            ListTag players;
            ObjectTag worlds;
            NPCTag dNpc;
            Object npcs;
            PlayerTag plTag;
            String matchInput;
            PlayerTag matchPlayer;
            WorldTag world;
            String group;
            Object npc;
            EnchantmentTag ench;
            ListTag enchants;
            ListTag list;
            Object flag;
            ListTag result;
            Object name;
            if (!event.matches("server") || event.replaced()) {
                return;
            }
            com.denizenscript.denizencore.tags.Attribute attribute = event.getAttributes().fulfill(1);
            if (attribute.startsWith("economy")) {
                if (Depends.economy == null) {
                    attribute.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    return;
                }
                if ((attribute = attribute.fulfill(1)).startsWith("format") && attribute.hasParam()) {
                    double amount = attribute.getDoubleParam();
                    event.setReplacedObject(new ElementTag(Depends.economy.format(amount)).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_name") && attribute.hasParam()) {
                    double amount = attribute.getDoubleParam();
                    event.setReplacedObject(new ElementTag(amount == 1.0 ? Depends.economy.currencyNameSingular() : Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_plural")) {
                    event.setReplacedObject(new ElementTag(Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_singular")) {
                    event.setReplacedObject(new ElementTag(Depends.economy.currencyNameSingular()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                return;
            }
            if (attribute.startsWith("slot_id") && attribute.hasParam()) {
                int slotId = SlotHelper.nameToIndex(attribute.getParam(), null);
                if (slotId != -1) {
                    event.setReplacedObject(new ElementTag(slotId).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("parse_bukkit_item") && attribute.hasParam()) {
                YamlConfiguration config = new YamlConfiguration();
                try {
                    config.loadFromString(attribute.getParam());
                    ItemStack item = config.getItemStack("item");
                    if (item != null) {
                        event.setReplacedObject(new ItemTag(item).getObjectAttribute(attribute.fulfill(1)));
                    }
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
                return;
            }
            if (attribute.startsWith("recipe_ids") || attribute.startsWith("list_recipe_ids")) {
                ServerTagBase.listDeprecateWarn(attribute);
                String type = attribute.hasParam() ? CoreUtilities.toLowerCase(attribute.getParam()) : null;
                ListTag list2 = new ListTag();
                if (type == null || !type.equals("brewing")) {
                    Iterator<NamespacedKey> recipeIterator = Bukkit.recipeIterator();
                    while (recipeIterator.hasNext()) {
                        Recipe recipe = (Recipe)recipeIterator.next();
                        if (!Utilities.isRecipeOfType(recipe, type) || !(recipe instanceof Keyed)) continue;
                        Keyed keyed = (Keyed)recipe;
                        list2.add(keyed.getKey().toString());
                    }
                }
                if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && (type == null || type.equals("brewing"))) {
                    for (NamespacedKey brewingRecipe : NMSHandler.itemHelper.getCustomBrewingRecipes().keySet()) {
                        list2.add(brewingRecipe.toString());
                    }
                }
                event.setReplacedObject(list2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("recipe_items") && attribute.hasParam()) {
                ItemHelper.BrewingRecipe brewingRecipe;
                NamespacedKey recipeKey = Utilities.parseNamespacedKey(attribute.getParam());
                Recipe recipe = Bukkit.getRecipe((NamespacedKey)recipeKey);
                ItemHelper.BrewingRecipe brewingRecipe2 = brewingRecipe = Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) ? NMSHandler.itemHelper.getCustomBrewingRecipes().get(recipeKey) : null;
                if (recipe == null && brewingRecipe == null) {
                    return;
                }
                ListTag result2 = new ListTag();
                Consumer<RecipeChoice> consumer = choice -> {
                    if (choice == null) {
                        result2.addObject(new ItemTag(Material.AIR));
                    } else if (choice instanceof RecipeChoice.ExactChoice) {
                        result2.addObject(new ItemTag(choice.getItemStack()));
                    } else {
                        result2.add("material:" + choice.getItemStack().getType().name());
                    }
                };
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    Map choiceMap = shapedRecipe.getChoiceMap();
                    for (String row : shapedRecipe.getShape()) {
                        for (char column : row.toCharArray()) {
                            consumer.accept((RecipeChoice)choiceMap.get(Character.valueOf(column)));
                        }
                    }
                } else if (recipe instanceof ShapelessRecipe) {
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                    for (RecipeChoice choice2 : shapelessRecipe.getChoiceList()) {
                        consumer.accept(choice2);
                    }
                } else if (recipe instanceof CookingRecipe) {
                    CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                    consumer.accept(cookingRecipe.getInputChoice());
                } else if (brewingRecipe != null) {
                    consumer.accept(brewingRecipe.ingredient());
                    consumer.accept(brewingRecipe.input());
                }
                event.setReplacedObject(result2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("recipe_shape") && attribute.hasParam()) {
                Recipe recipe = Bukkit.getRecipe((NamespacedKey)Utilities.parseNamespacedKey(attribute.getParam()));
                if (!(recipe instanceof ShapedRecipe)) {
                    return;
                }
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                String[] shape = shapedRecipe.getShape();
                event.setReplacedObject(new ElementTag(shape[0].length() + "x" + shape.length).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("recipe_type") && attribute.hasParam()) {
                NamespacedKey recipeKey = Utilities.parseNamespacedKey(attribute.getParam());
                Recipe recipe = Bukkit.getRecipe((NamespacedKey)recipeKey);
                if (recipe == null) {
                    if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && NMSHandler.itemHelper.getCustomBrewingRecipes().containsKey(recipeKey)) {
                        event.setReplacedObject(new ElementTag("brewing").getObjectAttribute(attribute.fulfill(1)));
                    }
                    return;
                }
                event.setReplacedObject(new ElementTag(Utilities.getRecipeType(recipe)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("recipe_result") && attribute.hasParam()) {
                NamespacedKey recipeKey = Utilities.parseNamespacedKey(attribute.getParam());
                Recipe recipe = Bukkit.getRecipe((NamespacedKey)recipeKey);
                if (recipe == null) {
                    ItemHelper.BrewingRecipe brewingRecipe;
                    if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && (brewingRecipe = NMSHandler.itemHelper.getCustomBrewingRecipes().get(recipeKey)) != null) {
                        event.setReplacedObject(new ItemTag(brewingRecipe.result()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    return;
                }
                event.setReplacedObject(new ItemTag(recipe.getResult()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("scoreboards")) {
                ListTag result3 = new ListTag();
                for (String board : ScoreboardHelper.scoreboardMap.keySet()) {
                    result3.addObject(new ElementTag(board));
                }
                event.setReplacedObject(result3.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("scoreboard")) {
                Scoreboard board;
                name = "main";
                if (attribute.hasParam()) {
                    name = attribute.getParam();
                    board = ScoreboardHelper.getScoreboard((String)name);
                } else {
                    board = ScoreboardHelper.getMain();
                }
                attribute = attribute.fulfill(1);
                if (attribute.startsWith("exists")) {
                    event.setReplacedObject(new ElementTag(board != null).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (board == null) {
                    attribute.echoError("Scoreboard '" + (String)name + "' does not exist.");
                    return;
                }
                if (attribute.startsWith("objectives")) {
                    ListTag list3 = new ListTag();
                    for (Objective objective : board.getObjectives()) {
                        list3.add(objective.getName());
                    }
                    event.setReplacedObject(list3.getObjectAttribute(attribute.fulfill(1)));
                }
                if (attribute.startsWith("objective") && attribute.hasParam()) {
                    Objective objective = board.getObjective(attribute.getParam());
                    if (objective == null) {
                        attribute.echoError("Scoreboard objective '" + attribute.getParam() + "' does not exist.");
                        return;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("criteria")) {
                        event.setReplacedObject(new ElementTag(objective.getCriteria()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("display_name")) {
                        event.setReplacedObject(new ElementTag(objective.getDisplayName()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("display_slot")) {
                        if (objective.getDisplaySlot() == null) {
                            return;
                        }
                        event.setReplacedObject(new ElementTag((Enum<?>)objective.getDisplaySlot()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("score")) {
                        Object value = attribute.getParam();
                        if (((String)value).startsWith("p@")) {
                            value = PlayerTag.valueOf((String)value, attribute.context).getName();
                        } else if (((String)value).startsWith("e@")) {
                            value = EntityTag.valueOf((String)value, attribute.context).getUUID().toString();
                        }
                        Score score = objective.getScore((String)value);
                        if (!score.isScoreSet()) {
                            return;
                        }
                        event.setReplacedObject(new ElementTag(score.getScore()).getObjectAttribute(attribute.fulfill(1)));
                    }
                }
                if (attribute.startsWith("team_names")) {
                    ListTag result4 = new ListTag();
                    for (Team team : board.getTeams()) {
                        result4.add(team.getName());
                    }
                    event.setReplacedObject(result4.getObjectAttribute(attribute.fulfill(1)));
                }
                if (attribute.startsWith("team") && attribute.hasParam()) {
                    Team team = board.getTeam(attribute.getParam());
                    if (team == null) {
                        attribute.echoError("Scoreboard team '" + attribute.getParam() + "' does not exist.");
                        return;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("members")) {
                        event.setReplacedObject(new ListTag(team.getEntries()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("prefix")) {
                        event.setReplacedObject(new ElementTag(PaperAPITools.instance.getTeamPrefix(team)).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("suffix")) {
                        event.setReplacedObject(new ElementTag(PaperAPITools.instance.getTeamSuffix(team)).getObjectAttribute(attribute.fulfill(1)));
                    }
                    return;
                }
            }
            if (attribute.startsWith("object_is_valid")) {
                BukkitImplDeprecations.serverObjectExistsTags.warn(attribute.context);
                ObjectTag o = ObjectFetcher.pickObjectFor(attribute.getParam(), CoreUtilities.noDebugContext);
                event.setReplacedObject(new ElementTag(o != null && !(o instanceof ElementTag)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_whitelist")) {
                event.setReplacedObject(new ElementTag(Bukkit.hasWhitelist()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("whitelisted_players")) {
                result = new ListTag();
                for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                    result.addObject(new PlayerTag(player));
                }
                event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_flag")) {
                event.setReplacedObject(DenizenCore.serverFlagMap.doHasFlagTag(attribute).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("flag_expiration")) {
                TimeTag exp = DenizenCore.serverFlagMap.doFlagExpirationTag(attribute);
                if (exp != null) {
                    event.setReplacedObject(exp.getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("flag")) {
                flag = DenizenCore.serverFlagMap.doFlagTag(attribute);
                if (flag != null) {
                    event.setReplacedObject(flag.getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("list_flags")) {
                event.setReplacedObject(DenizenCore.serverFlagMap.doListFlagsTag(attribute).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("flag_map")) {
                event.setReplacedObject(DenizenCore.serverFlagMap.doFlagMapTag(attribute).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("gamerules")) {
                ListTag allGameRules = new ListTag();
                for (GameRule gameRule : GameRule.values()) {
                    allGameRules.add(gameRule.getName());
                }
                event.setReplacedObject(allGameRules.getObjectAttribute(attribute.fulfill(1)));
            }
            if ((attribute.startsWith("traits") || attribute.startsWith("list_traits")) && Depends.citizens != null) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allTraits = new ListTag();
                for (TraitInfo trait : CitizensAPI.getTraitFactory().getRegisteredTraits()) {
                    allTraits.add(trait.getTraitName());
                }
                event.setReplacedObject(allTraits.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("commands") || attribute.startsWith("list_commands")) {
                ServerTagBase.listDeprecateWarn(attribute);
                CommandScriptHelper.init();
                list = new ListTag(CommandScriptHelper.knownCommands.keySet());
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("command_plugin")) {
                PluginCommand cmd = Bukkit.getPluginCommand((String)attribute.getParam());
                if (cmd != null) {
                    event.setReplacedObject(new PluginTag(cmd.getPlugin()).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("color_names")) {
                list = new ListTag();
                for (String color : ColorTag.colorsByName.keySet()) {
                    list.add(color);
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("art_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (Art art : Art.values()) {
                    list.add(art.name());
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("advancement_types") || attribute.startsWith("list_advancements")) {
                if (attribute.matches("list_advancements")) {
                    Debug.echoError("list_advancements is deprecated: use advancement_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                Bukkit.advancementIterator().forEachRemaining(adv -> list.add(adv.getKey().toString()));
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("nbt_attribute_types") || attribute.startsWith("list_nbt_attribute_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (Attribute attribute2 : Attribute.values()) {
                    list.add(attribute2.name());
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("damage_causes") || attribute.startsWith("list_damage_causes")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (EntityDamageEvent.DamageCause damageCause : EntityDamageEvent.DamageCause.values()) {
                    list.add(damageCause.name());
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("teleport_causes")) {
                list = new ListTag();
                for (PlayerTeleportEvent.TeleportCause teleportCause : PlayerTeleportEvent.TeleportCause.values()) {
                    list.add(teleportCause.name());
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("biome_types") || attribute.startsWith("list_biome_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allBiomes = new ListTag();
                for (Biome biome : Biome.values()) {
                    if (biome == Biome.CUSTOM) continue;
                    allBiomes.addObject(new BiomeTag(biome));
                }
                event.setReplacedObject(allBiomes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantments")) {
                enchants = new ListTag();
                for (Enchantment enchantment : Enchantment.values()) {
                    enchants.addObject(new EnchantmentTag(enchantment));
                }
                event.setReplacedObject(enchants.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_types") || attribute.startsWith("list_enchantments")) {
                BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
                if (attribute.matches("list_enchantments")) {
                    Debug.echoError("list_enchantments is deprecated: use enchantment_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                enchants = new ListTag();
                for (Enchantment enchantment : Enchantment.values()) {
                    enchants.add(enchantment.getName());
                }
                event.setReplacedObject(enchants.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_keys") || attribute.startsWith("list_enchantment_keys")) {
                BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
                ServerTagBase.listDeprecateWarn(attribute);
                enchants = new ListTag();
                for (Enchantment enchantment : Enchantment.values()) {
                    enchants.add(enchantment.getKey().getKey());
                }
                event.setReplacedObject(enchants.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("entity_types") || attribute.startsWith("list_entity_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allEnt = new ListTag();
                for (EntityType entityType : EntityType.values()) {
                    if (entityType == EntityType.UNKNOWN) continue;
                    allEnt.add(entityType.name());
                }
                event.setReplacedObject(allEnt.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("material_types") || attribute.startsWith("list_material_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allMats = new ListTag();
                for (Material material : Material.values()) {
                    allMats.addObject(new MaterialTag(material));
                }
                event.setReplacedObject(allMats.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("sound_types") || attribute.startsWith("list_sounds")) {
                if (attribute.matches("list_sounds")) {
                    Debug.echoError("list_sounds is deprecated: use sound_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag sounds = new ListTag();
                for (Sound sound : Sound.values()) {
                    sounds.add(sound.toString());
                }
                event.setReplacedObject(sounds.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("particle_types") || attribute.startsWith("list_particles")) {
                if (attribute.matches("list_particles")) {
                    Debug.echoError("list_particles is deprecated: use particle_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag particleTypes = new ListTag();
                for (Particle particle : Particle.values()) {
                    particleTypes.add(particle.toString());
                }
                event.setReplacedObject(particleTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("effect_types") || attribute.startsWith("list_effects")) {
                if (attribute.matches("list_effects")) {
                    Debug.echoError("list_effects is deprecated: use effect_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag effectTypes = new ListTag();
                for (Effect effect : Effect.values()) {
                    effectTypes.add(effect.toString());
                }
                event.setReplacedObject(effectTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("pattern_types") || attribute.startsWith("list_patterns")) {
                if (attribute.matches("list_patterns")) {
                    Debug.echoError("list_patterns is deprecated: use pattern_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allPatterns = new ListTag();
                for (PatternType patternType : PatternType.values()) {
                    allPatterns.add(patternType.toString());
                }
                event.setReplacedObject(allPatterns.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("potion_effect_types") || attribute.startsWith("list_potion_effects")) {
                if (attribute.matches("list_potion_effects")) {
                    Debug.echoError("list_potion_effects is deprecated: use potion_effect_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag statuses = new ListTag();
                for (PotionEffectType potionEffectType : PotionEffectType.values()) {
                    if (potionEffectType == null) continue;
                    statuses.add(potionEffectType.getName());
                }
                event.setReplacedObject(statuses.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("potion_types") || attribute.startsWith("list_potion_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag potionTypes = new ListTag();
                for (PotionType potionType : PotionType.values()) {
                    potionTypes.add(potionType.toString());
                }
                event.setReplacedObject(potionTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("tree_types") || attribute.startsWith("list_tree_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allTrees = new ListTag();
                for (TreeType treeType : TreeType.values()) {
                    allTrees.add(treeType.name());
                }
                event.setReplacedObject(allTrees.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("map_cursor_types") || attribute.startsWith("list_map_cursor_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag mapCursors = new ListTag();
                for (MapCursor.Type type : MapCursor.Type.values()) {
                    mapCursors.add(type.toString());
                }
                event.setReplacedObject(mapCursors.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("world_types") || attribute.startsWith("list_world_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag worldTypes = new ListTag();
                for (WorldType worldType : WorldType.values()) {
                    worldTypes.add(worldType.toString());
                }
                event.setReplacedObject(worldTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("statistic_types") || attribute.startsWith("list_statistics")) {
                void var7_179;
                ServerTagBase.listDeprecateWarn(attribute);
                if (attribute.matches("list_statistics")) {
                    Debug.echoError("list_statistics is deprecated: use statistic_types");
                }
                Statistic.Type type = null;
                if (attribute.hasParam()) {
                    type = Statistic.Type.valueOf((String)attribute.getParam().toUpperCase());
                }
                ListTag statisticTypes = new ListTag();
                Statistic[] color = Statistic.values();
                int value = color.length;
                boolean bl = false;
                while (var7_179 < value) {
                    Statistic stat = color[var7_179];
                    if (type == null || type == stat.getType()) {
                        statisticTypes.add(stat.toString());
                    }
                    ++var7_179;
                }
                event.setReplacedObject(statisticTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("structure_types") || attribute.startsWith("list_structure_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                event.setReplacedObject(new ListTag(StructureType.getStructureTypes().keySet()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("statistic_type") && attribute.hasParam()) {
                Statistic statistic;
                try {
                    statistic = Statistic.valueOf((String)attribute.getParam().toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    attribute.echoError("Statistic '" + attribute.getParam() + "' does not exist: " + ex.getMessage());
                    return;
                }
                event.setReplacedObject(new ElementTag((Enum<?>)statistic.getType()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_max_level") && attribute.hasParam()) {
                BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
                ench = EnchantmentTag.valueOf(attribute.getParam(), attribute.context);
                if (ench == null) {
                    attribute.echoError("Enchantment '" + attribute.getParam() + "' does not exist.");
                    return;
                }
                event.setReplacedObject(new ElementTag(ench.enchantment.getMaxLevel()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_start_level") && attribute.hasParam()) {
                BukkitImplDeprecations.echantmentTagUpdate.warn(attribute.context);
                ench = EnchantmentTag.valueOf(attribute.getParam(), attribute.context);
                if (ench == null) {
                    attribute.echoError("Enchantment '" + attribute.getParam() + "' does not exist.");
                    return;
                }
                event.setReplacedObject(new ElementTag(ench.enchantment.getStartLevel()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_notables") || attribute.startsWith("notables")) {
                BukkitImplDeprecations.serverUtilTags.warn(attribute.context);
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allNotables = new ListTag();
                if (attribute.hasParam()) {
                    Iterator<Object> type = CoreUtilities.toLowerCase(attribute.getParam());
                    for (Map.Entry<String, Class> typeClass : NoteManager.namesToTypes.entrySet()) {
                        if (!((String)((Object)type)).equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                        for (Object notable : NoteManager.getAllType(typeClass.getValue())) {
                            allNotables.addObject((ObjectTag)notable);
                        }
                        break;
                    }
                } else {
                    for (Notable notable : NoteManager.nameToObject.values()) {
                        allNotables.addObject((ObjectTag)((Object)notable));
                    }
                }
                event.setReplacedObject(allNotables.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_sql_connections")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (Map.Entry<String, Connection> entry : SQLCommand.connections.entrySet()) {
                    try {
                        if (!entry.getValue().isClosed()) {
                            list.add(entry.getKey());
                            continue;
                        }
                        SQLCommand.connections.remove(entry.getKey());
                    }
                    catch (SQLException e) {
                        Debug.echoError(attribute.getScriptEntry(), e);
                    }
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_scripts")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag scripts = new ListTag();
                for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
                    scripts.addObject(new ScriptTag(script));
                }
                event.setReplacedObject(scripts.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("start_time")) {
                Deprecations.timeTagRewrite.warn(attribute.context);
                event.setReplacedObject(new DurationTag(CoreUtilities.monotonicMillisToReal(DenizenCore.startTime) / 50L).getObjectAttribute(attribute.fulfill(1)));
            }
            if (deprecatedServerUtilTags.contains(attribute.getAttributeWithoutParam(1))) {
                event.setReplacedObject(UtilTagBase.instance.getObjectAttribute(attribute));
                return;
            }
            if (attribute.startsWith("selected_npc")) {
                npc = ((Citizens)Bukkit.getPluginManager().getPlugin("Citizens")).getNPCSelector().getSelected((CommandSender)Bukkit.getConsoleSender());
                if (npc == null) {
                    return;
                }
                event.setReplacedObject(new NPCTag((NPC)npc).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("npcs_named") || attribute.startsWith("list_npcs_named")) && Depends.citizens != null && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag npcs2 = new ListTag();
                name = attribute.getParam();
                for (NPC npc2 : CitizensAPI.getNPCRegistry()) {
                    if (!CoreUtilities.equalsIgnoreCase(npc2.getName(), (String)name)) continue;
                    npcs2.addObject(new NPCTag(npc2));
                }
                event.setReplacedObject(npcs2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_permissions")) {
                event.setReplacedObject(new ElementTag(Depends.permissions != null && Depends.permissions.isEnabled()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_economy")) {
                event.setReplacedObject(new ElementTag(Depends.economy != null && Depends.economy.isEnabled()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("denizen_version")) {
                event.setReplacedObject(new ElementTag(Denizen.getInstance().getDescription().getVersion()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("bukkit_version")) {
                event.setReplacedObject(new ElementTag(Bukkit.getBukkitVersion()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("version")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getVersion()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("max_players")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getMaxPlayers()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_prefix")) {
                if (Depends.permissions == null) {
                    attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getParam();
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    attribute.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.startsWith("world", 2)) {
                    world = attribute.contextAsType(2, WorldTag.class);
                    if (world != null) {
                        event.setReplacedObject(new ElementTag(Depends.chat.getGroupPrefix(world.getWorld(), group)).getObjectAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplacedObject(new ElementTag(Depends.chat.getGroupPrefix((World)Bukkit.getWorlds().get(0), group)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_suffix")) {
                if (Depends.permissions == null) {
                    attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getParam();
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    attribute.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.startsWith("world", 2)) {
                    world = attribute.contextAsType(2, WorldTag.class);
                    if (world != null) {
                        event.setReplacedObject(new ElementTag(Depends.chat.getGroupSuffix(world.getWorld(), group)).getObjectAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplacedObject(new ElementTag(Depends.chat.getGroupSuffix((World)Bukkit.getWorlds().get(0), group)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("permission_groups") || attribute.startsWith("list_permission_groups")) {
                if (Depends.permissions == null) {
                    attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                ServerTagBase.listDeprecateWarn(attribute);
                event.setReplacedObject(new ListTag(Arrays.asList(Depends.permissions.getGroups())).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("match_player") && attribute.hasParam()) {
                matchPlayer = null;
                matchInput = CoreUtilities.toLowerCase(attribute.getParam());
                if (matchInput.isEmpty()) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String string = CoreUtilities.toLowerCase(player.getName());
                    if (string.equals(matchInput)) {
                        matchPlayer = player;
                        break;
                    }
                    if (!string.contains(matchInput) || matchPlayer != null && !string.startsWith(matchInput)) continue;
                    matchPlayer = player;
                }
                if (matchPlayer != null) {
                    event.setReplacedObject(new PlayerTag((Player)matchPlayer).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("match_offline_player") && attribute.hasParam()) {
                matchPlayer = null;
                matchInput = CoreUtilities.toLowerCase(attribute.getParam());
                if (matchInput.isEmpty()) {
                    return;
                }
                for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                    String string = CoreUtilities.toLowerCase(entry.getKey());
                    if (string.equals(matchInput)) {
                        matchPlayer = new PlayerTag(entry.getValue());
                        break;
                    }
                    if (!string.contains(matchInput)) continue;
                    PlayerTag newMatch = new PlayerTag(entry.getValue());
                    if (matchPlayer == null) {
                        matchPlayer = newMatch;
                        continue;
                    }
                    if (newMatch.isOnline() && !matchPlayer.isOnline()) {
                        matchPlayer = newMatch;
                        continue;
                    }
                    if (!string.startsWith(matchInput) || newMatch.isOnline() != matchPlayer.isOnline()) continue;
                    matchPlayer = newMatch;
                }
                if (matchPlayer != null) {
                    event.setReplacedObject(matchPlayer.getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if ((attribute.startsWith("npcs_assigned") || attribute.startsWith("list_npcs_assigned")) && Depends.citizens != null && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                ScriptTag script = attribute.paramAsType(ScriptTag.class);
                if (script == null || !(script.getContainer() instanceof AssignmentScriptContainer)) {
                    attribute.echoError("Invalid script specified.");
                } else {
                    AssignmentScriptContainer container = (AssignmentScriptContainer)script.getContainer();
                    ListTag npcs3 = new ListTag();
                    for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                        if (!nPC.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)nPC.getOrAddTrait(AssignmentTrait.class)).isAssigned(container)) continue;
                        npcs3.addObject(new NPCTag(nPC));
                    }
                    event.setReplacedObject(npcs3.getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
            }
            if ((attribute.startsWith("online_players_flagged") || attribute.startsWith("list_online_players_flagged")) && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getParam();
                ListTag players2 = new ListTag();
                boolean want = true;
                if (((String)flag).startsWith("!")) {
                    want = false;
                    flag = ((String)flag).substring(1);
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    plTag = new PlayerTag(player);
                    if (plTag.getFlagTracker().hasFlag((String)flag) != want) continue;
                    players2.addObject(plTag);
                }
                event.setReplacedObject(players2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("players_flagged") || attribute.startsWith("list_players_flagged")) && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getParam();
                ListTag players2 = new ListTag();
                boolean want = true;
                if (((String)flag).startsWith("!")) {
                    want = false;
                    flag = ((String)flag).substring(1);
                }
                for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                    plTag = new PlayerTag(entry.getValue());
                    if (plTag.getFlagTracker().hasFlag((String)flag) != want) continue;
                    players2.addObject(plTag);
                }
                event.setReplacedObject(players2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("spawned_npcs_flagged") || attribute.startsWith("list_spawned_npcs_flagged")) && Depends.citizens != null && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getParam();
                npcs = new ListTag();
                boolean want = true;
                if (((String)flag).startsWith("!")) {
                    want = false;
                    flag = ((String)flag).substring(1);
                }
                for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    dNpc = new NPCTag(nPC);
                    if (!dNpc.isSpawned() || dNpc.hasFlag((String)flag) != want) continue;
                    ((ListTag)npcs).addObject(dNpc);
                }
                event.setReplacedObject(((ListTag)npcs).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("npcs_flagged") || attribute.startsWith("list_npcs_flagged")) && Depends.citizens != null && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getParam();
                npcs = new ListTag();
                boolean want = true;
                if (((String)flag).startsWith("!")) {
                    want = false;
                    flag = ((String)flag).substring(1);
                }
                for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    dNpc = new NPCTag(nPC);
                    if (dNpc.hasFlag((String)flag) != want) continue;
                    ((ListTag)npcs).addObject(dNpc);
                }
                event.setReplacedObject(((ListTag)npcs).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("npc_registries") && Depends.citizens != null) {
                result = new ListTag();
                for (NPCRegistry registry2 : CitizensAPI.getNPCRegistries()) {
                    result.add(registry2.getName());
                }
                event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("npcs") || attribute.startsWith("list_npcs")) && Depends.citizens != null) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag npcs2 = new ListTag();
                Object registry = CitizensAPI.getNPCRegistry();
                if (attribute.hasParam() && (registry = NPCTag.getRegistryByName(attribute.getParam())) == null) {
                    attribute.echoError("NPC Registry '" + attribute.getParam() + "' does not exist.");
                    return;
                }
                Iterator registry2 = registry.iterator();
                while (registry2.hasNext()) {
                    NPC npc6 = (NPC)registry2.next();
                    npcs2.addObject(new NPCTag(npc6));
                }
                event.setReplacedObject(npcs2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("worlds") || attribute.startsWith("list_worlds")) {
                ServerTagBase.listDeprecateWarn(attribute);
                worlds = new ListTag();
                for (World world3 : Bukkit.getWorlds()) {
                    ((ListTag)worlds).addObject(WorldTag.mirrorBukkitWorld(world3));
                }
                event.setReplacedObject(((ListTag)worlds).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("plugins") || attribute.startsWith("list_plugins")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag plugins = new ListTag();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.addObject(new PluginTag(plugin));
                }
                event.setReplacedObject(plugins.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("players") || attribute.startsWith("list_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("online_players") || attribute.startsWith("list_online_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.addObject(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("offline_players") || attribute.startsWith("list_offline_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (offlinePlayer.isOnline()) continue;
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("banned_players") || attribute.startsWith("list_banned_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag banned = new ListTag();
                for (OfflinePlayer player : Bukkit.getBannedPlayers()) {
                    banned.addObject(PlayerTag.mirrorBukkitPlayer(player));
                }
                event.setReplacedObject(banned.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("banned_addresses") || attribute.startsWith("list_banned_addresses")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                list.addAll(Bukkit.getIPBans());
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("is_banned") && attribute.hasParam()) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getParam());
                if (ban == null) {
                    event.setReplacedObject(new ElementTag(false).getObjectAttribute(attribute.fulfill(1)));
                } else if (ban.getExpiration() == null) {
                    event.setReplacedObject(new ElementTag(true).getObjectAttribute(attribute.fulfill(1)));
                } else {
                    event.setReplacedObject(new ElementTag(ban.getExpiration().after(new Date())).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("ban_info") && attribute.hasParam()) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getParam());
                attribute.fulfill(1);
                if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                    return;
                }
                if (attribute.startsWith("expiration_time") && ban.getExpiration() != null) {
                    event.setReplacedObject(new TimeTag(ban.getExpiration().getTime()).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("expiration") && ban.getExpiration() != null) {
                    Deprecations.timeTagRewrite.warn(attribute.context);
                    event.setReplacedObject(new DurationTag(ban.getExpiration().getTime() / 50L).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("reason")) {
                    event.setReplacedObject(new ElementTag(ban.getReason()).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("created_time")) {
                    event.setReplacedObject(new TimeTag(ban.getCreated().getTime()).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("created")) {
                    Deprecations.timeTagRewrite.warn(attribute.context);
                    event.setReplacedObject(new DurationTag(ban.getCreated().getTime() / 50L).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("source")) {
                    event.setReplacedObject(new ElementTag(ban.getSource()).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("ops") || attribute.startsWith("list_ops")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer player : Bukkit.getOperators()) {
                    players.addObject(PlayerTag.mirrorBukkitPlayer(player));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("online_ops") || attribute.startsWith("list_online_ops")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer player : Bukkit.getOperators()) {
                    if (!player.isOnline()) continue;
                    players.addObject(PlayerTag.mirrorBukkitPlayer(player));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("offline_ops") || attribute.startsWith("list_offline_ops")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.isOp() || offlinePlayer.isOnline()) continue;
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("motd")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getMotd()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("view_distance")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getViewDistance()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("entity_is_spawned") && attribute.hasParam()) {
                BukkitImplDeprecations.isValidTag.warn(attribute.context);
                EntityTag ent = EntityTag.valueOf(attribute.getParam(), CoreUtilities.noDebugContext);
                event.setReplacedObject(new ElementTag(ent != null && ent.isUnique() && ent.isSpawnedOrValidForTag() ? "true" : "false").getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("player_is_valid") && attribute.hasParam()) {
                BukkitImplDeprecations.isValidTag.warn(attribute.context);
                event.setReplacedObject(new ElementTag(PlayerTag.playerNameIsValid(attribute.getParam())).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("npc_is_valid") && attribute.hasParam()) {
                BukkitImplDeprecations.isValidTag.warn(attribute.context);
                npc = NPCTag.valueOf(attribute.getParam(), CoreUtilities.noDebugContext);
                event.setReplacedObject(new ElementTag(npc != null && ((NPCTag)npc).isValid()).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("current_bossbars")) {
                ListTag dl = new ListTag(BossBarCommand.bossBarMap.keySet());
                event.setReplacedObject(dl.getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("bossbar_viewers") && attribute.hasParam()) {
                BossBar bar = BossBarCommand.bossBarMap.get(CoreUtilities.toLowerCase(attribute.getParam()));
                if (bar != null) {
                    list = new ListTag();
                    for (Player player : bar.getPlayers()) {
                        ((ListTag)list).addObject(new PlayerTag(player));
                    }
                    event.setReplacedObject(((ListTag)list).getObjectAttribute(attribute.fulfill(1)));
                }
            } else if (attribute.startsWith("recent_tps")) {
                list = new ListTag();
                for (double d : NMSHandler.instance.getRecentTps()) {
                    list.addObject(new ElementTag(d));
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("port")) {
                event.setReplacedObject(new ElementTag(NMSHandler.instance.getPort()).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("debug_enabled")) {
                event.setReplacedObject(new ElementTag(CoreConfiguration.shouldShowDebug).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("idle_timeout")) {
                event.setReplacedObject(new DurationTag(Bukkit.getIdleTimeout() * 60).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("vanilla_entity_tags")) {
                event.setReplacedObject(new ListTag(VanillaTagHelper.entityTagsByKey.keySet()).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("vanilla_tagged_entities")) {
                if (!attribute.hasParam()) {
                    return;
                }
                HashSet<EntityType> types = VanillaTagHelper.entityTagsByKey.get(CoreUtilities.toLowerCase(attribute.getParam()));
                if (types == null) {
                    return;
                }
                list = new ListTag();
                for (EntityType type : types) {
                    ((ListTag)list).addObject(new EntityTag(type));
                }
                event.setReplacedObject(((ListTag)list).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("vanilla_material_tags") || attribute.startsWith("vanilla_tags")) {
                event.setReplacedObject(new ListTag(VanillaTagHelper.materialTagsByKey.keySet()).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("vanilla_tagged_materials")) {
                if (!attribute.hasParam()) {
                    return;
                }
                HashSet<Material> materials = VanillaTagHelper.materialTagsByKey.get(CoreUtilities.toLowerCase(attribute.getParam()));
                if (materials == null) {
                    return;
                }
                list = new ListTag();
                for (Material material : materials) {
                    ((ListTag)list).addObject(new MaterialTag(material));
                }
                event.setReplacedObject(((ListTag)list).getObjectAttribute(attribute.fulfill(1)));
            } else if ((attribute.matches("plugins_handling_event") || attribute.matches("list_plugins_handling_event")) && attribute.hasParam()) {
                ServerTagBase.listDeprecateWarn(attribute);
                String eventName = attribute.getParam();
                if (CoreUtilities.contains(eventName, '.')) {
                    try {
                        Class<?> clazz = Class.forName(eventName, false, ServerTagBase.class.getClassLoader());
                        ListTag result5 = ServerTagBase.getHandlerPluginList(clazz);
                        if (result5 != null) {
                            event.setReplacedObject(result5.getObjectAttribute(attribute.fulfill(1)));
                        }
                        break block312;
                    }
                    catch (ClassNotFoundException ex) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError(ex);
                        }
                        break block312;
                    }
                }
                ScriptEvent scriptEvent = ScriptEvent.eventLookup.get(CoreUtilities.toLowerCase(eventName));
                if (scriptEvent instanceof Listener) {
                    Denizen plugin = Denizen.getInstance();
                    for (Class clazz : plugin.getPluginLoader().createRegisteredListeners((Listener)scriptEvent, (Plugin)plugin).keySet()) {
                        ListTag result6 = ServerTagBase.getHandlerPluginList(clazz);
                        if (result6 == null || result6.size() <= 0) continue;
                        event.setReplacedObject(result6.getObjectAttribute(attribute.fulfill(1)));
                        return;
                    }
                    event.setReplacedObject(new ListTag().getObjectAttribute(attribute.fulfill(1)));
                }
            } else if (attribute.startsWith("generate_loot_table") && attribute.hasParam()) {
                Collection items;
                MapTag map = attribute.inputParameterMap();
                ElementTag idObj = map.getRequiredObjectAs("id", ElementTag.class, attribute);
                LocationTag locationObj = map.getRequiredObjectAs("location", LocationTag.class, attribute);
                if (idObj == null || locationObj == null) {
                    return;
                }
                NamespacedKey key = NamespacedKey.fromString((String)CoreUtilities.toLowerCase(idObj.toString()));
                if (key == null) {
                    return;
                }
                LootTable lootTable = Bukkit.getLootTable((NamespacedKey)key);
                LootContext.Builder context = new LootContext.Builder((Location)locationObj);
                EntityTag killer = map.getObjectAs("killer", EntityTag.class, attribute.context);
                ElementTag luck = map.getElement("luck");
                ElementTag bonus = map.getElement("loot_bonus");
                EntityTag entity = map.getObjectAs("entity", EntityTag.class, attribute.context);
                if (entity != null) {
                    context = context.lootedEntity(entity.getBukkitEntity());
                }
                if (killer != null) {
                    context = context.killer((HumanEntity)killer.getLivingEntity());
                }
                if (luck != null) {
                    context = context.luck(luck.asElement().asFloat());
                }
                if (bonus != null) {
                    context = context.lootingModifier(bonus.asElement().asInt());
                }
                try {
                    items = lootTable.populateLoot(CoreUtilities.getRandom(), context.build());
                }
                catch (Throwable ex) {
                    attribute.echoError("Loot table failed to generate: " + ex.getMessage());
                    if (CoreConfiguration.debugVerbose) {
                        attribute.echoError(ex);
                    }
                    return;
                }
                ListTag result7 = new ListTag();
                for (ItemStack item : items) {
                    result7.addObject(new ItemTag(item));
                }
                event.setReplacedObject(result7.getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("area_notes_debug")) {
                worlds = new MapTag();
                for (Map.Entry<String, NotedAreaTracker.PerWorldSet> set : NotedAreaTracker.worlds.entrySet()) {
                    MapTag worldData = new MapTag();
                    worldData.putObject("global", new ListTag(set.getValue().globalSet.list.stream().map(t -> t.area).collect(Collectors.toList())));
                    worldData.putObject("x50", ServerTagBase.areaNotesDebugStreamHack(set.getValue().sets50));
                    worldData.putObject("x50_offset", ServerTagBase.areaNotesDebugStreamHack(set.getValue().sets50_offset));
                    worldData.putObject("x200", ServerTagBase.areaNotesDebugStreamHack(set.getValue().sets200));
                    worldData.putObject("x200_offset", ServerTagBase.areaNotesDebugStreamHack(set.getValue().sets200_offset));
                    ((MapTag)worlds).putObject(set.getKey(), worldData);
                }
                event.setReplacedObject(((MapTag)worlds).getObjectAttribute(attribute.fulfill(1)));
            }
        }
    }

    private static MapTag areaNotesDebugStreamHack(Int2ObjectOpenHashMap<NotedAreaTracker.AreaSet> set) {
        MapTag out = new MapTag();
        for (Map.Entry pair : set.entrySet()) {
            out.putObject(String.valueOf(pair.getKey()), new ListTag(((NotedAreaTracker.AreaSet)pair.getValue()).list.stream().map(t -> t.area).collect(Collectors.toList())));
        }
        return out;
    }

    public static void listDeprecateWarn(com.denizenscript.denizencore.tags.Attribute attribute) {
        if (CoreConfiguration.futureWarningsEnabled && attribute.getAttribute(1).startsWith("list_")) {
            BukkitImplDeprecations.listStyleTags.warn(attribute.context);
            Debug.echoError("Tag '" + attribute.getAttribute(1) + "' is deprecated: remove the 'list_' prefix.");
        }
    }

    public static ListTag getHandlerPluginList(Class eventClass) {
        HandlerList handlers;
        if (Event.class.isAssignableFrom(eventClass) && (handlers = BukkitScriptEvent.getEventListeners(eventClass)) != null) {
            ListTag result = new ListTag();
            HashSet<String> deduplicationSet = new HashSet<String>();
            for (RegisteredListener listener : handlers.getRegisteredListeners()) {
                if (!deduplicationSet.add(listener.getPlugin().getName())) continue;
                result.addObject(new PluginTag(listener.getPlugin()));
            }
            return result;
        }
        return null;
    }

    public static void adjustServer(Mechanism mechanism) {
        MapTag map;
        if (mechanism.matches("clean_flags")) {
            DenizenCore.serverFlagMap.doTotalClean();
        }
        if (mechanism.matches("delete_file") && mechanism.hasValue()) {
            if (!Settings.allowDelete()) {
                Debug.echoError("File deletion disabled by administrator (refer to mechanism documentation).");
                return;
            }
            File file = new File(Denizen.getInstance().getDataFolder(), mechanism.getValue().asString());
            if (!Utilities.canWriteToFile(file)) {
                Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
                return;
            }
            try {
                if (!file.delete()) {
                    Debug.echoError("Failed to delete file: returned false");
                }
            }
            catch (Exception exception) {
                Debug.echoError("Failed to delete file: " + exception.getMessage());
            }
        }
        if (mechanism.matches("reset_event_stats")) {
            for (ScriptEvent scriptEvent : ScriptEvent.events) {
                scriptEvent.eventData.stats_fires = 0L;
                scriptEvent.eventData.stats_scriptFires = 0L;
                scriptEvent.eventData.stats_nanoTimes = 0L;
            }
        }
        if (mechanism.matches("reset_recipes")) {
            Bukkit.resetRecipes();
            Denizen denizen = Denizen.getInstance();
            denizen.itemScriptHelper.rebuildRecipes();
        }
        if (mechanism.matches("remove_recipes")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            for (String str : list) {
                NMSHandler.itemHelper.removeRecipe(Utilities.parseNamespacedKey(str));
            }
        }
        if (mechanism.matches("idle_timeout") && mechanism.requireObject(DurationTag.class)) {
            Bukkit.setIdleTimeout((int)((int)Math.round(mechanism.valueAsType(DurationTag.class).getSeconds() / 60.0)));
        }
        if (mechanism.matches("cleanmem")) {
            System.gc();
        }
        if (mechanism.matches("restart")) {
            if (!Settings.allowServerRestart()) {
                Debug.echoError("Server restart disabled by administrator (refer to mechanism documentation). Consider using 'shutdown'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server restarted by a Denizen script, see config to prevent this!");
            Bukkit.spigot().restart();
        }
        if (mechanism.matches("save")) {
            DenizenCore.saveAll();
            Denizen.getInstance().saveSaves(false);
        }
        if (Depends.citizens != null && mechanism.matches("save_citizens")) {
            Depends.citizens.storeNPCs();
        }
        if (mechanism.matches("shutdown")) {
            if (!Settings.allowServerStop()) {
                Debug.echoError("Server stop disabled by administrator (refer to mechanism documentation). Consider using 'restart'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server shutdown by a Denizen script, see config to prevent this!");
            Bukkit.shutdown();
        }
        if (mechanism.matches("has_whitelist") && mechanism.requireBoolean()) {
            Bukkit.setWhitelist((boolean)mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("register_permission") && mechanism.requireObject(MapTag.class)) {
            PermissionDefault actualDef;
            map = mechanism.valueAsType(MapTag.class);
            ElementTag elementTag = map.getElement("name");
            ElementTag parent = map.getElement("parent");
            ElementTag mode = map.getElement("default");
            ElementTag description = map.getElement("description");
            Permission actualParent = parent == null ? null : Bukkit.getPluginManager().getPermission(parent.toString());
            PermissionDefault permissionDefault = actualDef = mode == null ? null : mode.asElement().asEnum(PermissionDefault.class);
            if (actualParent == null) {
                DefaultPermissions.registerPermission((String)elementTag.toString(), (String)(description == null ? null : description.toString()), (PermissionDefault)actualDef);
            } else {
                DefaultPermissions.registerPermission((String)elementTag.toString(), (String)(description == null ? null : description.toString()), (PermissionDefault)actualDef, (Permission)actualParent);
            }
        }
        if (mechanism.matches("default_colors") && mechanism.requireObject(MapTag.class)) {
            map = mechanism.valueAsType(MapTag.class);
            for (Map.Entry<StringHolder, ObjectTag> pair : map.map.entrySet()) {
                String name = pair.getKey().low;
                if (CustomColorTagBase.customColors.containsKey(name)) continue;
                CustomColorTagBase.customColors.put(name, pair.getValue().toString().replace("<", "<&lt>"));
            }
        }
    }
}

