/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;

public class EntityAge
extends EntityProperty {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Ageable;
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.getAgeable().getAge() + (this.getLock() ? "|locked" : ""));
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    public EntityAge(EntityTag entity) {
        super(entity);
    }

    public void setAge(int val) {
        if (((EntityTag)this.object).isCitizensNPC()) {
            ((Age)((EntityTag)this.object).getDenizenNPC().getCitizen().getOrAddTrait(Age.class)).setAge(val);
        } else {
            this.getAgeable().setAge(val);
        }
    }

    public void setLock(boolean bool) {
        Entity entity = this.getEntity();
        if (entity instanceof Breedable) {
            Breedable breedable = (Breedable)entity;
            breedable.setAgeLock(bool);
        }
    }

    public boolean getLock() {
        Breedable breedable;
        Entity entity = this.getEntity();
        return !(entity instanceof Breedable) || (breedable = (Breedable)entity).getAgeLock();
    }

    public Ageable getAgeable() {
        return (Ageable)this.getEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityAge.class, ElementTag.class, "age", (attribute, prop) -> new ElementTag(prop.getAgeable().getAge()), new String[0]);
        PropertyParser.registerTag(EntityAge.class, ElementTag.class, "is_age_locked", (attribute, prop) -> new ElementTag(prop.getLock()), new String[0]);
        PropertyParser.registerTag(EntityAge.class, ElementTag.class, "is_baby", (attribute, prop) -> new ElementTag(!prop.getAgeable().isAdult()), new String[0]);
        PropertyParser.registerMechanism(EntityAge.class, ElementTag.class, "age_lock", (prop, mechanism, param) -> {
            if (mechanism.requireBoolean()) {
                prop.setLock(param.asBoolean());
            }
        }, new String[0]);
        PropertyParser.registerMechanism(EntityAge.class, ListTag.class, "age", (prop, mechanism, param) -> {
            if (param.isEmpty()) {
                mechanism.echoError("Missing value for 'age' mechanism!");
                return;
            }
            String input = param.get(0);
            if (input.equalsIgnoreCase("baby")) {
                prop.setAge(-24000);
            } else if (input.equalsIgnoreCase("adult")) {
                prop.setAge(0);
            } else if (ArgumentHelper.matchesInteger(input)) {
                prop.setAge(new ElementTag(input).asInt());
            } else {
                mechanism.echoError("Invalid age '" + input + "': must be 'baby', 'adult', or a valid age number.");
            }
            if (param.size() > 1) {
                input = param.get(1);
                if (input.equalsIgnoreCase("locked")) {
                    prop.setLock(true);
                } else if (input.equalsIgnoreCase("unlocked")) {
                    prop.setLock(false);
                } else {
                    mechanism.echoError("Invalid lock state '" + input + "': must be 'locked' or 'unlocked'.");
                }
            }
        }, new String[0]);
    }
}

