/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.commands.core.WebServerCommand;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebserverWebRequestScriptEvent
extends ScriptEvent {
    public static WebserverWebRequestScriptEvent instance;
    public WebServerCommand.WebserverInstance server;
    public HttpExchange exchange;
    public WebResponse response;
    public static HashMap<String, byte[]> responseFileCache;
    public static HashMap<String, ParseableTag> responseParseableCache;

    public byte[] getBody() {
        if (this.response.inputBody != null) {
            return this.response.inputBody;
        }
        try {
            int len;
            InputStream stream = this.exchange.getRequestBody();
            if (stream == null) {
                return null;
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer, 0, 1024)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            this.response.inputBody = bytesOut.toByteArray();
            bytesOut.close();
            return this.response.inputBody;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public void destroy() {
        responseFileCache.clear();
        responseParseableCache.clear();
    }

    public WebserverWebRequestScriptEvent() {
        instance = this;
        this.registerCouldMatcher("webserver web request");
        this.registerSwitches("port", "path", "method", "has_response");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.switches.containsKey("method") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "method", this.exchange.getRequestMethod())) {
            return false;
        }
        if (path.switches.containsKey("port") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "port", String.valueOf(this.server.port))) {
            return false;
        }
        if (path.switches.containsKey("path") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "path", this.exchange.getRequestURI().getPath())) {
            return false;
        }
        if (path.switches.containsKey("has_response") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "has_response", String.valueOf(this.response.hasResponse))) {
            return false;
        }
        return super.matches(path);
    }

    public static byte[] readFileContent(File f) throws IOException {
        FileInputStream input = new FileInputStream(f);
        byte[] result = input.readAllBytes();
        input.close();
        return result;
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String determinationLow = CoreUtilities.toLowerCase(determination);
            int colon = determination.indexOf(58);
            if (colon == -1) {
                return super.applyDetermination(path, determinationObj);
            }
            String prefix = determinationLow.substring(0, colon);
            String data = determination.substring(colon + 1);
            switch (prefix) {
                case "code": {
                    if (!new ElementTag(data).isInt()) {
                        Debug.echoError("Invalid code '" + data + "': not a number.");
                        return true;
                    }
                    this.response.code = new ElementTag(data).asInt();
                    return true;
                }
                case "headers": {
                    TagContext context = this.getTagContext(path);
                    MapTag map = MapTag.valueOf(data, context);
                    if (map == null) {
                        Debug.echoError("Invalid headers map input (not a MapTag)");
                        return true;
                    }
                    for (Map.Entry<StringHolder, ObjectTag> header : map.map.entrySet()) {
                        this.exchange.getResponseHeaders().set(header.getKey().str, header.getValue().toString());
                    }
                    return true;
                }
            }
            if (!this.response.hasResponse) {
                switch (prefix) {
                    case "raw_text_content": {
                        this.response.hasResponse = true;
                        this.response.rawContent = data.getBytes(StandardCharsets.UTF_8);
                        return true;
                    }
                    case "raw_binary_content": {
                        this.response.hasResponse = true;
                        this.response.rawContent = BinaryTag.valueOf((String)data, (TagContext)this.getTagContext((ScriptEvent.ScriptPath)path)).data;
                        return true;
                    }
                    case "file": 
                    case "parsed_file": 
                    case "cached_parsed_file": 
                    case "parsed_cached_file": 
                    case "cached_file": {
                        File file;
                        this.response.hasResponse = true;
                        File root = new File(DenizenCore.implementation.getDataFolder(), CoreConfiguration.webserverRoot);
                        boolean isCaching = prefix.contains("cached_");
                        boolean isParsing = prefix.contains("parsed_");
                        if (isCaching) {
                            ParseableTag tag;
                            if (isParsing && (tag = responseParseableCache.get(data)) != null) {
                                this.response.cachedFile = tag.parse(this.getTagContext(path)).identify().getBytes(StandardCharsets.UTF_8);
                                return true;
                            }
                            byte[] cached = responseFileCache.get(data);
                            this.response.cachedFile = cached;
                            if (cached != null) {
                                if (isParsing) {
                                    ParseableTag tag2 = TagManager.parseTextToTagInternal(new String(this.response.cachedFile, StandardCharsets.UTF_8), this.getTagContext(path), true);
                                    responseParseableCache.put(data, tag2);
                                    this.response.cachedFile = tag2.parse(this.getTagContext(path)).identify().getBytes(StandardCharsets.UTF_8);
                                }
                                return true;
                            }
                        }
                        if (!DenizenCore.implementation.canReadFile(file = new File(root, data))) {
                            Debug.echoError("File path '" + data + "' is not permitted for access by the Denizen config file.");
                            return true;
                        }
                        try {
                            if (!file.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                                Debug.echoError("File path '" + data + "' is not within the web root.");
                                return true;
                            }
                        }
                        catch (IOException ex) {
                            Debug.echoError(ex);
                            return true;
                        }
                        if (isCaching || isParsing) {
                            try {
                                this.response.cachedFile = WebserverWebRequestScriptEvent.readFileContent(file);
                            }
                            catch (IOException ex) {
                                Debug.echoError(ex);
                                return true;
                            }
                            if (isCaching) {
                                responseFileCache.put(data, this.response.cachedFile);
                            }
                            if (isParsing) {
                                ParseableTag tag = TagManager.parseTextToTagInternal(new String(this.response.cachedFile, StandardCharsets.UTF_8), this.getTagContext(path), true);
                                if (isCaching) {
                                    responseParseableCache.put(data, tag);
                                }
                                this.response.cachedFile = tag.parse(this.getTagContext(path)).identify().getBytes(StandardCharsets.UTF_8);
                            }
                        } else {
                            this.response.fileResponse = file;
                        }
                        return true;
                    }
                }
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "method" -> new ElementTag(this.exchange.getRequestMethod(), true);
            case "path" -> new ElementTag(this.exchange.getRequestURI().getPath(), true);
            case "port" -> new ElementTag(this.server.port);
            case "remote_address" -> new ElementTag(this.exchange.getRemoteAddress().toString(), true);
            case "query" -> {
                MapTag output = new MapTag();
                String query = this.exchange.getRequestURI().getRawQuery();
                if (query != null) {
                    for (String pair : CoreUtilities.split(query, '&')) {
                        List<String> parts = CoreUtilities.split(pair, '=', 2);
                        output.putObject(URLDecoder.decode(parts.get(0), StandardCharsets.UTF_8), new ElementTag(URLDecoder.decode(parts.get(1), StandardCharsets.UTF_8), true));
                    }
                }
                yield output;
            }
            case "raw_query" -> {
                if (this.exchange.getRequestURI().getRawQuery() == null) {
                    yield null;
                }
                yield new ElementTag(this.exchange.getRequestURI().getRawQuery(), true);
            }
            case "raw_user_info" -> {
                if (this.exchange.getRequestURI().getRawUserInfo() == null) {
                    yield null;
                }
                yield new ElementTag(this.exchange.getRequestURI().getRawUserInfo(), null);
            }
            case "headers" -> {
                MapTag output = new MapTag();
                for (Map.Entry<String, List<String>> header : this.exchange.getRequestHeaders().entrySet()) {
                    output.putObject(header.getKey(), new ListTag((Collection<String>)header.getValue(), true));
                }
                yield output;
            }
            case "has_response" -> new ElementTag(this.response.hasResponse);
            case "body" -> new ElementTag(new String(this.getBody(), StandardCharsets.UTF_8));
            case "body_binary" -> new BinaryTag(this.getBody());
            default -> super.getContext(name);
        };
    }

    public static void fire(WebServerCommand.WebserverInstance server, HttpExchange exchange) {
        WebserverWebRequestScriptEvent.instance.server = server;
        WebserverWebRequestScriptEvent.instance.exchange = exchange;
        WebResponse response = WebserverWebRequestScriptEvent.instance.response = new WebResponse();
        instance.fire();
        DenizenCore.runAsync(() -> {
            block2: {
                try {
                    byte[] body = response.rawContent != null ? response.rawContent : (response.cachedFile != null ? response.cachedFile : (response.fileResponse != null ? WebserverWebRequestScriptEvent.readFileContent(response.fileResponse) : new byte[]{}));
                    exchange.sendResponseHeaders(response.code, body.length);
                    OutputStream os = exchange.getResponseBody();
                    os.write(body);
                    os.close();
                    exchange.close();
                }
                catch (Throwable ex) {
                    if (server.ignoreErrors && ex instanceof IOException) break block2;
                    Debug.echoError(ex);
                }
            }
        });
    }

    static {
        responseFileCache = new HashMap();
        responseParseableCache = new HashMap();
    }

    public static class WebResponse {
        public int code = 200;
        public byte[] rawContent;
        public File fileResponse;
        public byte[] cachedFile;
        public boolean hasResponse = false;
        public byte[] inputBody;
    }
}

