/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;

public class EntityAge
extends EntityProperty {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Ageable;
    }

    public EntityAge(EntityTag entity) {
        super(entity);
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.as(Ageable.class).getAge());
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    public void setAge(int age) {
        if (((EntityTag)this.object).isCitizensNPC()) {
            ((Age)((EntityTag)this.object).getDenizenNPC().getCitizen().getOrAddTrait(Age.class)).setAge(age);
        } else {
            this.as(Ageable.class).setAge(age);
        }
    }

    public static void register() {
        PropertyParser.registerTag(EntityAge.class, ElementTag.class, "is_baby", (attribute, prop) -> new ElementTag(!prop.as(Ageable.class).isAdult()), new String[0]);
        PropertyParser.registerTag(EntityAge.class, ElementTag.class, "age", (attribute, prop) -> new ElementTag(prop.as(Ageable.class).getAge()), new String[0]);
        PropertyParser.registerMechanism(EntityAge.class, ListTag.class, "age", (prop, mechanism, param) -> {
            String input;
            if (param.isEmpty()) {
                mechanism.echoError("Missing value for 'age' mechanism!");
                return;
            }
            switch (input = CoreUtilities.toLowerCase(param.get(0))) {
                case "baby": {
                    prop.setAge(-24000);
                    break;
                }
                case "adult": {
                    prop.setAge(0);
                    break;
                }
                default: {
                    if (!ArgumentHelper.matchesInteger(input)) {
                        mechanism.echoError("Invalid age '" + input + "': must be 'baby', 'adult', or a valid age number.");
                        return;
                    }
                    prop.setAge(new ElementTag(input).asInt());
                }
            }
            if (param.size() > 1) {
                BukkitImplDeprecations.oldAgeLockedControls.warn(mechanism.context);
                Entity patt3855$temp = prop.getEntity();
                if (!(patt3855$temp instanceof Breedable)) {
                    return;
                }
                Breedable breedable = (Breedable)patt3855$temp;
                switch (CoreUtilities.toLowerCase(param.get(1))) {
                    case "locked": {
                        breedable.setAgeLock(true);
                        break;
                    }
                    case "unlocked": {
                        breedable.setAgeLock(false);
                        break;
                    }
                    default: {
                        mechanism.echoError("Invalid lock state '" + param.get(1) + "': must be 'locked' or 'unlocked'.");
                    }
                }
            }
        }, new String[0]);
    }
}

